/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ProtobufResultSet;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ChecksumResultSet;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtocolMessageEnum;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ChecksumResultSetTest {
    private static final Struct DIFFERENT_NON_NULL_VALUES = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("boolVal").to(false)).set("longVal").to(4L)).set("doubleVal").to(Value.float64((double)6.28))).set("floatVal").to(Value.float32((float)9.42f))).set("bigDecimalVal").to(Value.numeric((BigDecimal)BigDecimal.valueOf(246L, 2)))).set("pgNumericVal").to(Value.pgNumeric((String)"2.46"))).set("stringVal").to("testtest")).set("jsonVal").to(Value.json((String)"{\"color\":\"red\",\"value\":\"#ff0\"}"))).set("pgJsonbVal").to(Value.pgJsonb((String)"{\"color\":\"red\",\"value\":\"#00f\"}"))).set("pgOidVal").to(Value.pgOid((long)4L))).set("protoMessageVal").to((AbstractMessage)SingerProto.SingerInfo.newBuilder().setSingerId(23L).build())).set("protoEnumVal").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((byte[])"bytes".getBytes(StandardCharsets.UTF_8))))).set("timestamp").to(Timestamp.parseTimestamp((String)"2022-08-04T11:20:00.123456789Z"))).set("date").to(Date.fromYearMonthDay((int)2022, (int)8, (int)3))).set("boolArray").to(Value.boolArray(Arrays.asList(Boolean.FALSE, null, Boolean.TRUE)))).set("longArray").to(Value.int64Array(Arrays.asList(2L, null, 1L, 0L)))).set("doubleArray").to(Value.float64Array(Arrays.asList(3.14, null, 6.6626, 10.1)))).set("floatArray").to(Value.float32Array(Arrays.asList(Float.valueOf(2.71f), null, Float.valueOf(6.6626f), Float.valueOf(10.1f))))).set("bigDecimalArray").to(Value.numericArray(Arrays.asList(BigDecimal.TEN, null, BigDecimal.ONE)))).set("pgNumericArray").to(Value.pgNumericArray(Arrays.asList("10", null, "1", "NaN")))).set("byteArray").to(Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"test2"), null, ByteArray.copyFrom((String)"test1"))))).set("timestampArray").to(Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)"2000-01-01T00:00:00Z"), null, Timestamp.parseTimestamp((String)"2022-07-04T10:24:00.123456789Z"))))).set("dateArray").to(Value.dateArray(Arrays.asList(Date.parseDate((String)"2000-01-01"), null, Date.parseDate((String)"2022-08-03"))))).set("stringArray").to(Value.stringArray(Arrays.asList("test2", null, "test1")))).set("jsonArray").to(Value.jsonArray(Arrays.asList("{\"color\":\"red\",\"value\":\"#f00\"}", null, "[]")))).set("pgJsonbArray").to(Value.pgJsonbArray(Arrays.asList("{\"color\":\"red\",\"value\":\"#f00\"}", null, "[]")))).set("pgOidArray").to(Value.pgOidArray(Arrays.asList(2L, null, 1L, 0L)))).set("protoMessageArray").to(Value.protoMessageArray(Arrays.asList(SingerProto.SingerInfo.newBuilder().setSingerId(23L).build(), SingerProto.SingerInfo.getDefaultInstance()), (Descriptors.Descriptor)SingerProto.SingerInfo.getDescriptor()))).set("protoEnumArray").to(Value.protoEnumArray(Arrays.asList(new ProtocolMessageEnum[]{SingerProto.Genre.JAZZ, SingerProto.Genre.ROCK}), (Descriptors.EnumDescriptor)SingerProto.Genre.getDescriptor()))).build();

    @Test
    public void testRetry() {
        Object newRetryResult;
        Struct.Builder builder;
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"boolVal", (Type)Type.bool()), Type.StructField.of((String)"longVal", (Type)Type.int64()), Type.StructField.of((String)"doubleVal", (Type)Type.float64()), Type.StructField.of((String)"floatVal", (Type)Type.float32()), Type.StructField.of((String)"bigDecimalVal", (Type)Type.numeric()), Type.StructField.of((String)"pgNumericVal", (Type)Type.pgNumeric()), Type.StructField.of((String)"stringVal", (Type)Type.string()), Type.StructField.of((String)"jsonVal", (Type)Type.json()), Type.StructField.of((String)"pgJsonbVal", (Type)Type.pgJsonb()), Type.StructField.of((String)"pgOidVal", (Type)Type.pgOid()), Type.StructField.of((String)"protoMessageVal", (Type)Type.proto((String)SingerProto.SingerInfo.getDescriptor().getFullName())), Type.StructField.of((String)"protoEnumVal", (Type)Type.protoEnum((String)SingerProto.Genre.getDescriptor().getFullName())), Type.StructField.of((String)"byteVal", (Type)Type.bytes()), Type.StructField.of((String)"timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"date", (Type)Type.date()), Type.StructField.of((String)"boolArray", (Type)Type.array((Type)Type.bool())), Type.StructField.of((String)"longArray", (Type)Type.array((Type)Type.int64())), Type.StructField.of((String)"doubleArray", (Type)Type.array((Type)Type.float64())), Type.StructField.of((String)"floatArray", (Type)Type.array((Type)Type.float32())), Type.StructField.of((String)"bigDecimalArray", (Type)Type.array((Type)Type.numeric())), Type.StructField.of((String)"pgNumericArray", (Type)Type.array((Type)Type.pgNumeric())), Type.StructField.of((String)"byteArray", (Type)Type.array((Type)Type.bytes())), Type.StructField.of((String)"timestampArray", (Type)Type.array((Type)Type.timestamp())), Type.StructField.of((String)"dateArray", (Type)Type.array((Type)Type.date())), Type.StructField.of((String)"stringArray", (Type)Type.array((Type)Type.string())), Type.StructField.of((String)"jsonArray", (Type)Type.array((Type)Type.json())), Type.StructField.of((String)"pgJsonbArray", (Type)Type.array((Type)Type.pgJsonb())), Type.StructField.of((String)"pgOidArray", (Type)Type.array((Type)Type.pgOid())), Type.StructField.of((String)"protoMessageArray", (Type)Type.array((Type)Type.proto((String)SingerProto.SingerInfo.getDescriptor().getFullName()))), Type.StructField.of((String)"protoEnumArray", (Type)Type.array((Type)Type.protoEnum((String)SingerProto.Genre.getDescriptor().getFullName())))});
        Struct rowNonNullValues = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("boolVal").to(true)).set("longVal").to(2L)).set("doubleVal").to(Value.float64((double)3.14))).set("floatVal").to(Value.float32((float)2.71f))).set("bigDecimalVal").to(Value.numeric((BigDecimal)BigDecimal.valueOf(123L, 2)))).set("pgNumericVal").to(Value.pgNumeric((String)"1.23"))).set("stringVal").to("test")).set("jsonVal").to(Value.json((String)"{\"color\":\"red\",\"value\":\"#f00\"}"))).set("pgJsonbVal").to(Value.pgJsonb((String)"{\"color\":\"red\",\"value\":\"#f00\"}"))).set("pgOidVal").to(Value.pgOid((long)2L))).set("protoMessageVal").to((AbstractMessage)SingerProto.SingerInfo.newBuilder().setSingerId(98L).setNationality("C1").build())).set("protoEnumVal").to((ProtocolMessageEnum)SingerProto.Genre.POP)).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((byte[])"test".getBytes(StandardCharsets.UTF_8))))).set("timestamp").to(Timestamp.parseTimestamp((String)"2022-08-04T10:19:00.123456789Z"))).set("date").to(Date.fromYearMonthDay((int)2022, (int)8, (int)4))).set("boolArray").to(Value.boolArray(Arrays.asList(Boolean.TRUE, null, Boolean.FALSE)))).set("longArray").to(Value.int64Array(Arrays.asList(1L, null, 2L)))).set("doubleArray").to(Value.float64Array(Arrays.asList(3.14, null, 6.6626)))).set("floatArray").to(Value.float32Array(Arrays.asList(Float.valueOf(2.71f), null, Float.valueOf(6.6626f))))).set("bigDecimalArray").to(Value.numericArray(Arrays.asList(BigDecimal.ONE, null, BigDecimal.TEN)))).set("pgNumericArray").to(Value.pgNumericArray(Arrays.asList("1", null, "10")))).set("byteArray").to(Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"test1"), null, ByteArray.copyFrom((String)"test2"))))).set("timestampArray").to(Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)"2000-01-01T00:00:00Z"), null, Timestamp.parseTimestamp((String)"2022-08-04T10:24:00.123456789Z"))))).set("dateArray").to(Value.dateArray(Arrays.asList(Date.parseDate((String)"2000-01-01"), null, Date.parseDate((String)"2022-08-04"))))).set("stringArray").to(Value.stringArray(Arrays.asList("test1", null, "test2")))).set("jsonArray").to(Value.jsonArray(Arrays.asList("{\"color\":\"red\",\"value\":\"#f00\"}", null, "{}")))).set("pgJsonbArray").to(Value.pgJsonbArray(Arrays.asList("{\"color\":\"red\",\"value\":\"#f00\"}", null, "{}")))).set("pgOidArray").to(Value.pgOidArray(Arrays.asList(1L, null, 2L)))).set("protoMessageArray").to(Value.protoMessageArray(Arrays.asList(SingerProto.SingerInfo.newBuilder().setSingerId(11L).setNationality("C1").build(), SingerProto.SingerInfo.getDefaultInstance()), (Descriptors.Descriptor)SingerProto.SingerInfo.getDescriptor()))).set("protoEnumArray").to(Value.protoEnumArray(Arrays.asList(new ProtocolMessageEnum[]{SingerProto.Genre.POP, SingerProto.Genre.ROCK}), (Descriptors.EnumDescriptor)SingerProto.Genre.getDescriptor()))).build();
        Struct rowNullValues = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("boolVal").to((Boolean)null)).set("longVal").to((Long)null)).set("doubleVal").to((Double)null)).set("floatVal").to((Float)null)).set("bigDecimalVal").to((BigDecimal)null)).set("pgNumericVal").to(Value.pgNumeric(null))).set("stringVal").to((String)null)).set("jsonVal").to(Value.json(null))).set("pgJsonbVal").to(Value.pgJsonb(null))).set("pgOidVal").to(Value.pgOid(null))).set("protoMessageVal").to(Value.protoMessage(null, (String)SingerProto.SingerInfo.getDescriptor().getFullName()))).set("protoEnumVal").to(Value.protoEnum(null, (String)SingerProto.Genre.getDescriptor().getFullName()))).set("byteVal").to((ByteArray)null)).set("timestamp").to((Timestamp)null)).set("date").to((Date)null)).set("boolArray").toBoolArray((Iterable)null)).set("longArray").toInt64Array((Iterable)null)).set("doubleArray").toFloat64Array((Iterable)null)).set("floatArray").toFloat32Array((Iterable)null)).set("bigDecimalArray").toNumericArray(null)).set("pgNumericArray").toPgNumericArray(null)).set("byteArray").toBytesArray(null)).set("timestampArray").toTimestampArray(null)).set("dateArray").toDateArray(null)).set("stringArray").toStringArray(null)).set("jsonArray").toJsonArray(null)).set("pgJsonbArray").toPgJsonbArray(null)).set("pgOidArray").toPgOidArray((Iterable)null)).set("protoMessageArray").to(Value.protoMessageArray(null, (Descriptors.Descriptor)SingerProto.SingerInfo.getDescriptor()))).set("protoEnumArray").to(Value.protoEnumArray(null, (Descriptors.EnumDescriptor)SingerProto.Genre.getDescriptor()))).build();
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Statement statement = Statement.of((String)"select * from foo");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        AbortedException abortedException = (AbortedException)((Object)Mockito.mock(AbortedException.class));
        ReadWriteTransaction transaction = (ReadWriteTransaction)Mockito.mock(ReadWriteTransaction.class);
        Mockito.when((Object)transaction.runWithRetry((Callable)ArgumentMatchers.any(Callable.class))).thenAnswer(invocationOnMock -> ((Callable)invocationOnMock.getArgument(0)).call());
        Mockito.when((Object)transaction.getStatementExecutor()).thenReturn((Object)((StatementExecutor)Mockito.mock(StatementExecutor.class)));
        ResultSet queryResult = ResultSets.forRows((Type)type, (Iterable)ImmutableList.of((Object)rowNonNullValues, (Object)rowNullValues));
        ChecksumResultSet resultSet = new ChecksumResultSet(transaction, (ProtobufResultSet)DirectExecuteResultSet.ofResultSet((ResultSet)queryResult), parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertTrue((boolean)resultSet.next());
        ResultSet retryResult = ResultSets.forRows((Type)type, (Iterable)ImmutableList.of((Object)rowNonNullValues, (Object)rowNullValues));
        Mockito.when((Object)transaction.internalExecuteQuery(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0])).thenReturn((Object)retryResult);
        resultSet.retry(abortedException);
        for (Type.StructField fieldToChange : rowNonNullValues.getType().getStructFields()) {
            builder = Struct.newBuilder();
            for (Type.StructField field : rowNonNullValues.getType().getStructFields()) {
                if (field.equals((Object)fieldToChange)) {
                    builder.set(field.getName()).to(DIFFERENT_NON_NULL_VALUES.getValue(field.getName()));
                    continue;
                }
                builder.set(field.getName()).to(rowNonNullValues.getValue(field.getName()));
            }
            newRetryResult = ResultSets.forRows((Type)type, (Iterable)ImmutableList.of((Object)builder.build(), (Object)rowNullValues));
            Mockito.when((Object)transaction.internalExecuteQuery(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0])).thenReturn(newRetryResult);
            Assert.assertThrows((String)("Missing exception for " + fieldToChange.getName()), AbortedDueToConcurrentModificationException.class, () -> resultSet.retry(abortedException));
        }
        for (Type.StructField fieldToChange : rowNonNullValues.getType().getStructFields()) {
            builder = Struct.newBuilder();
            for (Type.StructField field : rowNonNullValues.getType().getStructFields()) {
                if (field.equals((Object)fieldToChange)) {
                    builder.set(field.getName()).to(rowNullValues.getValue(field.getName()));
                    continue;
                }
                builder.set(field.getName()).to(rowNonNullValues.getValue(field.getName()));
            }
            newRetryResult = ResultSets.forRows((Type)type, (Iterable)ImmutableList.of((Object)builder.build(), (Object)rowNullValues));
            Mockito.when((Object)transaction.internalExecuteQuery(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0])).thenReturn(newRetryResult);
            Assert.assertThrows((String)("Missing exception for " + fieldToChange.getName()), AbortedDueToConcurrentModificationException.class, () -> resultSet.retry(abortedException));
        }
        for (Type.StructField fieldToChange : rowNonNullValues.getType().getStructFields()) {
            builder = Struct.newBuilder();
            for (Type.StructField field : rowNullValues.getType().getStructFields()) {
                if (field.equals((Object)fieldToChange)) {
                    builder.set(field.getName()).to(rowNonNullValues.getValue(field.getName()));
                    continue;
                }
                builder.set(field.getName()).to(rowNullValues.getValue(field.getName()));
            }
            newRetryResult = ResultSets.forRows((Type)type, (Iterable)ImmutableList.of((Object)rowNonNullValues, (Object)builder.build()));
            Mockito.when((Object)transaction.internalExecuteQuery(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0])).thenReturn(newRetryResult);
            Assert.assertThrows((String)("Missing exception for " + fieldToChange.getName()), AbortedDueToConcurrentModificationException.class, () -> resultSet.retry(abortedException));
        }
    }
}

