/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConnectionPropertyTest {
    @Test
    public void testCreateKey() {
        Assert.assertEquals((Object)"my_property", (Object)ConnectionProperty.createKey(null, (String)"my_property"));
        Assert.assertEquals((Object)"my_property", (Object)ConnectionProperty.createKey(null, (String)"My_Property"));
        Assert.assertEquals((Object)"my_property", (Object)ConnectionProperty.createKey(null, (String)"MY_PROPERTY"));
        Assert.assertEquals((Object)"my_extension.my_property", (Object)ConnectionProperty.createKey((String)"my_extension", (String)"my_property"));
        Assert.assertEquals((Object)"my_extension.my_property", (Object)ConnectionProperty.createKey((String)"My_Extension", (String)"My_Property"));
        Assert.assertEquals((Object)"my_extension.my_property", (Object)ConnectionProperty.createKey((String)"MY_EXTENSION", (String)"MY_PROPERTY"));
        Assert.assertThrows(SpannerException.class, () -> ConnectionProperty.createKey((String)"my_extension", null));
        Assert.assertThrows(SpannerException.class, () -> ConnectionProperty.createKey((String)"my_extension", (String)""));
    }

    @Test
    public void testCreate() {
        ConnectionProperty property = ConnectionProperty.create((String)"my_property", (String)"Description of my_property", (Object)"default_value", (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, (ConnectionProperty.Context)ConnectionProperty.Context.USER);
        Assert.assertEquals((Object)"my_property", (Object)property.getName());
        Assert.assertEquals((Object)"Description of my_property", (Object)property.getDescription());
        Assert.assertEquals((Object)"default_value", (Object)property.getDefaultValue());
        Assert.assertEquals((Object)"my_value", (Object)Objects.requireNonNull(property.convert("my_value")).getValue());
        Assert.assertEquals((Object)property.getContext(), (Object)ConnectionProperty.Context.USER);
        Assert.assertEquals((Object)"my_property", (Object)property.getKey());
        ConnectionProperty startupProperty = ConnectionProperty.create((String)"STARTUP_PROPERTY", (String)"Description of STARTUP_PROPERTY", (Object)1, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, (ConnectionProperty.Context)ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)"startup_property", (Object)startupProperty.getName());
        Assert.assertEquals((Object)"Description of STARTUP_PROPERTY", (Object)startupProperty.getDescription());
        Assert.assertEquals((Object)1, (Object)startupProperty.getDefaultValue());
        Assert.assertEquals((Object)2, (Object)Objects.requireNonNull(startupProperty.convert("2")).getValue());
        Assert.assertEquals((Object)startupProperty.getContext(), (Object)ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)"startup_property", (Object)startupProperty.getKey());
    }

    @Test
    public void testEquals() {
        ConnectionProperty property1 = new ConnectionProperty(null, "my_property", "Description of property1", (Object)"default_value_1", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property2 = new ConnectionProperty(null, "my_property", "Description of property2", (Object)"default_value_2", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.USER);
        ConnectionProperty property3 = new ConnectionProperty("my_extension", "my_property", "Description of property3", (Object)"default_value_3", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property4 = new ConnectionProperty("my_extension", "my_property", "Description of property4", (Object)"default_value_4", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.USER);
        ConnectionProperty property5 = new ConnectionProperty(null, "my_other_property", "Description of property5", (Object)"default_value_5", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property6 = new ConnectionProperty("my_extension", "my_other_property", "Description of property6", (Object)"default_value_6", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property7 = new ConnectionProperty(null, "MY_PROPERTY", "Description of property7", (Object)"default_value_7", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property8 = new ConnectionProperty("MY_EXTENSION", "my_property", "Description of property8", (Object)"default_value_8", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        ConnectionProperty property9 = new ConnectionProperty("my_extension", "MY_PROPERTY", "Description of property9", (Object)"default_value_9", null, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)property1, (Object)property2);
        Assert.assertNotEquals((Object)property1, (Object)property3);
        Assert.assertNotEquals((Object)property1, (Object)property4);
        Assert.assertNotEquals((Object)property1, (Object)property5);
        Assert.assertNotEquals((Object)property1, (Object)property6);
        Assert.assertEquals((Object)property1, (Object)property7);
        Assert.assertNotEquals((Object)property1, (Object)property8);
        Assert.assertNotEquals((Object)property1, (Object)property9);
        Assert.assertEquals((Object)property2, (Object)property1);
        Assert.assertNotEquals((Object)property2, (Object)property3);
        Assert.assertNotEquals((Object)property2, (Object)property4);
        Assert.assertNotEquals((Object)property2, (Object)property5);
        Assert.assertNotEquals((Object)property2, (Object)property6);
        Assert.assertEquals((Object)property2, (Object)property7);
        Assert.assertNotEquals((Object)property2, (Object)property8);
        Assert.assertNotEquals((Object)property2, (Object)property9);
        Assert.assertNotEquals((Object)property3, (Object)property1);
        Assert.assertNotEquals((Object)property3, (Object)property2);
        Assert.assertEquals((Object)property3, (Object)property4);
        Assert.assertNotEquals((Object)property3, (Object)property5);
        Assert.assertNotEquals((Object)property3, (Object)property6);
        Assert.assertNotEquals((Object)property3, (Object)property7);
        Assert.assertEquals((Object)property3, (Object)property8);
        Assert.assertEquals((Object)property3, (Object)property9);
        Assert.assertNotEquals((Object)property4, (Object)property1);
        Assert.assertNotEquals((Object)property4, (Object)property2);
        Assert.assertEquals((Object)property4, (Object)property3);
        Assert.assertNotEquals((Object)property4, (Object)property5);
        Assert.assertNotEquals((Object)property4, (Object)property6);
        Assert.assertNotEquals((Object)property4, (Object)property7);
        Assert.assertEquals((Object)property4, (Object)property8);
        Assert.assertEquals((Object)property4, (Object)property9);
        Assert.assertNotEquals((Object)property5, (Object)property1);
        Assert.assertNotEquals((Object)property5, (Object)property2);
        Assert.assertNotEquals((Object)property5, (Object)property3);
        Assert.assertNotEquals((Object)property5, (Object)property4);
        Assert.assertNotEquals((Object)property5, (Object)property6);
        Assert.assertNotEquals((Object)property5, (Object)property7);
        Assert.assertNotEquals((Object)property5, (Object)property8);
        Assert.assertNotEquals((Object)property5, (Object)property9);
        Assert.assertNotEquals((Object)property6, (Object)property1);
        Assert.assertNotEquals((Object)property6, (Object)property2);
        Assert.assertNotEquals((Object)property6, (Object)property3);
        Assert.assertNotEquals((Object)property6, (Object)property4);
        Assert.assertNotEquals((Object)property6, (Object)property5);
        Assert.assertNotEquals((Object)property6, (Object)property7);
        Assert.assertNotEquals((Object)property6, (Object)property8);
        Assert.assertNotEquals((Object)property6, (Object)property9);
        Assert.assertEquals((Object)property7, (Object)property1);
        Assert.assertEquals((Object)property7, (Object)property2);
        Assert.assertNotEquals((Object)property7, (Object)property3);
        Assert.assertNotEquals((Object)property7, (Object)property4);
        Assert.assertNotEquals((Object)property7, (Object)property5);
        Assert.assertNotEquals((Object)property7, (Object)property6);
        Assert.assertNotEquals((Object)property7, (Object)property8);
        Assert.assertNotEquals((Object)property7, (Object)property9);
        Assert.assertNotEquals((Object)property8, (Object)property1);
        Assert.assertNotEquals((Object)property8, (Object)property2);
        Assert.assertEquals((Object)property8, (Object)property3);
        Assert.assertEquals((Object)property8, (Object)property4);
        Assert.assertNotEquals((Object)property8, (Object)property5);
        Assert.assertNotEquals((Object)property8, (Object)property6);
        Assert.assertNotEquals((Object)property8, (Object)property7);
        Assert.assertEquals((Object)property8, (Object)property9);
        Assert.assertNotEquals((Object)property9, (Object)property1);
        Assert.assertNotEquals((Object)property9, (Object)property2);
        Assert.assertEquals((Object)property9, (Object)property3);
        Assert.assertEquals((Object)property9, (Object)property4);
        Assert.assertNotEquals((Object)property9, (Object)property5);
        Assert.assertNotEquals((Object)property9, (Object)property6);
        Assert.assertNotEquals((Object)property9, (Object)property7);
        Assert.assertEquals((Object)property9, (Object)property8);
    }

    @Test
    public void testConvert() {
        ConnectionProperty property = ConnectionProperty.create((String)"my_property", (String)"Description of my_property", (Object)1, (ClientSideStatementValueConverter)ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, (ConnectionProperty.Context)ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)100, (Object)Objects.requireNonNull(property.convert("100")).getValue());
        Assert.assertThrows(SpannerException.class, () -> property.convert("foo"));
        Assert.assertThrows(SpannerException.class, () -> property.convert("-100"));
    }

    @Test
    public void testCreateInitialValue() {
        ConnectionProperty property = ConnectionProperty.create((String)"my_property", (String)"Description of my_property", (Object)"default_value", (ClientSideStatementValueConverter)ClientSideStatementValueConverters.StringValueConverter.INSTANCE, (ConnectionProperty.Context)ConnectionProperty.Context.USER);
        ConnectionPropertyValue initialValue = property.createInitialValue(null);
        Assert.assertEquals((Object)property.getDefaultValue(), (Object)initialValue.getValue());
        Assert.assertEquals((Object)property.getDefaultValue(), (Object)initialValue.getResetValue());
        Assert.assertSame((Object)initialValue.getProperty(), (Object)property);
        ConnectionPropertyValue startupValue = new ConnectionPropertyValue(property, (Object)"other_value", (Object)"other_value");
        ConnectionPropertyValue initialValueWithStartupValue = property.createInitialValue(startupValue);
        Assert.assertEquals((Object)"other_value", (Object)initialValueWithStartupValue.getValue());
        Assert.assertEquals((Object)"other_value", (Object)initialValueWithStartupValue.getResetValue());
        Assert.assertSame((Object)initialValueWithStartupValue.getProperty(), (Object)property);
    }
}

