/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.cloud.spanner.connection.ConnectionState;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConnectionPropertyValueTest {
    @Test
    public void testSetValue() {
        ConnectionPropertyValue value = ConnectionProperties.READONLY.createInitialValue(null);
        Assert.assertEquals((Object)ConnectionProperties.READONLY.getDefaultValue(), (Object)value.getValue());
        value.setValue((Object)Boolean.FALSE, ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
        value.setValue((Object)Boolean.TRUE, ConnectionProperty.Context.USER);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)value.getValue());
        value.setValue((Object)Boolean.FALSE, ConnectionProperty.Context.USER);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
        ConnectionPropertyValue outsideTransactionOnlyValue = ConnectionProperties.AUTOCOMMIT_DML_MODE.createInitialValue(null);
        Assert.assertEquals((Object)ConnectionProperties.AUTOCOMMIT_DML_MODE.getDefaultValue(), (Object)outsideTransactionOnlyValue.getValue());
        outsideTransactionOnlyValue.setValue((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC, ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC, (Object)outsideTransactionOnlyValue.getValue());
        outsideTransactionOnlyValue.setValue((Object)AutocommitDmlMode.TRANSACTIONAL, ConnectionProperty.Context.USER);
        Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL, (Object)outsideTransactionOnlyValue.getValue());
        ConnectionPropertyValue startupOnlyValue = ConnectionProperties.CONNECTION_STATE_TYPE.createInitialValue(null);
        Assert.assertEquals((Object)ConnectionProperties.CONNECTION_STATE_TYPE.getDefaultValue(), (Object)startupOnlyValue.getValue());
        startupOnlyValue.setValue((Object)ConnectionState.Type.TRANSACTIONAL, ConnectionProperty.Context.STARTUP);
        Assert.assertEquals((Object)ConnectionState.Type.TRANSACTIONAL, (Object)startupOnlyValue.getValue());
        Assert.assertThrows(SpannerException.class, () -> startupOnlyValue.setValue((Object)ConnectionState.Type.NON_TRANSACTIONAL, ConnectionProperty.Context.USER));
        Assert.assertEquals((Object)ConnectionState.Type.TRANSACTIONAL, (Object)startupOnlyValue.getValue());
        Assert.assertThrows(SpannerException.class, () -> startupOnlyValue.setValue((Object)ConnectionState.Type.NON_TRANSACTIONAL, ConnectionProperty.Context.USER));
        Assert.assertEquals((Object)ConnectionState.Type.TRANSACTIONAL, (Object)startupOnlyValue.getValue());
    }

    @Test
    public void testCopy() {
        ConnectionPropertyValue value = new ConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT_DML_MODE, (Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC, (Object)AutocommitDmlMode.TRANSACTIONAL);
        ConnectionPropertyValue copy = value.copy();
        Assert.assertEquals((Object)value, (Object)copy);
        Assert.assertNotSame((Object)value, (Object)copy);
        Assert.assertEquals((Object)value.getProperty(), (Object)copy.getProperty());
        Assert.assertEquals((Object)value.getValue(), (Object)copy.getValue());
        Assert.assertEquals((Object)value.getResetValue(), (Object)copy.getResetValue());
    }
}

