/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SpannerPool;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConnectionStateMockServerTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0})")
    public static Object[] data() {
        return Dialect.values();
    }

    @BeforeClass
    public static void enableTransactionalConnectionStateForPostgreSQL() {
        System.setProperty(ConnectionOptions.ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY, "true");
    }

    @AfterClass
    public static void disableTransactionalConnectionStateForPostgreSQL() {
        System.clearProperty(ConnectionOptions.ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY);
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            this.currentDialect = this.dialect;
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Override
    protected String getBaseUrl() {
        return String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true", this.getPort());
    }

    ITAbstractSpannerTest.ITConnection createConnection(ConnectionState.Type type) {
        return this.createConnection(";" + ConnectionProperties.CONNECTION_STATE_TYPE.getKey() + "=" + type.name());
    }

    String getPrefix() {
        return this.dialect == Dialect.POSTGRESQL ? "SPANNER." : "";
    }

    @Test
    public void testConnectionStateType() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((Object)(this.dialect == Dialect.POSTGRESQL ? ConnectionState.Type.TRANSACTIONAL : ConnectionState.Type.NON_TRANSACTIONAL), (Object)((ConnectionImpl)connection).getConnectionStateType());
        }
        connection = this.createConnection(ConnectionState.Type.TRANSACTIONAL);
        try {
            Assert.assertEquals((Object)ConnectionState.Type.TRANSACTIONAL, (Object)((ConnectionImpl)connection).getConnectionStateType());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection(ConnectionState.Type.NON_TRANSACTIONAL);
        try {
            Assert.assertEquals((Object)ConnectionState.Type.NON_TRANSACTIONAL, (Object)((ConnectionImpl)connection).getConnectionStateType());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAutocommitPersistsConnectionState() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";autocommit=true");){
            Assert.assertTrue((boolean)connection.isAutocommit());
            Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL, (Object)connection.getAutocommitDmlMode());
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            Assert.assertEquals((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC, (Object)connection.getAutocommitDmlMode());
        }
    }

    @Test
    public void testNonTransactionalState_commitsAutomatically() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";connection_state_type=non_transactional;autocommit=false");){
            Assert.assertEquals((Object)((ConnectionImpl)connection).getConnectionStateType(), (Object)ConnectionState.Type.NON_TRANSACTIONAL);
            Assert.assertFalse((boolean)connection.isAutocommit());
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.setReturnCommitStats(true);
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.rollback();
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.setAutocommit(true);
            connection.beginTransaction();
            connection.setReturnCommitStats(false);
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.rollback();
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
        }
    }

    @Test
    public void testTransactionalState_rollBacksConnectionState() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";connection_state_type=transactional;autocommit=false");){
            Assert.assertEquals((Object)((ConnectionImpl)connection).getConnectionStateType(), (Object)ConnectionState.Type.TRANSACTIONAL);
            Assert.assertFalse((boolean)connection.isAutocommit());
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.setReturnCommitStats(true);
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.rollback();
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.setAutocommit(true);
            connection.beginTransaction();
            connection.setReturnCommitStats(true);
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.rollback();
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
        }
    }

    @Test
    public void testTransactionalState_commitsConnectionState() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";connection_state_type=transactional;autocommit=false");){
            Assert.assertEquals((Object)((ConnectionImpl)connection).getConnectionStateType(), (Object)ConnectionState.Type.TRANSACTIONAL);
            Assert.assertFalse((boolean)connection.isAutocommit());
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.setReturnCommitStats(true);
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.commit();
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            Assert.assertTrue((boolean)connection.isReturnCommitStats());
            connection.setAutocommit(true);
            connection.beginTransaction();
            connection.setReturnCommitStats(false);
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
            connection.commit();
            Assert.assertFalse((boolean)connection.isReturnCommitStats());
        }
    }

    @Test
    public void testLocalChangeIsLostAfterTransaction() {
        for (ConnectionState.Type type : ConnectionState.Type.values()) {
            try (ConnectionImpl connection = (ConnectionImpl)this.createConnection();){
                Assert.assertTrue((boolean)connection.isAutocommit());
                for (boolean commit : new boolean[]{true, false}) {
                    Assert.assertFalse((boolean)connection.isReturnCommitStats());
                    connection.beginTransaction();
                    connection.setReturnCommitStats(true, true);
                    Assert.assertTrue((boolean)connection.isReturnCommitStats());
                    if (commit) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    Assert.assertFalse((boolean)connection.isReturnCommitStats());
                }
            }
        }
    }

    @Test
    public void testSetLocalWithSqlStatement() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
            connection.execute(Statement.of((String)String.format("set local %sretry_aborts_internally=false", this.getPrefix())));
            Assert.assertFalse((boolean)connection.isRetryAbortsInternally());
            connection.commit();
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
        }
    }

    @Test
    public void testSetSessionWithSqlStatement() {
        Assume.assumeTrue((String)"Only PostgreSQL supports the 'session' keyword", (this.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
            connection.execute(Statement.of((String)String.format("set session %sretry_aborts_internally=false", this.getPrefix())));
            Assert.assertFalse((boolean)connection.isRetryAbortsInternally());
            connection.commit();
            Assert.assertFalse((boolean)connection.isRetryAbortsInternally());
        }
    }

    @Test
    public void testSetLocalInvalidValue() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)String.format("set local %sretry_aborts_internally=foo", this.getPrefix()))));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().endsWith(String.format("Unknown value for %sRETRY_ABORTS_INTERNALLY: foo", this.getPrefix())));
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
        }
    }
}

