/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionState;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConnectionStateTest {
    @Parameterized.Parameter
    public ConnectionState.Type connectionStateType;

    @Parameterized.Parameters(name="connectionStateType = {0}")
    public static Object[] data() {
        return ConnectionState.Type.values();
    }

    ConnectionState getNonTransactionalState() {
        return new ConnectionState(this.createConnectionOptionsBuilder().build().getInitialConnectionPropertyValues());
    }

    ConnectionState getTransactionalState() {
        return new ConnectionState(this.createConnectionOptionsBuilder().setConnectionPropertyValue(ConnectionProperties.CONNECTION_STATE_TYPE, (Object)ConnectionState.Type.TRANSACTIONAL).build().getInitialConnectionPropertyValues());
    }

    ConnectionOptions.Builder createConnectionOptionsBuilder() {
        return ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/p/instances/i/databases/d").setCredentials((Credentials)NoCredentials.getInstance());
    }

    ConnectionState getConnectionState() {
        return this.connectionStateType == ConnectionState.Type.TRANSACTIONAL ? this.getTransactionalState() : this.getNonTransactionalState();
    }

    @Test
    public void testSetOutsideTransaction() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)this.connectionStateType, (Object)state.getType());
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.READONLY).getValue());
        state.setValue(ConnectionProperties.READONLY, (Object)true, ConnectionProperty.Context.USER, false);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.READONLY).getValue());
    }

    @Test
    public void testSetToNullOutsideTransaction() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL, (Object)state.getValue(ConnectionProperties.AUTOCOMMIT_DML_MODE).getValue());
        state.setValue(ConnectionProperties.AUTOCOMMIT_DML_MODE, null, ConnectionProperty.Context.USER, false);
        Assert.assertNull((Object)state.getValue(ConnectionProperties.AUTOCOMMIT_DML_MODE).getValue());
    }

    @Test
    public void testSetInTransactionCommit() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testSetInTransactionRollback() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.rollback();
        boolean expectedValue = this.connectionStateType == ConnectionState.Type.TRANSACTIONAL;
        Assert.assertEquals((Object)expectedValue, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testResetInTransactionCommit() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        state.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testResetInTransactionRollback() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        state.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.rollback();
        boolean expectedValue = this.connectionStateType != ConnectionState.Type.TRANSACTIONAL;
        Assert.assertEquals((Object)expectedValue, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testSetLocal() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setLocalValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testSetLocalForStartupProperty() {
        ConnectionState state = this.getConnectionState();
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> state.setLocalValue(ConnectionProperties.CONNECTION_STATE_TYPE, (Object)ConnectionState.Type.TRANSACTIONAL));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testSetInTransactionForStartupProperty() {
        ConnectionState state = this.getConnectionState();
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> state.setValue(ConnectionProperties.CONNECTION_STATE_TYPE, (Object)ConnectionState.Type.TRANSACTIONAL, ConnectionProperty.Context.USER, true));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testSetStartupOnlyProperty() {
        ConnectionState state = this.getConnectionState();
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> state.setValue(ConnectionProperties.CONNECTION_STATE_TYPE, (Object)ConnectionState.Type.TRANSACTIONAL, ConnectionProperty.Context.USER, false));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testReset() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, false);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, ConnectionProperty.Context.USER, false);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testResetInTransaction() {
        ConnectionState state = this.getConnectionState();
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)false, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.commit();
        state.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, ConnectionProperty.Context.USER, true);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }

    @Test
    public void testResetStartupOnlyProperty() {
        ConnectionState state = this.getConnectionState();
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> state.resetValue(ConnectionProperties.CONNECTION_STATE_TYPE, ConnectionProperty.Context.USER, false));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
    }

    @Test
    public void testInitialValueInConnectionUrl() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/p/instances/i/databases/d?retryAbortsInternally=false").setCredentials((Credentials)NoCredentials.getInstance()).build();
        ConnectionState state = new ConnectionState(options.getInitialConnectionPropertyValues());
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.setValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, (Object)true, ConnectionProperty.Context.USER, false);
        Assert.assertEquals((Object)true, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
        state.resetValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY, ConnectionProperty.Context.USER, false);
        Assert.assertEquals((Object)false, (Object)state.getValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY).getValue());
    }
}

