/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.CredentialsService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CredentialsServiceTest {
    private static final String FILE_TEST_PATH = CredentialsServiceTest.class.getResource("test-key.json").getFile();
    private static final String APP_DEFAULT_FILE_TEST_PATH = CredentialsServiceTest.class.getResource("test-key-app-default.json").getFile();
    private static final String TEST_PROJECT_ID = "test-project";
    private static final String APP_DEFAULT_PROJECT_ID = "app-default-test-project";
    private final CredentialsService service = new CredentialsService(){

        GoogleCredentials internalGetApplicationDefault() throws IOException {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(APP_DEFAULT_FILE_TEST_PATH));
        }
    };

    @Test
    public void testCreateCredentialsDefault() {
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)this.service.createCredentials(null);
        MatcherAssert.assertThat((Object)credentials.getProjectId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)APP_DEFAULT_PROJECT_ID)));
    }

    @Test
    public void testCreateCredentialsFile() {
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)this.service.createCredentials(FILE_TEST_PATH);
        MatcherAssert.assertThat((Object)credentials.getProjectId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TEST_PROJECT_ID)));
    }

    @Test(expected=SpannerException.class)
    public void testCreateCredentialsInvalidFile() {
        this.service.createCredentials("invalid_file_path.json");
    }

    @Test
    public void testCreateCredentialsInvalidCloudStorage() {
        try {
            this.service.createCredentials("gs://test-bucket/test-blob");
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_ARGUMENT)));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Credentials that is stored on Google Cloud Storage is no longer supported. Download the credentials to a local file and reference the local file in the connection URL.")));
        }
    }
}

