/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DdlBatch;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.NoopEndTransactionCallback;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.io.ByteStreams;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import io.grpc.Status;
import io.opentelemetry.api.trace.Span;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class DdlBatchTest {
    private DdlClient createDefaultMockDdlClient() {
        return this.createDefaultMockDdlClient(false, 0L);
    }

    private DdlClient createDefaultMockDdlClient(boolean exceptionOnGetResult) {
        return this.createDefaultMockDdlClient(exceptionOnGetResult, 0L);
    }

    private DdlClient createDefaultMockDdlClient(long waitForMillis) {
        return this.createDefaultMockDdlClient(false, waitForMillis);
    }

    private DdlClient createDefaultMockDdlClient(boolean exceptionOnGetResult, long waitForMillis) {
        try {
            DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
            OperationFuture operation = (OperationFuture)Mockito.mock(OperationFuture.class);
            if (waitForMillis > 0L) {
                Mockito.when((Object)((Void)operation.get())).thenAnswer(invocation -> {
                    Thread.sleep(waitForMillis);
                    return null;
                });
            } else if (exceptionOnGetResult) {
                Mockito.when((Object)((Void)operation.get())).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"ddl statement failed")});
            } else {
                Mockito.when((Object)((Void)operation.get())).thenReturn(null);
            }
            UpdateDatabaseDdlMetadata.Builder metadataBuilder = UpdateDatabaseDdlMetadata.newBuilder();
            if (!exceptionOnGetResult) {
                metadataBuilder.addCommitTimestamps(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L));
            }
            ApiFuture metadataFuture = ApiFutures.immediateFuture((Object)metadataBuilder.build());
            Mockito.when((Object)operation.getMetadata()).thenReturn((Object)metadataFuture);
            Mockito.when((Object)ddlClient.executeDdl(Mockito.anyString(), (byte[])Mockito.any())).thenReturn((Object)operation);
            Mockito.when((Object)ddlClient.executeDdl(Mockito.anyList(), (byte[])Mockito.any())).thenReturn((Object)operation);
            return ddlClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DdlBatch createSubject() {
        return this.createSubject(this.createDefaultMockDdlClient());
    }

    private DdlBatch createSubject(DdlClient ddlClient) {
        return this.createSubject(ddlClient, (DatabaseClient)Mockito.mock(DatabaseClient.class));
    }

    private DdlBatch createSubject(DdlClient ddlClient, DatabaseClient dbClient) {
        return ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(ddlClient).setDatabaseClient(dbClient).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
    }

    @Test
    public void testExecuteQuery() {
        DdlBatch batch = this.createSubject();
        try {
            batch.executeQueryAsync(UnitOfWork.CallType.SYNC, (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class), AnalyzeMode.NONE, new Options.QueryOption[0]);
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testExecuteCreateDatabase() {
        DdlBatch batch = this.createSubject();
        Assert.assertThrows(IllegalArgumentException.class, () -> batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE DATABASE foo"))));
    }

    @Test
    public void testExecuteUpdate() {
        DdlBatch batch = this.createSubject();
        try {
            batch.executeUpdateAsync(UnitOfWork.CallType.SYNC, (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class), new Options.UpdateOption[0]);
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testExecuteBatchUpdate() {
        DdlBatch batch = this.createSubject();
        try {
            batch.executeBatchUpdateAsync(UnitOfWork.CallType.SYNC, Collections.singleton((AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class)), new Options.UpdateOption[0]);
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetCommitTimestamp() {
        DdlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getCommitTimestamp();
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetCommitResponse() {
        DdlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getCommitResponse();
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
        Assert.assertNull((Object)batch.getCommitResponseOrNull());
    }

    @Test
    public void testGetReadTimestamp() {
        DdlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getReadTimestamp();
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testWriteIterable() {
        DdlBatch batch = this.createSubject();
        try {
            batch.writeAsync(UnitOfWork.CallType.SYNC, Collections.singletonList(Mutation.newInsertBuilder((String)"foo").build()));
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testIsReadOnly() {
        DdlBatch batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetStateAndIsActive() {
        DdlBatch batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RAN));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
        batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        batch.abortBatch();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.ABORTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
        DdlClient client = (DdlClient)Mockito.mock(DdlClient.class);
        SpannerException exception = (SpannerException)((Object)Mockito.mock(SpannerException.class));
        Mockito.when((Object)exception.getErrorCode()).thenReturn((Object)ErrorCode.FAILED_PRECONDITION);
        ((DdlClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)client)).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
        batch = this.createSubject(client);
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)"CREATE TABLE FOO"));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)"CREATE TABLE FOO");
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.FAILED_PRECONDITION)));
        }
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RUN_FAILED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static IsListOfStringsWithSize isEmptyListOfStrings() {
        return new IsListOfStringsWithSize(0);
    }

    private static IsListOfStringsWithSize isListOfStringsWithSize(int size) {
        return new IsListOfStringsWithSize(size);
    }

    @Test
    public void testRunBatch() {
        byte[] protoDescriptors;
        DdlClient client = this.createDefaultMockDdlClient();
        DdlBatch batch = this.createSubject(client);
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RAN));
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyString(), (byte[])ArgumentMatchers.isNull());
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isEmptyListOfStrings()), (byte[])ArgumentMatchers.isNull());
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)"CREATE TABLE FOO"));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)"CREATE TABLE FOO");
        client = this.createDefaultMockDdlClient();
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        ((DdlClient)Mockito.verify((Object)client)).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(1)), (byte[])ArgumentMatchers.isNull());
        client = this.createDefaultMockDdlClient();
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        ((DdlClient)Mockito.verify((Object)client)).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull());
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RAN));
        boolean exception = false;
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        }
        catch (SpannerException e) {
            if (e.getErrorCode() != ErrorCode.FAILED_PRECONDITION) {
                throw e;
            }
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RAN));
        exception = false;
        try {
            batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        }
        catch (SpannerException e) {
            if (e.getErrorCode() != ErrorCode.FAILED_PRECONDITION) {
                throw e;
            }
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        exception = false;
        try {
            batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        }
        catch (SpannerException e) {
            if (e.getErrorCode() != ErrorCode.FAILED_PRECONDITION) {
                throw e;
            }
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        client = this.createDefaultMockDdlClient(true);
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        exception = false;
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        }
        catch (SpannerException e) {
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RUN_FAILED));
        ((DdlClient)Mockito.verify((Object)client)).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull());
        client = this.createDefaultMockDdlClient();
        batch = ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(client).setDatabaseClient((DatabaseClient)Mockito.mock(DatabaseClient.class)).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).setProtoDescriptors(null).build();
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        ((DdlClient)Mockito.verify((Object)client)).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull());
        try {
            InputStream in = DdlBatchTest.class.getClassLoader().getResourceAsStream("com/google/cloud/spanner/descriptors.pb");
            Assert.assertNotNull((Object)in);
            protoDescriptors = ByteStreams.toByteArray((InputStream)in);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
        client = this.createDefaultMockDdlClient();
        batch = ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(client).setDatabaseClient((DatabaseClient)Mockito.mock(DatabaseClient.class)).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).setProtoDescriptors(protoDescriptors).build();
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        ((DdlClient)Mockito.verify((Object)client)).executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])Mockito.any(byte[].class));
    }

    @Test
    public void testUpdateCount() throws InterruptedException, ExecutionException {
        DdlClient client = (DdlClient)Mockito.mock(DdlClient.class);
        UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L - 1L)).addCommitTimestamps(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).addAllStatements(Arrays.asList("CREATE TABLE FOO", "CREATE TABLE BAR")).build();
        ApiFuture metadataFuture = ApiFutures.immediateFuture((Object)metadata);
        OperationFuture operationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)((Void)operationFuture.get())).thenReturn(null);
        Mockito.when((Object)operationFuture.getMetadata()).thenReturn((Object)metadataFuture);
        Mockito.when((Object)client.executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull())).thenReturn((Object)operationFuture);
        DdlBatch batch = ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().withStatementExecutor(new StatementExecutor())).setDdlClient(client).setDatabaseClient((DatabaseClient)Mockito.mock(DatabaseClient.class)).setSpan(Span.getInvalid())).build();
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE FOO")));
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE BAR")));
        long[] updateCounts = (long[])SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)updateCounts.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        MatcherAssert.assertThat((Object)updateCounts[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        MatcherAssert.assertThat((Object)updateCounts[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void testFailedUpdateCount() throws InterruptedException, ExecutionException {
        DdlClient client = (DdlClient)Mockito.mock(DdlClient.class);
        UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L - 1L)).addAllStatements(Arrays.asList("CREATE TABLE FOO", "CREATE TABLE INVALID_TABLE")).build();
        ApiFuture metadataFuture = ApiFutures.immediateFuture((Object)metadata);
        OperationFuture operationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)((Void)operationFuture.get())).thenThrow(new Throwable[]{new ExecutionException("ddl statement failed", (Throwable)Status.INVALID_ARGUMENT.asRuntimeException())});
        Mockito.when((Object)operationFuture.getMetadata()).thenReturn((Object)metadataFuture);
        Mockito.when((Object)client.executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull())).thenReturn((Object)operationFuture);
        DdlBatch batch = ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().withStatementExecutor(new StatementExecutor())).setDdlClient(client).setDatabaseClient((DatabaseClient)Mockito.mock(DatabaseClient.class)).setSpan(Span.getInvalid())).build();
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE FOO")));
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE INVALID_TABLE")));
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerBatchUpdateException e) {
            MatcherAssert.assertThat((Object)e.getUpdateCounts().length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
            MatcherAssert.assertThat((Object)e.getUpdateCounts()[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            MatcherAssert.assertThat((Object)e.getUpdateCounts()[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
        }
    }

    @Test
    public void testFailedAfterFirstStatement() throws InterruptedException, ExecutionException {
        DdlClient client = (DdlClient)Mockito.mock(DdlClient.class);
        UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L - 1L)).addAllStatements(Arrays.asList("CREATE TABLE FOO", "CREATE TABLE INVALID_TABLE")).build();
        ApiFuture metadataFuture = ApiFutures.immediateFuture((Object)metadata);
        OperationFuture operationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)((Void)operationFuture.get())).thenThrow(new Throwable[]{new ExecutionException("ddl statement failed", (Throwable)Status.INVALID_ARGUMENT.asRuntimeException())});
        Mockito.when((Object)operationFuture.getMetadata()).thenReturn((Object)metadataFuture);
        Mockito.when((Object)client.executeDdl((List)Mockito.argThat((ArgumentMatcher)DdlBatchTest.isListOfStringsWithSize(2)), (byte[])ArgumentMatchers.isNull())).thenReturn((Object)operationFuture);
        DdlBatch batch = ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().withStatementExecutor(new StatementExecutor())).setDdlClient(client).setDatabaseClient((DatabaseClient)Mockito.mock(DatabaseClient.class)).setSpan(Span.getInvalid())).build();
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE FOO")));
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"CREATE TABLE INVALID_TABLE")));
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerBatchUpdateException e) {
            MatcherAssert.assertThat((Object)e.getUpdateCounts().length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
            MatcherAssert.assertThat((Object)e.getUpdateCounts()[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            MatcherAssert.assertThat((Object)e.getUpdateCounts()[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
        }
    }

    @Test
    public void testAbort() {
        DdlClient client = this.createDefaultMockDdlClient();
        DdlBatch batch = this.createSubject(client);
        batch.abortBatch();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.ABORTED));
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyString(), (byte[])ArgumentMatchers.isNull());
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)"CREATE TABLE FOO"));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)"CREATE TABLE FOO");
        client = this.createDefaultMockDdlClient();
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.abortBatch();
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
        client = this.createDefaultMockDdlClient();
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.abortBatch();
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
        client = this.createDefaultMockDdlClient();
        batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        batch.abortBatch();
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
        boolean exception = false;
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        }
        catch (SpannerException e) {
            if (e.getErrorCode() != ErrorCode.FAILED_PRECONDITION) {
                throw e;
            }
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        ((DdlClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).executeDdl(Mockito.anyList(), (byte[])ArgumentMatchers.isNull());
    }

    @Test
    public void testCancel() {
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)"CREATE TABLE FOO"));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)"CREATE TABLE FOO");
        DdlClient client = this.createDefaultMockDdlClient(10000L);
        DdlBatch batch = this.createSubject(client);
        batch.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
        Executors.newSingleThreadScheduledExecutor().schedule(() -> ((DdlBatch)batch).cancel(), 100L, TimeUnit.MILLISECONDS);
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
            Assert.fail((String)"expected CANCELLED");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testCommit() {
        DdlBatch batch = this.createSubject();
        try {
            batch.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE);
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testRollback() {
        DdlBatch batch = this.createSubject();
        try {
            batch.rollbackAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE);
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testExtractUpdateCounts() {
        DdlBatch batch = this.createSubject();
        UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(1000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(2000L).build()).addStatements("CREATE TABLE FOO").addStatements("CREATE TABLE BAR").addStatements("CREATE TABLE BAZ").build();
        long[] updateCounts = batch.extractUpdateCounts(metadata);
        MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 0L})));
        metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(1000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(2000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(3000L).build()).addStatements("CREATE TABLE FOO").addStatements("CREATE TABLE BAR").addStatements("CREATE TABLE BAZ").build();
        updateCounts = batch.extractUpdateCounts(metadata);
        MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 1L})));
        metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(1000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(2000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(3000L).build()).addStatements("CREATE TABLE FOO").addStatements("CREATE TABLE BAR").addStatements("CREATE TABLE BAZ").build();
        updateCounts = batch.extractUpdateCounts(metadata);
        MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 1L})));
        metadata = UpdateDatabaseDdlMetadata.newBuilder().addCommitTimestamps(Timestamp.newBuilder().setSeconds(1000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(2000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(3000L).build()).addCommitTimestamps(Timestamp.newBuilder().setSeconds(4000L).build()).addStatements("CREATE TABLE FOO").addStatements("CREATE TABLE BAR").addStatements("CREATE TABLE BAZ").build();
        updateCounts = batch.extractUpdateCounts(metadata);
        MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 1L})));
    }

    private static class IsListOfStringsWithSize
    implements ArgumentMatcher<List<String>> {
        private final int size;

        private IsListOfStringsWithSize(int size) {
            this.size = size;
        }

        public boolean matches(List<String> list) {
            return list.size() == this.size;
        }
    }
}

