/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DurationConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.DurationConverter.class, Dialect.GOOGLE_STANDARD_SQL);
        Assert.assertNotNull((Object)allowedValues);
        ClientSideStatementValueConverters.DurationConverter converter = new ClientSideStatementValueConverters.DurationConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("'100ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofMillis(100L))));
        MatcherAssert.assertThat((Object)converter.convert("100"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofMillis(100L))));
        MatcherAssert.assertThat((Object)converter.convert("'0ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'-100ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'315576000000000ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(315576000000L))));
        MatcherAssert.assertThat((Object)converter.convert("'1000ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(1L))));
        MatcherAssert.assertThat((Object)converter.convert("'1001ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(1L, TimeUnit.MILLISECONDS.toNanos(1L)))));
        MatcherAssert.assertThat((Object)converter.convert("'1ns'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofNanos(1L))));
        MatcherAssert.assertThat((Object)converter.convert("'1us'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofNanos(1000L))));
        MatcherAssert.assertThat((Object)converter.convert("'1ms'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofNanos(1000000L))));
        MatcherAssert.assertThat((Object)converter.convert("'999999999ns'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofNanos(999999999L))));
        MatcherAssert.assertThat((Object)converter.convert("'1s'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(1L))));
        MatcherAssert.assertThat((Object)converter.convert("''"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("' '"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'random string'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("null"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ZERO)));
        MatcherAssert.assertThat((Object)converter.convert("NULL"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ZERO)));
        MatcherAssert.assertThat((Object)converter.convert("Null"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ZERO)));
        MatcherAssert.assertThat((Object)converter.convert("'null'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'NULL'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("'Null'"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

