/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import org.junit.Assert;
import org.junit.Test;

public class ExplainCommandConverterTest {
    @Test
    public void testConvert() {
        ClientSideStatementValueConverters.ExplainCommandConverter explainCommandConverter = new ClientSideStatementValueConverters.ExplainCommandConverter();
        Assert.assertEquals((Object)"select * from table1", (Object)explainCommandConverter.convert("explain select * from table1"));
        Assert.assertEquals((Object)"select    *   \t from table1", (Object)explainCommandConverter.convert("explain \tselect    *   \t from table1"));
        Assert.assertEquals((Object)"select    *   \t from table1", (Object)explainCommandConverter.convert("EXPLAIN \tselect    *   \t from table1"));
        Assert.assertEquals((Object)"select    *   \t from table1", (Object)explainCommandConverter.convert("ExplAIn \tselect    *   \t from table1"));
        Assert.assertEquals((Object)"select    *   \t from table1", (Object)explainCommandConverter.convert("explain \n select    *   \t from table1"));
        Assert.assertEquals((Object)"select    *   \t from table1", (Object)explainCommandConverter.convert("explain \n \t select    *   \t from table1"));
        Assert.assertEquals((Object)"foo", (Object)explainCommandConverter.convert("explain   foo"));
        Assert.assertEquals(null, (Object)explainCommandConverter.convert("explain"));
        Assert.assertEquals((Object)"analyze select * from table1", (Object)explainCommandConverter.convert("explain analyze select * from table1"));
        Assert.assertEquals((Object)"analyze \tselect    *   \t from table1", (Object)explainCommandConverter.convert("explain \t analyze \tselect    *   \t from table1"));
        Assert.assertEquals((Object)"analyze \n select    *   \t from table1", (Object)explainCommandConverter.convert("explain \n analyze \n select    *   \t from table1"));
        Assert.assertEquals((Object)"ANALYZE \n select    *   \t from table1", (Object)explainCommandConverter.convert("EXPLAIN \n ANALYZE \n select    *   \t from table1"));
        Assert.assertEquals((Object)"aNALyzE \n select    *   \t from table1", (Object)explainCommandConverter.convert("ExPLaiN \n aNALyzE \n select    *   \t from table1"));
        Assert.assertEquals((Object)"analyze \t select    *   \t from table1", (Object)explainCommandConverter.convert("explain \n analyze \t select    *   \t from table1"));
        Assert.assertEquals((Object)"analyze foo", (Object)explainCommandConverter.convert("explain  analyze foo"));
        Assert.assertEquals((Object)"analyze", (Object)explainCommandConverter.convert("explain analyze"));
        Assert.assertEquals((Object)"(analyze \t select    *   \t from table1", (Object)explainCommandConverter.convert("explain \n (analyze \t select    *   \t from table1"));
        Assert.assertEquals((Object)"(analyze \t select    *   \t from table1)", (Object)explainCommandConverter.convert("explain \n (analyze \t select    *   \t from table1)"));
        Assert.assertEquals((Object)"analyse select * from table1", (Object)explainCommandConverter.convert("explain analyse select * from table1"));
        Assert.assertEquals((Object)"analyse \tselect    *   \t from table1", (Object)explainCommandConverter.convert("explain \t analyse \tselect    *   \t from table1"));
        Assert.assertEquals((Object)"analyse foo", (Object)explainCommandConverter.convert("explain  analyse foo"));
        Assert.assertEquals((Object)"analyse", (Object)explainCommandConverter.convert("explain analyse"));
    }
}

