/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.protobuf.Value;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PlanNode;
import com.google.spanner.v1.QueryPlan;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExplainTest
extends AbstractMockServerTest {
    private static final Statement EXPLAIN_STATEMENT_QUERY = Statement.of((String)"SELECT * FROM SomeTable ORDER BY Value");

    @BeforeClass
    public static void setupAnalyzeResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        com.google.protobuf.Struct metadata = com.google.protobuf.Struct.newBuilder().putFields("subquery_cluster_node", Value.newBuilder().setStringValue("1").build()).build();
        com.google.protobuf.Struct cpuTime = com.google.protobuf.Struct.newBuilder().putFields("unit", Value.newBuilder().setStringValue("msec").build()).putFields("total_time", Value.newBuilder().setStringValue("10").build()).build();
        com.google.protobuf.Struct executionStats = com.google.protobuf.Struct.newBuilder().putFields("cpu_time", Value.newBuilder().setStructValue(cpuTime).build()).build();
        ResultSetStats resultSetStats = ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().addPlanNodes(PlanNode.newBuilder().setDisplayName("some-plan-node").setMetadata(metadata).setExecutionStats(executionStats).build()).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(EXPLAIN_STATEMENT_QUERY, com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.INT64).build()).setName("Key").build()).addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.STRING).build()).setName("Value").build()).build()).build()).setStats(resultSetStats).build()));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    private void testExplain(String statement) {
        mockSpanner.clearRequests();
        Statement explainStatement = Statement.of((String)statement);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet resultSet = connection.execute(explainStatement).getResultSet();){
            int count = 0;
            while (resultSet.next()) {
                if (count == 1) {
                    Assert.fail((String)"The resultset was expected t contains exactly 1 row but it contains more than 1 row");
                }
                ++count;
                Struct row = resultSet.getCurrentRowAsStruct();
                Assert.assertEquals((long)1L, (long)row.getColumnCount());
                Assert.assertNotNull((Object)row.getString("QUERY PLAN"));
                String expectedQueryPlan = "some-plan-node : { subquery_cluster_node : 1 }";
                Assert.assertEquals((Object)expectedQueryPlan, (Object)row.getString("QUERY PLAN"));
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)1L, (long)requests.size());
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertEquals((Object)EXPLAIN_STATEMENT_QUERY.getSql(), (Object)request.getSql());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)request.getQueryMode());
    }

    private void testExplainAnalyze(String statement) {
        mockSpanner.clearRequests();
        Statement explainAnalyzeStatement = Statement.of((String)statement);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet resultSet = connection.execute(explainAnalyzeStatement).getResultSet();){
            int count = 0;
            while (resultSet.next()) {
                if (count == 1) {
                    Assert.fail((String)"The resultset was expected t contains exactly 1 row but it contains more than 1 row");
                }
                ++count;
                Struct row = resultSet.getCurrentRowAsStruct();
                Assert.assertEquals((long)2L, (long)row.getColumnCount());
                Assert.assertNotNull((Object)row.getString("QUERY PLAN"));
                String expectedQueryPlan = "some-plan-node : { subquery_cluster_node : 1 }";
                Assert.assertEquals((Object)expectedQueryPlan, (Object)row.getString("QUERY PLAN"));
                Assert.assertNotNull((Object)row.getString("EXECUTION STATS"));
                String expectedExecutionStats = "cpu_time : { unit : msec , total_time : 10 }";
                Assert.assertEquals((Object)expectedExecutionStats, (Object)row.getString("EXECUTION STATS"));
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)1L, (long)requests.size());
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertEquals((Object)EXPLAIN_STATEMENT_QUERY.getSql(), (Object)request.getSql());
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PROFILE, (Object)request.getQueryMode());
    }

    @Test
    public void testValidExplain() {
        String statement = "Explain " + EXPLAIN_STATEMENT_QUERY;
        this.testExplain(statement);
        statement = "explain " + EXPLAIN_STATEMENT_QUERY;
        this.testExplain(statement);
        statement = "explain     " + EXPLAIN_STATEMENT_QUERY;
        this.testExplain(statement);
        statement = "explain \t (" + EXPLAIN_STATEMENT_QUERY + ") ";
        this.testExplain(statement);
        statement = "    explain \t ( \n   " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    ExpLAin  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    EXPLAIN  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
    }

    @Test
    public void testValidExplainWithFalseAnalyze() {
        String statement = "    explain (analyze false)      " + EXPLAIN_STATEMENT_QUERY;
        this.testExplain(statement);
        statement = "    explain (analyze FALSE)      " + EXPLAIN_STATEMENT_QUERY + "    ";
        this.testExplain(statement);
        statement = "    explain (analyze fAlsE)  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    explain (analyze 0)  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    explain (analyze off)  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    explain (analyze false, analyze true, analyze false, analyze false)      " + EXPLAIN_STATEMENT_QUERY;
        this.testExplain(statement);
        statement = "    explain (   analyze off , analyze true , analyze 0  )  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    explain (   analyze off , analyze 0 , analyze 0  )  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
        statement = "    explain (   analyze off , analyze,   analyze 0 , analyze false  )  (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplain(statement);
    }

    @Test
    public void testValidExplainAnalyze() {
        String statement = "Explain analyze " + EXPLAIN_STATEMENT_QUERY;
        this.testExplainAnalyze(statement);
        statement = "explain analyze " + EXPLAIN_STATEMENT_QUERY;
        this.testExplainAnalyze(statement);
        statement = "explain   analyze  " + EXPLAIN_STATEMENT_QUERY;
        this.testExplainAnalyze(statement);
        statement = "explain analyze (" + EXPLAIN_STATEMENT_QUERY + ") ";
        this.testExplainAnalyze(statement);
        statement = "    explain (  analyze true  ) (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    ExpLAin(   analyze 1  ) (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    ExpLAin(   analyze On  ) (    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyze)(    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyze , analyze false , analyze 1)(    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyze , aNAlyzE false , analyze  )(    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyze off  , analyze false , AnalYZE  )(    " + EXPLAIN_STATEMENT_QUERY + "   ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyze \n off  , analyze false , analyze  )(    " + EXPLAIN_STATEMENT_QUERY + " \t  ) ";
        this.testExplainAnalyze(statement);
        statement = "    EXPLAIN(analyse \n off  , analyze false , analyse  )(    " + EXPLAIN_STATEMENT_QUERY + " \t  ) ";
        this.testExplainAnalyze(statement);
    }

    @Test
    public void testInvalidExplain() {
        String statement = " explain  verbose " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement));
        String statement2 = " explain  foo " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement2));
        String statement3 = " explain  analyze analyze  " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement3));
        String statement4 = " explain  analyze true  " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement4));
        String statement5 = " explain  (analyze true , verbose )   " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement5));
        String statement6 = " explain  (analyze hello)   " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement6));
        String statement7 = " explain  (analyze true , verbose , costs )   " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement7));
        String statement8 = " explain  (analyze true , verbose , costs    " + EXPLAIN_STATEMENT_QUERY;
        Assert.assertThrows(SpannerException.class, () -> this.testExplain(statement8));
    }
}

