/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.LocalConnectionChecker;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalConnectionCheckerTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private LocalConnectionChecker connectionChecker;

    @BeforeClass
    public static void beforeClass() throws Exception {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        InetSocketAddress address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).build();
        server.start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        this.connectionChecker = new LocalConnectionChecker();
    }

    @Test
    public void testMockSpanner() {
        String uri = String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true", server.getPort());
        ConnectionOptions connectionOptions = ConnectionOptions.newBuilder().setUri(uri).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.SELECT1, MockSpannerTestUtil.SELECT1_RESULTSET));
        try (Connection connection = connectionOptions.getConnection();
             ResultSet resultSet = connection.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
    }

    @Test
    public void testNoRunningEmulator() {
        int port = server.getPort() - 1;
        String uri = String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?usePlainText=true", port);
        ConnectionOptions connectionOptions = ConnectionOptions.newBuilder().setUri(uri).build();
        try {
            this.connectionChecker.checkLocalConnection(connectionOptions);
            Assert.fail((String)"Unavailable exception expected");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)("UNAVAILABLE: The connection string '" + uri + "' contains host 'localhost:" + port + "', but no running emulator or other server could be found at that address.\nPlease check the connection string and/or that the emulator is running."), (Object)e.getMessage());
        }
    }
}

