/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.PartitionId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionIdTest {
    @Test
    public void testDeserializeInvalid() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(byteArrayOutputStream));){
            objectOutputStream.writeObject(new TestObject("foo"));
        }
        String base64 = Base64.getUrlEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> PartitionId.decodeFromString((String)base64));
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)(ErrorCode.INVALID_ARGUMENT + ": The id does not contain a valid PartitionId instance; com.google.cloud.spanner.connection.PartitionIdTest$TestObject"), (Object)exception.getMessage());
    }

    private static class TestObject
    implements Serializable {
        private final String id;

        TestObject(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

