/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.SingerProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RandomResultSetGenerator {
    private final ResultSetMetadata metadata;
    private final Dialect dialect;
    private final Type[] types;
    private final int rowCount;
    private final Random random = new Random();

    public static Type[] generateAllTypes(Dialect dialect) {
        ArrayList<Type> types = new ArrayList<Type>(Arrays.asList(Type.newBuilder().setCode(TypeCode.BOOL).build(), Type.newBuilder().setCode(TypeCode.INT64).build(), Type.newBuilder().setCode(TypeCode.FLOAT32).build(), Type.newBuilder().setCode(TypeCode.FLOAT64).build(), dialect == Dialect.POSTGRESQL ? Type.newBuilder().setCode(TypeCode.NUMERIC).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC).build() : Type.newBuilder().setCode(TypeCode.NUMERIC).build(), Type.newBuilder().setCode(TypeCode.STRING).build(), dialect == Dialect.POSTGRESQL ? Type.newBuilder().setCode(TypeCode.JSON).setTypeAnnotation(TypeAnnotationCode.PG_JSONB).build() : Type.newBuilder().setCode(TypeCode.JSON).build(), Type.newBuilder().setCode(TypeCode.BYTES).build(), Type.newBuilder().setCode(TypeCode.DATE).build(), Type.newBuilder().setCode(TypeCode.TIMESTAMP).build()));
        if (dialect == Dialect.POSTGRESQL) {
            types.add(Type.newBuilder().setCode(TypeCode.INT64).setTypeAnnotation(TypeAnnotationCode.PG_OID).build());
        }
        types.addAll(Arrays.asList(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.BOOL)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.INT64)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.FLOAT32)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.FLOAT64)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(dialect == Dialect.POSTGRESQL ? Type.newBuilder().setCode(TypeCode.NUMERIC).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC) : Type.newBuilder().setCode(TypeCode.NUMERIC)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.STRING)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(dialect == Dialect.POSTGRESQL ? Type.newBuilder().setCode(TypeCode.JSON).setTypeAnnotation(TypeAnnotationCode.PG_JSONB) : Type.newBuilder().setCode(TypeCode.JSON)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.BYTES)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.DATE)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.TIMESTAMP)).build()));
        RandomResultSetGenerator.appendProtoTypes(types, dialect);
        if (dialect == Dialect.POSTGRESQL) {
            types.add(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.INT64).setTypeAnnotation(TypeAnnotationCode.PG_OID)).build());
        }
        Type[] typeArray = new Type[types.size()];
        typeArray = types.toArray(typeArray);
        return typeArray;
    }

    private static void appendProtoTypes(List<Type> types, Dialect dialect) {
        if (dialect == Dialect.GOOGLE_STANDARD_SQL) {
            types.add(Type.newBuilder().setCode(TypeCode.PROTO).setProtoTypeFqn(SingerProto.SingerInfo.getDescriptor().getFullName()).build());
            types.add(Type.newBuilder().setCode(TypeCode.ENUM).setProtoTypeFqn(SingerProto.Genre.getDescriptor().getFullName()).build());
            types.add(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.PROTO).setProtoTypeFqn(SingerProto.SingerInfo.getDescriptor().getFullName())).build());
            types.add(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.ENUM).setProtoTypeFqn(SingerProto.Genre.getDescriptor().getFullName())).build());
        }
    }

    public static ResultSetMetadata generateAllTypesMetadata(Type[] types) {
        StructType.Builder rowTypeBuilder = StructType.newBuilder();
        for (int col = 0; col < types.length; ++col) {
            rowTypeBuilder.addFields(StructType.Field.newBuilder().setName("COL" + col).setType(types[col])).build();
        }
        ResultSetMetadata.Builder builder = ResultSetMetadata.newBuilder();
        builder.setRowType(rowTypeBuilder.build());
        return builder.build();
    }

    public RandomResultSetGenerator(int rowCount) {
        this(rowCount, Dialect.GOOGLE_STANDARD_SQL);
    }

    public RandomResultSetGenerator(int rowCount, Dialect dialect) {
        this.rowCount = rowCount;
        this.dialect = dialect;
        this.types = RandomResultSetGenerator.generateAllTypes(dialect);
        this.metadata = RandomResultSetGenerator.generateAllTypesMetadata(this.types);
    }

    public ResultSet generate() {
        ResultSet.Builder builder = ResultSet.newBuilder();
        for (int row = 0; row < this.rowCount; ++row) {
            ListValue.Builder rowBuilder = ListValue.newBuilder();
            for (Type type : this.types) {
                Value.Builder valueBuilder = Value.newBuilder();
                this.setRandomValue(valueBuilder, type);
                rowBuilder.addValues(valueBuilder.build());
            }
            builder.addRows(rowBuilder.build());
        }
        builder.setMetadata(this.metadata);
        return builder.build();
    }

    private void setRandomValue(Value.Builder builder, Type type) {
        if (this.randomNull()) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else {
            switch (type.getCode()) {
                case ARRAY: {
                    int length = this.random.nextInt(20) + 1;
                    ListValue.Builder arrayBuilder = ListValue.newBuilder();
                    for (int i = 0; i < length; ++i) {
                        Value.Builder valueBuilder = Value.newBuilder();
                        this.setRandomValue(valueBuilder, type.getArrayElementType());
                        arrayBuilder.addValues(valueBuilder.build());
                    }
                    builder.setListValue(arrayBuilder.build());
                    break;
                }
                case BOOL: {
                    builder.setBoolValue(this.random.nextBoolean());
                    break;
                }
                case STRING: 
                case BYTES: 
                case PROTO: {
                    byte[] bytes = new byte[this.random.nextInt(200)];
                    this.random.nextBytes(bytes);
                    builder.setStringValue(BaseEncoding.base64().encode(bytes));
                    break;
                }
                case JSON: {
                    builder.setStringValue("\"" + this.random.nextInt(200) + "\":\"" + this.random.nextInt(200) + "\"");
                    break;
                }
                case DATE: {
                    Date date = Date.fromYearMonthDay((int)(this.random.nextInt(2019) + 1), (int)(this.random.nextInt(11) + 1), (int)(this.random.nextInt(28) + 1));
                    builder.setStringValue(date.toString());
                    break;
                }
                case FLOAT32: {
                    if (this.randomNaN()) {
                        builder.setNumberValue(Double.NaN);
                        break;
                    }
                    builder.setNumberValue((double)this.random.nextFloat());
                    break;
                }
                case FLOAT64: {
                    if (this.randomNaN()) {
                        builder.setNumberValue(Double.NaN);
                        break;
                    }
                    builder.setNumberValue(this.random.nextDouble());
                    break;
                }
                case NUMERIC: {
                    if (this.dialect == Dialect.POSTGRESQL && this.randomNaN()) {
                        builder.setStringValue("NaN");
                        break;
                    }
                    builder.setStringValue(BigDecimal.valueOf(this.random.nextDouble()).setScale(9, RoundingMode.HALF_UP).toString());
                    break;
                }
                case INT64: 
                case ENUM: {
                    builder.setStringValue(String.valueOf(this.random.nextLong()));
                    break;
                }
                case TIMESTAMP: {
                    com.google.protobuf.Timestamp ts = Timestamps.add((com.google.protobuf.Timestamp)Timestamps.EPOCH, (Duration)Duration.newBuilder().setSeconds((long)this.random.nextInt(100000000)).setNanos(this.random.nextInt(1000000000)).build());
                    builder.setStringValue(Timestamp.fromProto((com.google.protobuf.Timestamp)ts).toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown or unsupported type: " + type.getCode());
                }
            }
        }
    }

    private boolean randomNull() {
        return this.random.nextInt(10) == 0;
    }

    private boolean randomNaN() {
        return this.random.nextInt(10) == 0;
    }
}

