/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionMutationLimitExceededException;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Help;
import com.google.rpc.Status;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryDmlAsPartitionedDmlMockServerTest
extends AbstractMockServerTest {
    static StatusRuntimeException createTransactionMutationLimitExceededException() {
        Metadata.Key key = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
        Help help = Help.newBuilder().addLinks(Help.Link.newBuilder().setDescription("Cloud Spanner limits documentation.").setUrl("https://cloud.google.com/spanner/docs/limits").build()).build();
        Status status = Status.newBuilder().addDetails(Any.pack((Message)help)).build();
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)status.toByteArray());
        return io.grpc.Status.INVALID_ARGUMENT.withDescription("The transaction contains too many mutations.").asRuntimeException(trailers);
    }

    @Test
    public void testTransactionMutationLimitExceeded_isNotRetriedByDefault() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)RetryDmlAsPartitionedDmlMockServerTest.createTransactionMutationLimitExceededException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL, (Object)connection.getAutocommitDmlMode());
            TransactionMutationLimitExceededException exception = (TransactionMutationLimitExceededException)Assert.assertThrows(TransactionMutationLimitExceededException.class, () -> connection.executeUpdate(Statement.of((String)"update test set value=1 where true")));
            Assert.assertEquals((long)0L, (long)exception.getSuppressed().length);
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testTransactionMutationLimitExceeded_canBeRetriedAsPDML() {
        Statement statement = Statement.of((String)"update test set value=1 where true");
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)RetryDmlAsPartitionedDmlMockServerTest.createTransactionMutationLimitExceededException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement, 100000L));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC);
            long updateCount = connection.executeUpdate(statement);
            Assert.assertEquals((long)100000L, (long)updateCount);
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest transactionalRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)transactionalRequest.getTransaction().getBegin().hasReadWrite());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        BeginTransactionRequest beginRequest = mockSpanner.getRequestsOfType(BeginTransactionRequest.class).get(0);
        Assert.assertTrue((boolean)beginRequest.getOptions().hasPartitionedDml());
        ExecuteSqlRequest partitionedDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
        Assert.assertTrue((boolean)partitionedDmlRequest.getTransaction().hasId());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testTransactionMutationLimitExceeded_retryAsPDMLFails() {
        Statement statement = Statement.of((String)"insert into test (id, value) select -id, value from test");
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)RetryDmlAsPartitionedDmlMockServerTest.createTransactionMutationLimitExceededException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(statement, io.grpc.Status.INVALID_ARGUMENT.withDescription("This statement is not supported with Partitioned DML").asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC);
            TransactionMutationLimitExceededException exception = (TransactionMutationLimitExceededException)Assert.assertThrows(TransactionMutationLimitExceededException.class, () -> connection.executeUpdate(statement));
            Assert.assertEquals((long)1L, (long)exception.getSuppressed().length);
            Assert.assertEquals(SpannerException.class, exception.getSuppressed()[0].getClass());
            SpannerException spannerException = (SpannerException)exception.getSuppressed()[0];
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)spannerException.getErrorCode());
            Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("This statement is not supported with Partitioned DML"));
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest transactionalRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertTrue((boolean)transactionalRequest.getTransaction().getBegin().hasReadWrite());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
        BeginTransactionRequest beginRequest = mockSpanner.getRequestsOfType(BeginTransactionRequest.class).get(0);
        Assert.assertTrue((boolean)beginRequest.getOptions().hasPartitionedDml());
        ExecuteSqlRequest partitionedDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
        Assert.assertTrue((boolean)partitionedDmlRequest.getTransaction().hasId());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testSqlStatements() {
        for (Dialect dialect : Dialect.values()) {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(dialect));
            String prefix = dialect == Dialect.POSTGRESQL ? "SPANNER." : "";
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(true);
                try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sautocommit_dml_mode", prefix)), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL.name(), (Object)resultSet.getString(String.format("%sAUTOCOMMIT_DML_MODE", prefix)));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                connection.execute(Statement.of((String)String.format("set %sautocommit_dml_mode = 'transactional_with_fallback_to_partitioned_non_atomic'", prefix)));
                resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sautocommit_dml_mode", prefix)), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC.name(), (Object)resultSet.getString(String.format("%sAUTOCOMMIT_DML_MODE", prefix)));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }
}

