/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RunTransactionMockServerTest
extends AbstractMockServerTest {
    @Test
    public void testRunTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                return null;
            });
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRunTransactionInAutoCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                return null;
            });
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRunTransactionInReadOnly() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            Assert.assertEquals((long)100L, (long)((Integer)connection.runTransaction(transaction -> {
                int rows = 0;
                try (ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    while (resultSet.next()) {
                        ++rows;
                    }
                }
                return rows;
            })).intValue());
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
    }

    @Test
    public void testRunTransaction_rollbacksAfterException() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
                transaction.executeUpdate(INSERT_STATEMENT);
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().endsWith("invalid statement"));
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
    }

    @Test
    public void testRunTransactionCommitAborted() {
        AtomicInteger attempts = new AtomicInteger();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                if (attempts.incrementAndGet() == 1) {
                    mockSpanner.abortNextStatement();
                }
                return null;
            });
        }
        Assert.assertEquals((long)2L, (long)attempts.get());
        Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRunTransactionDmlAborted() {
        AtomicInteger attempts = new AtomicInteger();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
            connection.runTransaction(transaction -> {
                Assert.assertFalse((boolean)transaction.isRetryAbortsInternally());
                if (attempts.incrementAndGet() == 1) {
                    mockSpanner.abortNextStatement();
                }
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                return null;
            });
            Assert.assertTrue((boolean)connection.isRetryAbortsInternally());
        }
        Assert.assertEquals((long)2L, (long)attempts.get());
        Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRunTransactionQueryAborted() {
        AtomicInteger attempts = new AtomicInteger();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            int rowCount = (Integer)connection.runTransaction(transaction -> {
                if (attempts.incrementAndGet() == 1) {
                    mockSpanner.abortNextStatement();
                }
                int rows = 0;
                try (ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    while (resultSet.next()) {
                        ++rows;
                    }
                }
                return rows;
            });
            Assert.assertEquals((long)100L, (long)rowCount);
        }
        Assert.assertEquals((long)2L, (long)attempts.get());
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testCommitInRunTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)transaction).commit());
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                Assert.assertEquals((Object)"FAILED_PRECONDITION: Cannot call commit when a transaction runner is active", (Object)exception.getMessage());
                return null;
            });
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRollbackInRunTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.runTransaction(transaction -> {
                Assert.assertEquals((long)1L, (long)transaction.executeUpdate(INSERT_STATEMENT));
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)transaction).rollback());
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                Assert.assertEquals((Object)"FAILED_PRECONDITION: Cannot call rollback when a transaction runner is active", (Object)exception.getMessage());
                return null;
            });
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
    }
}

