/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractConnectionImplTest;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Collections2;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Status;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatementTimeoutTest
extends AbstractMockServerTest {
    private static final String SLOW_SELECT = "SELECT foo FROM bar";
    private static final String INVALID_SELECT = "SELECT FROM bar";
    private static final String SLOW_DDL = "CREATE TABLE foo";
    private static final String FAST_DDL = "CREATE TABLE fast_table";
    private static final String SLOW_UPDATE = "UPDATE foo SET col1=1 WHERE id=2";
    private static final int EXECUTION_TIME_SLOW_STATEMENT = 10000;
    private static final long TIMEOUT_FOR_FAST_STATEMENTS = 1000L;
    private static final int TIMEOUT_FOR_SLOW_STATEMENTS = 50;
    @Parameterized.Parameter
    public StatementExecutor.StatementExecutorType statementExecutorType;

    @Parameterized.Parameters(name="statementExecutorType = {0}")
    public static Object[] parameters() {
        return StatementExecutor.StatementExecutorType.values();
    }

    @Override
    protected ITAbstractSpannerTest.ITConnection createConnection() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri(this.getBaseUrl() + ";trackSessionLeaks=false").setStatementExecutorType(this.statementExecutorType).setConfigurator(optionsConfigurator -> optionsConfigurator.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1L)).setMaxRetryDelayDuration(Duration.ofMillis(1L)).setRetryDelayMultiplier(1.0).setTotalTimeoutDuration(Duration.ofMinutes(10L)).build()))).build();
        return this.createITConnection(options);
    }

    @Before
    public void setup() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.getDialect();
        }
    }

    @After
    public void clearExecutionTimes() {
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void testTimeoutExceptionReadOnlyAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyTransactionMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            connection.clearStatementTimeout();
            connection.rollback();
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowUpdate() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowUpdateMultipleStatements() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)SLOW_UPDATE)));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)1L, (long)connection.execute(INSERT_STATEMENT).getUpdateCount());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowCommit() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.setAutocommit(false);
            connection.execute(INSERT_STATEMENT);
            connection.rollback();
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.setAutocommit(true);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowCommitMultipleStatements() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitPartitioned() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.execute(INSERT_STATEMENT);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                if (i == 0) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                    continue;
                }
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
            connection.clearStatementTimeout();
            connection.rollback();
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionalSlowCommit() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.commit());
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionalSlowRollback() {
        mockSpanner.setRollbackExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertNotNull((Object)rs);
            }
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.rollback();
        }
    }

    @Test
    public void testInterruptedExceptionReadOnlyAutocommit() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadOnlyAutocommit());
    }

    @Test
    public void testInterruptedExceptionReadOnlyTransactional() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadOnlyTransactional());
    }

    @Test
    public void testInterruptedExceptionReadWriteAutocommit() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadWriteAutocommit());
    }

    @Test
    public void testInterruptedExceptionReadWriteTransactional() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadWriteTransactional());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInterruptedException(AbstractConnectionImplTest.ConnectionConsumer consumer) throws InterruptedException, ExecutionException {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        CountDownLatch latch = new CountDownLatch(1);
        SettableApiFuture thread = SettableApiFuture.create();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future = executor.submit(() -> {
                Boolean bl;
                block9: {
                    ITAbstractSpannerTest.ITConnection connection = this.createConnection();
                    try {
                        consumer.accept(connection);
                        connection.setStatementTimeout(10000L, TimeUnit.MILLISECONDS);
                        thread.set((Object)Thread.currentThread());
                        latch.countDown();
                        ResultSet ignore = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                        if (ignore != null) {
                            ignore.close();
                        }
                        bl = false;
                        if (connection == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SpannerException e) {
                            return e.getErrorCode() == ErrorCode.CANCELLED;
                        }
                    }
                    connection.close();
                }
                return bl;
            });
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
            ((Thread)thread.get()).interrupt();
            Assert.assertTrue((boolean)future.get());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testInvalidQueryReadOnlyAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidQueryReadOnlyTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidQueryReadWriteAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidQueryReadWriteTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    static void waitForRequestsToContain(Class<? extends AbstractMessage> request) {
        try {
            mockSpanner.waitForRequestsToContain(request, 10000L);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
        catch (TimeoutException e) {
            throw SpannerExceptionFactory.propagateTimeout((TimeoutException)e);
        }
    }

    private void waitForDdlRequestOnServer() {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            while (Collections2.filter(mockDatabaseAdmin.getRequests(), input -> input.getClass().equals(UpdateDatabaseDdlRequest.class)).size() == 0) {
                Thread.sleep(1L);
                if (watch.elapsed(TimeUnit.MILLISECONDS) <= 10000L) continue;
                throw new TimeoutException("Timeout while waiting for DDL request");
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
        catch (TimeoutException e) {
            throw SpannerExceptionFactory.propagateTimeout((TimeoutException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyAutocommit() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyAutocommitMultipleStatements() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.CANCELLED)));
                mockSpanner.removeAllExecutionTimes();
                connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
                try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertNotNull((Object)rs);
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyTransactional() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyTransactionalMultipleStatements() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(Statement.of((String)SLOW_SELECT), new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
                mockSpanner.removeAllExecutionTimes();
                connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
                try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertNotNull((Object)rs);
                }
                connection.rollback();
                rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                try {
                    Assert.assertNotNull((Object)rs);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommit() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitMultipleStatements() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
                mockSpanner.removeAllExecutionTimes();
                connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
                try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertNotNull((Object)rs);
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitSlowUpdate() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitSlowCommit() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(CommitRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteTransactional() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteTransactionalMultipleStatements() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
                connection.rollback();
                mockSpanner.removeAllExecutionTimes();
                connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
                try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    Assert.assertNotNull((Object)rs);
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    static void addSlowMockDdlOperation() {
        StatementTimeoutTest.addSlowMockDdlOperations(1);
    }

    static void addSlowMockDdlOperations(int count) {
        StatementTimeoutTest.addMockDdlOperations(count, false);
    }

    static void addFastMockDdlOperation() {
        StatementTimeoutTest.addFastMockDdlOperations(1);
    }

    static void addFastMockDdlOperations(int count) {
        StatementTimeoutTest.addMockDdlOperations(count, true);
    }

    static void addMockDdlOperations(int count, boolean done) {
        for (int i = 0; i < count; ++i) {
            mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().addStatements(SLOW_DDL).setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(done).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelDdlBatch() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        StatementTimeoutTest.addSlowMockDdlOperation();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDdl();
            connection.execute(Statement.of((String)SLOW_DDL));
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    this.waitForDdlRequestOnServer();
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.runBatch());
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelDdlAutocommit() {
        Assume.assumeFalse((String)"Direct executor does not yet support cancelling statements", (this.statementExecutorType == StatementExecutor.StatementExecutorType.DIRECT_EXECUTOR ? 1 : 0) != 0);
        StatementTimeoutTest.addSlowMockDdlOperation();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    this.waitForDdlRequestOnServer();
                    connection.cancel();
                });
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)SLOW_DDL)));
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    @Test
    public void testTimeoutExceptionDdlAutocommit() {
        StatementTimeoutTest.addSlowMockDdlOperations(10);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)SLOW_DDL)));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionDdlAutocommitMultipleStatements() {
        StatementTimeoutTest.addSlowMockDdlOperations(20);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)SLOW_DDL)));
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            mockDatabaseAdmin.reset();
            StatementTimeoutTest.addFastMockDdlOperation();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)connection.execute(Statement.of((String)FAST_DDL)));
        }
    }

    @Test
    public void testTimeoutExceptionDdlBatch() {
        StatementTimeoutTest.addSlowMockDdlOperations(10);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDdl();
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.execute(Statement.of((String)SLOW_DDL));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.runBatch());
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionDdlBatchMultipleStatements() {
        StatementTimeoutTest.addSlowMockDdlOperations(20);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                connection.startBatchDdl();
                connection.execute(Statement.of((String)SLOW_DDL));
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.runBatch());
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            }
            mockDatabaseAdmin.reset();
            StatementTimeoutTest.addFastMockDdlOperation();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.startBatchDdl();
            Assert.assertNotNull((Object)connection.execute(Statement.of((String)FAST_DDL)));
            connection.runBatch();
        }
    }

    @Test
    public void testTimeoutDifferentTimeUnits() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
                connection.setStatementTimeout(1L, unit);
            }
        }
    }

    private static final class ConnectionReadOnlyAutocommit
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadOnlyAutocommit() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(true);
            t.setReadOnly(true);
        }
    }

    private static final class ConnectionReadOnlyTransactional
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadOnlyTransactional() {
        }

        @Override
        public void accept(Connection t) {
            t.setReadOnly(true);
            t.setAutocommit(false);
        }
    }

    private static final class ConnectionReadWriteAutocommit
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadWriteAutocommit() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(true);
            t.setReadOnly(false);
        }
    }

    private static final class ConnectionReadWriteTransactional
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadWriteTransactional() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(false);
            t.setReadOnly(false);
        }
    }
}

