/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITCommitResponseTest
extends ITAbstractSpannerTest {
    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Before
    public void clearTestData() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            connection.commit();
        }
    }

    @Test
    public void testDefaultNoCommitStats() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            connection.commit();
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertFalse((boolean)connection.getCommitResponse().hasCommitStats());
        }
    }

    @Test
    public void testReturnCommitStats() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReturnCommitStats(true);
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            connection.commit();
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertTrue((boolean)connection.getCommitResponse().hasCommitStats());
            Assert.assertEquals((long)2L, (long)connection.getCommitResponse().getCommitStats().getMutationCount());
        }
    }

    @Test
    public void testReturnCommitStatsUsingSql() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"SET RETURN_COMMIT_STATS=TRUE"));
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            connection.commit();
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertTrue((boolean)connection.getCommitResponse().hasCommitStats());
            Assert.assertEquals((long)2L, (long)connection.getCommitResponse().getCommitStats().getMutationCount());
            try (ResultSet resultSet = connection.execute(Statement.of((String)"SHOW VARIABLE COMMIT_RESPONSE")).getResultSet();){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getTimestamp("COMMIT_TIMESTAMP"));
                Assert.assertEquals((long)2L, (long)resultSet.getLong("MUTATION_COUNT"));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testAutocommitDefaultNoCommitStats() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertFalse((boolean)connection.getCommitResponse().hasCommitStats());
        }
    }

    @Test
    public void testAutocommitReturnCommitStats() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReturnCommitStats(true);
            connection.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertTrue((boolean)connection.getCommitResponse().hasCommitStats());
            Assert.assertEquals((long)2L, (long)connection.getCommitResponse().getCommitStats().getMutationCount());
        }
    }

    @Test
    public void testAutocommitReturnCommitStatsUsingSql() {
        Assume.assumeFalse((String)"Emulator does not return commit statistics", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"SET AUTOCOMMIT=TRUE"));
            connection.execute(Statement.of((String)"SET RETURN_COMMIT_STATS=TRUE"));
            connection.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            Assert.assertNotNull((Object)connection.getCommitResponse());
            Assert.assertNotNull((Object)connection.getCommitResponse().getCommitTimestamp());
            Assert.assertTrue((boolean)connection.getCommitResponse().hasCommitStats());
            Assert.assertEquals((long)2L, (long)connection.getCommitResponse().getCommitStats().getMutationCount());
            try (ResultSet resultSet = connection.execute(Statement.of((String)"SHOW VARIABLE COMMIT_RESPONSE")).getResultSet();){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getTimestamp("COMMIT_TIMESTAMP"));
                Assert.assertEquals((long)2L, (long)resultSet.getLong("MUTATION_COUNT"));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }
}

