/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionMutationLimitExceededException;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.TransactionRetryListenerImpl;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITRetryDmlAsPartitionedDmlTest
extends ITAbstractSpannerTest {
    private static final int NUM_ROWS = 100000;

    @BeforeClass
    public static void setup() {
    }

    @BeforeClass
    public static void setupTestData() {
        Assume.assumeFalse((String)"The emulator does not enforce the mutation limit", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        database = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TEST (ID INT64 NOT NULL, NAME STRING(100) NOT NULL) PRIMARY KEY (ID)"});
        DatabaseClient client = env.getTestHelper().getClient().getDatabaseClient(database.getId());
        int batchSize = 5000;
        for (int rowsCreated = 0; rowsCreated < 100000; rowsCreated += batchSize) {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(batchSize);
            for (int row = rowsCreated; row < rowsCreated + batchSize; ++row) {
                mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"TEST").set("id").to((long)row)).set("name").to("Row " + row)).build());
            }
            client.writeAtLeastOnce(mutations);
        }
    }

    @Test
    public void testDmlFailsIfMutationLimitExceeded() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            Assert.assertThrows(TransactionMutationLimitExceededException.class, () -> connection.executeUpdate(Statement.of((String)"update test set name=name || ' - updated' where true")));
        }
    }

    @Test
    public void testRetryDmlAsPartitionedDml() throws Exception {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC);
            final SettableApiFuture startExecutionIdFuture = SettableApiFuture.create();
            final SettableApiFuture finishedExecutionIdFuture = SettableApiFuture.create();
            final SettableApiFuture lowerBoundUpdateCountFuture = SettableApiFuture.create();
            connection.addTransactionRetryListener((TransactionRetryListener)new TransactionRetryListenerImpl(){

                public void retryDmlAsPartitionedDmlStarting(UUID executionId, Statement statement, TransactionMutationLimitExceededException exception) {
                    startExecutionIdFuture.set((Object)executionId);
                }

                public void retryDmlAsPartitionedDmlFinished(UUID executionId, Statement statement, long updateCount) {
                    finishedExecutionIdFuture.set((Object)executionId);
                    lowerBoundUpdateCountFuture.set((Object)updateCount);
                }
            });
            long updateCount = connection.executeUpdate(Statement.of((String)"update test set name=name || ' - updated' where true"));
            Assert.assertEquals((long)100000L, (long)updateCount);
            Assert.assertEquals((Object)startExecutionIdFuture.get(1L, TimeUnit.SECONDS), (Object)finishedExecutionIdFuture.get(1L, TimeUnit.SECONDS));
            Assert.assertEquals((long)updateCount, (long)((Long)lowerBoundUpdateCountFuture.get(1L, TimeUnit.SECONDS)));
        }
    }

    @Test
    public void testRetryDmlAsPartitionedDml_failsForLargeInserts() throws Exception {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL_WITH_FALLBACK_TO_PARTITIONED_NON_ATOMIC);
            final SettableApiFuture startExecutionIdFuture = SettableApiFuture.create();
            final SettableApiFuture failedExecutionIdFuture = SettableApiFuture.create();
            final SettableApiFuture executionExceptionFuture = SettableApiFuture.create();
            connection.addTransactionRetryListener((TransactionRetryListener)new TransactionRetryListenerImpl(){

                public void retryDmlAsPartitionedDmlStarting(UUID executionId, Statement statement, TransactionMutationLimitExceededException exception) {
                    startExecutionIdFuture.set((Object)executionId);
                }

                public void retryDmlAsPartitionedDmlFailed(UUID executionId, Statement statement, Throwable exception) {
                    failedExecutionIdFuture.set((Object)executionId);
                    executionExceptionFuture.set((Object)exception);
                }
            });
            TransactionMutationLimitExceededException mutationLimitExceededException = (TransactionMutationLimitExceededException)Assert.assertThrows(TransactionMutationLimitExceededException.class, () -> connection.executeUpdate(Statement.of((String)"insert into test (id, name) select -id, name from test")));
            Assert.assertEquals((Object)startExecutionIdFuture.get(1L, TimeUnit.SECONDS), (Object)failedExecutionIdFuture.get(1L, TimeUnit.SECONDS));
            Throwable executionException = (Throwable)executionExceptionFuture.get(1L, TimeUnit.SECONDS);
            Assert.assertEquals(SpannerException.class, executionException.getClass());
            SpannerException spannerException = (SpannerException)executionException;
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)spannerException.getErrorCode());
            Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("INSERT is not supported for Partitioned DML."));
            Assert.assertEquals((long)1L, (long)mutationLimitExceededException.getSuppressed().length);
            Assert.assertSame((Object)((Object)spannerException), (Object)mutationLimitExceededException.getSuppressed()[0]);
        }
    }
}

