/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.cloud.spanner.encryption.EncryptionConfigs;
import com.google.cloud.spanner.encryption.GoogleDefaultEncryption;
import com.google.cloud.spanner.encryption.UseBackupEncryption;
import com.google.cloud.spanner.encryption.UseDatabaseEncryption;
import org.junit.Assert;
import org.junit.Test;

public class EncryptionConfigsTest {
    @Test
    public void testCustomerManagedEncryption() {
        CustomerManagedEncryption expected = new CustomerManagedEncryption("kms-key-name");
        CustomerManagedEncryption actual = EncryptionConfigs.customerManagedEncryption((String)"kms-key-name");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCustomerManagedEncryptionNullKeyName() {
        EncryptionConfigs.customerManagedEncryption(null);
    }

    @Test
    public void testGoogleDefaultEncryption() {
        Assert.assertSame((Object)EncryptionConfigs.googleDefaultEncryption(), (Object)GoogleDefaultEncryption.INSTANCE);
    }

    @Test
    public void testUseDatabaseEncryption() {
        Assert.assertSame((Object)EncryptionConfigs.useDatabaseEncryption(), (Object)UseDatabaseEncryption.INSTANCE);
    }

    @Test
    public void testUseBackupEncryption() {
        Assert.assertSame((Object)EncryptionConfigs.useBackupEncryption(), (Object)UseBackupEncryption.INSTANCE);
    }
}

