/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.Statement;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
@Ignore(value="Built-in Metrics are not GA'ed yet. Enable this test once the metrics are released")
public class ITBuiltInMetricsTest {
    private static Database db;
    @ClassRule
    public static IntegrationTestEnv env;
    private static DatabaseClient client;
    private static MetricServiceClient metricClient;

    @BeforeClass
    public static void setUp() throws IOException {
        metricClient = MetricServiceClient.create();
        db = env.getTestHelper().createTestDatabase(new String[0]);
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Test
    public void testBuiltinMetricsWithDefaultOTEL() throws Exception {
        Stopwatch metricsPollingStopwatch = Stopwatch.createStarted();
        Instant start = Instant.now().minus(Duration.ofMinutes(2L));
        Instant end = Instant.now().plus(Duration.ofMinutes(3L));
        ProjectName name = ProjectName.of((String)env.getTestHelper().getOptions().getProjectId());
        TimeInterval interval = TimeInterval.newBuilder().setStartTime(Timestamps.fromMillis((long)start.toEpochMilli())).setEndTime(Timestamps.fromMillis((long)end.toEpochMilli())).build();
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeQuery(Statement.of((String)"Select 1"), new Options.QueryOption[0]));
        String metricFilter = String.format("metric.type=\"spanner.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Spanner.ExecuteStreamingSql\" AND metric.labels.database=\"%s\"", "operation_latencies", env.getTestHelper().getInstanceId(), db.getId());
        ListTimeSeriesRequest.Builder requestBuilder = ListTimeSeriesRequest.newBuilder().setName(name.toString()).setFilter(metricFilter).setInterval(interval).setView(ListTimeSeriesRequest.TimeSeriesView.FULL);
        ListTimeSeriesRequest request = requestBuilder.build();
        ListTimeSeriesResponse response = (ListTimeSeriesResponse)metricClient.listTimeSeriesCallable().call((Object)request);
        while (response.getTimeSeriesCount() == 0 && metricsPollingStopwatch.elapsed(TimeUnit.MINUTES) < 3L) {
            Thread.sleep(Duration.ofMinutes(1L).toMillis());
            response = (ListTimeSeriesResponse)metricClient.listTimeSeriesCallable().call((Object)request);
        }
        Truth.assertWithMessage((String)"View operation_latencies didn't return any data.").that(Integer.valueOf(response.getTimeSeriesCount())).isGreaterThan((Comparable)Integer.valueOf(0));
    }

    static {
        env = new IntegrationTestEnv();
    }
}

