/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();

    @Test
    public void badDdl() {
        try {
            env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T ( Illegal Way To Define A Table )"});
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Syntax error on line 1");
        }
    }

    @Test
    public void databaseDeletedTest() throws Exception {
        long millis;
        Database db = env.getTestHelper().createTestDatabase(new String[0]);
        DatabaseClient client = env.getTestHelper().getClient().getDatabaseClient(db.getId());
        try (ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
        db.drop();
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxElapsedTimeMillis(65000).setMaxIntervalMillis(5000).build();
        Throwable notFoundException = null;
        while ((millis = backoff.nextBackOffMillis()) != -1L) {
            Thread.sleep(millis);
            try {
                ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                try {
                    rs.next();
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            catch (DatabaseNotFoundException e) {
                notFoundException = e;
                break;
            }
        }
        Truth.assertThat(notFoundException).isNotNull();
        OperationFuture op = env.getTestHelper().getClient().getDatabaseAdminClient().createDatabase(db.getId().getInstanceId().getInstance(), db.getId().getDatabase(), Collections.emptyList());
        Database newDb = (Database)op.get();
        backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxElapsedTimeMillis(65000).setMaxIntervalMillis(5000).build();
        notFoundException = null;
        while ((millis = backoff.nextBackOffMillis()) != -1L) {
            Thread.sleep(millis);
            try {
                ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                try {
                    rs.next();
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                notFoundException = databaseNotFoundException;
                break;
            }
            catch (SessionNotFoundException sessionNotFoundException) {
                if (EmulatorSpannerHelper.isUsingEmulator()) {
                    notFoundException = sessionNotFoundException;
                    break;
                }
                throw sessionNotFoundException;
            }
        }
        Truth.assertThat((Throwable)notFoundException).isNotNull();
        DatabaseClient newClient = env.getTestHelper().getClient().getDatabaseClient(newDb.getId());
        try (ResultSet rs = newClient.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void instanceNotFound() {
        InstanceId testId = env.getTestHelper().getInstanceId();
        InstanceId nonExistingInstanceId = InstanceId.of((String)testId.getProject(), (String)(testId.getInstance() + "-na"));
        DatabaseClient client = env.getTestHelper().getClient().getDatabaseClient(DatabaseId.of((InstanceId)nonExistingInstanceId, (String)"some-db"));
        try (ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            rs.next();
            Assert.fail((String)"missing expected exception");
        }
        catch (InstanceNotFoundException e) {
            Truth.assertThat((String)e.getResourceName()).isEqualTo((Object)nonExistingInstanceId.getName());
        }
    }

    @Test
    public void testNumericPrimaryKey() {
        String table = "NumericTable";
        Database database = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE NumericTable (Id NUMERIC NOT NULL) PRIMARY KEY (Id)"});
        DatabaseClient databaseClient = env.getTestHelper().getClient().getDatabaseClient(database.getId());
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 5; ++i) {
            mutations.add(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"NumericTable").set("Id").to(new BigDecimal(i + ""))).build());
        }
        databaseClient.write(mutations);
        try (ResultSet resultSet = databaseClient.singleUse().read("NumericTable", KeySet.all(), Collections.singletonList("Id"), new Options.ReadOption[0]);){
            int i = 0;
            while (resultSet.next()) {
                Assert.assertEquals((Object)new BigDecimal(i + ""), (Object)resultSet.getBigDecimal("Id"));
                ++i;
            }
        }
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Object>(){

            @Nullable
            public Object run(TransactionContext transaction) throws Exception {
                transaction.executeUpdate(Statement.of((String)"DELETE FROM NumericTable WHERE Id > 0"), new Options.UpdateOption[0]);
                return null;
            }
        });
        resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(1) as cnt FROM NumericTable"), new Options.QueryOption[0]);
        try {
            resultSet.next();
            Assert.assertEquals((long)1L, (long)resultSet.getLong("cnt"));
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }
}

