/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.protobuf.ListValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITFloat32Test {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    @Parameterized.Parameter
    public DialectTestParameter dialect;
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private static final String[] GOOGLE_STANDARD_SQL_SCHEMA;
    private static final String[] POSTGRESQL_SCHEMA;
    private static DatabaseClient client;
    private static int seq;
    private String lastKey;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        return Arrays.asList(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL), new DialectTestParameter(Dialect.POSTGRESQL));
    }

    @BeforeClass
    public static void setUpDatabase() throws ExecutionException, InterruptedException, TimeoutException {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(GOOGLE_STANDARD_SQL_SCHEMA);
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Arrays.asList(POSTGRESQL_SCHEMA));
        postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
    }

    @Before
    public void before() {
        client = this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? googleStandardSQLClient : postgreSQLClient;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        ConnectionOptions.closeSpanner();
    }

    private static String uniqueString() {
        return String.format("k%04d", seq++);
    }

    private Timestamp write(Mutation m) {
        return client.write(Collections.singletonList(m));
    }

    private Mutation.WriteBuilder baseInsert() {
        this.lastKey = ITFloat32Test.uniqueString();
        return (Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("Key").to(this.lastKey);
    }

    private Struct readRow(String table, String key, String ... columns) {
        return client.singleUse(TimestampBound.strong()).readRow(table, Key.of((Object[])new Object[]{key}), Arrays.asList(columns));
    }

    private Struct readLastRow(String ... columns) {
        return this.readRow("T", this.lastKey, columns);
    }

    @Test
    public void writeFloat32() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32Value").to(2.0f)).build());
        Struct row = this.readLastRow("Float32Value");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((float)2.0f, (float)row.getFloat(0), (float)0.0f);
    }

    @Test
    public void writeFloat32NonNumbers() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32Value").to(Float.NEGATIVE_INFINITY)).build());
        Struct row = this.readLastRow("Float32Value");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)row.getFloat(0), (float)0.0f);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32Value").to(Float.POSITIVE_INFINITY)).build());
        row = this.readLastRow("Float32Value");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)row.getFloat(0), (double)0.0);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32Value").to(Float.NaN)).build());
        row = this.readLastRow("Float32Value");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertTrue((boolean)Float.isNaN(row.getFloat(0)));
    }

    @Test
    public void writeFloat32Null() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32Value").to((Float)null)).build());
        Struct row = this.readLastRow("Float32Value");
        Assert.assertTrue((boolean)row.isNull(0));
    }

    @Test
    public void writeFloat32ArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32ArrayValue").toFloat32Array((float[])null)).build());
        Struct row = this.readLastRow("Float32ArrayValue");
        Assert.assertTrue((boolean)row.isNull(0));
    }

    @Test
    public void writeFloat32ArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32ArrayValue").toFloat32Array(new float[0])).build());
        Struct row = this.readLastRow("Float32ArrayValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertTrue((boolean)row.getFloatList(0).isEmpty());
    }

    @Test
    public void writeFloat32Array() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32ArrayValue").toFloat32Array(Arrays.asList(null, Float.valueOf(1.0f), Float.valueOf(2.0f)))).build());
        Struct row = this.readLastRow("Float32ArrayValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((Object)row.getFloatList(0), Arrays.asList(null, Float.valueOf(1.0f), Float.valueOf(2.0f)));
        Assert.assertThrows(NullPointerException.class, () -> row.getFloatArray(0));
    }

    @Test
    public void writeFloat32ArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float32ArrayValue").toFloat32Array(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f)))).build());
        Struct row = this.readLastRow("Float32ArrayValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((long)2L, (long)row.getFloatArray(0).length);
        Assert.assertEquals((float)1.0f, (float)row.getFloatArray(0)[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)row.getFloatArray(0)[1], (float)0.0f);
    }

    private String getInsertStatementWithLiterals() {
        String statement = "INSERT INTO T (Key, Float32Value, Float32ArrayValue) VALUES ";
        statement = this.dialect.dialect == Dialect.POSTGRESQL ? statement + "('dml1', 3.14::float8, array[1.1]::float4[]), ('dml2', '3.14'::float4, array[3.14::float4, 3.14::float8]::float4[]), ('dml3', 'nan'::real, array['inf'::real, (3.14::float8)::float4, 1.2, '-inf']::float4[]), ('dml4', 1.175494e-38::real, array[1.175494e-38, 3.4028234e38, -3.4028234e38]::real[]), ('dml5', null, null)" : statement + "('dml1', 3.14, [CAST(1.1 AS FLOAT32)]), ('dml2', CAST('3.14' AS FLOAT32), array[CAST(3.14 AS FLOAT32), 3.14]), ('dml3', CAST('nan' AS FLOAT32), array[CAST('inf' AS FLOAT32), CAST(CAST(3.14 AS FLOAT64) AS FLOAT32), 1.2, CAST('-inf' AS FLOAT32)]), ('dml4', 1.175494e-38, [CAST(1.175494e-38 AS FLOAT32), 3.4028234e38, -3.4028234e38]), ('dml5', null, null)";
        return statement;
    }

    @Test
    public void float32Literals() {
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(Statement.of((String)this.getInsertStatementWithLiterals()), new Options.UpdateOption[0]);
            return null;
        });
        this.verifyContents("dml");
    }

    private String getInsertStatementWithParameters() {
        String pgStatement = "INSERT INTO T (Key, Float32Value, Float32ArrayValue) VALUES ('param1', $1, $2), ('param2', $3, $4), ('param3', $5, $6), ('param4', $7, $8), ('param5', $9, $10)";
        return this.dialect.dialect == Dialect.POSTGRESQL ? pgStatement : pgStatement.replace("$", "@p");
    }

    @Test
    public void float32Parameter() {
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)this.getInsertStatementWithParameters()).bind("p1").to(Value.float32((float)3.14f))).bind("p2").to(Value.float32Array(Arrays.asList(Float.valueOf(1.1f))))).bind("p3").to(Value.float32((float)3.14f))).bind("p4").to(Value.float32Array((float[])new float[]{3.14f, 3.14f}))).bind("p5").to(Value.float32((float)Float.NaN))).bind("p6").to(Value.float32Array(Arrays.asList(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(3.14f), Float.valueOf(1.2f), Float.valueOf(Float.NEGATIVE_INFINITY))))).bind("p7").to(Value.float32((float)Float.MIN_NORMAL))).bind("p8").to(Value.float32Array(Arrays.asList(Float.valueOf(Float.MIN_NORMAL), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f))))).bind("p9").to(Value.float32(null))).bind("p10").to(Value.float32Array((float[])null))).build(), new Options.UpdateOption[0]);
            return null;
        });
        this.verifyContents("param");
    }

    private String getInsertStatementForUntypedParameters() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return "INSERT INTO T (key, float32value, float32arrayvalue) VALUES ('untyped1', ($1)::float4, ($2)::float4[])";
        }
        return "INSERT INTO T (Key, Float32Value, Float32ArrayValue) VALUES ('untyped1', CAST(@p1 AS FLOAT32), CAST(@p2 AS ARRAY<FLOAT32>))";
    }

    @Test
    public void float32UntypedParameter() {
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)this.getInsertStatementForUntypedParameters()).bind("p1").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setNumberValue((double)3.14f).build()))).bind("p2").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNumberValue(1.1754943508222875E-38))).build()))).build(), new Options.UpdateOption[0]);
            return null;
        });
        Struct row = this.readRow("T", "untyped1", "Float32Value", "Float32ArrayValue");
        Assert.assertFalse((boolean)row.isNull(0));
        Assert.assertEquals((float)3.14f, (float)row.getFloat(0), (float)1.0E-5f);
        Assert.assertFalse((boolean)row.isNull(1));
        Assert.assertEquals((long)1L, (long)row.getFloatList(1).size());
        Assert.assertEquals((float)Float.MIN_NORMAL, (float)((Float)row.getFloatList(1).get(0)).floatValue(), (float)1.0E-5f);
    }

    private void verifyContents(String keyPrefix) {
        try (ResultSet resultSet = client.singleUse().executeQuery(Statement.of((String)"SELECT Key AS key, Float32Value AS float32value, Float32ArrayValue AS float32arrayvalue FROM T WHERE Key LIKE '{keyPrefix}%' ORDER BY key".replace("{keyPrefix}", keyPrefix)), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((float)3.14f, (float)resultSet.getFloat("float32value"), (float)1.0E-5f);
            Assert.assertEquals((Object)Value.float32((float)3.14f), (Object)resultSet.getValue("float32value"));
            Assert.assertArrayEquals((float[])new float[]{1.1f}, (float[])resultSet.getFloatArray("float32arrayvalue"), (float)1.0E-5f);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((float)3.14f, (float)resultSet.getFloat("float32value"), (float)1.0E-5f);
            Assert.assertEquals(Arrays.asList(Float.valueOf(3.14f), Float.valueOf(3.14f)), (Object)resultSet.getFloatList("float32arrayvalue"));
            Assert.assertEquals((Object)Value.float32Array((float[])new float[]{3.14f, 3.14f}), (Object)resultSet.getValue("float32arrayvalue"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((boolean)Float.isNaN(resultSet.getFloat("float32value")));
            Assert.assertTrue((boolean)Float.isNaN(resultSet.getValue("float32value").getFloat32()));
            Assert.assertEquals(Arrays.asList(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(3.14f), Float.valueOf(1.2f), Float.valueOf(Float.NEGATIVE_INFINITY)), (Object)resultSet.getFloatList("float32arrayvalue"));
            Assert.assertEquals((Object)Value.float32Array(Arrays.asList(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(3.14f), Float.valueOf(1.2f), Float.valueOf(Float.NEGATIVE_INFINITY))), (Object)resultSet.getValue("float32arrayvalue"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((float)Float.MIN_NORMAL, (float)resultSet.getFloat("float32value"), (float)1.0E-5f);
            Assert.assertEquals((float)Float.MIN_NORMAL, (float)resultSet.getValue("float32value").getFloat32(), (float)1.0E-5f);
            Assert.assertEquals((long)3L, (long)resultSet.getFloatList("float32arrayvalue").size());
            Assert.assertEquals((double)1.1754943508222875E-38, (double)((Float)resultSet.getFloatList("float32arrayvalue").get(0)).floatValue(), (double)1.0E-5);
            Assert.assertEquals((float)Float.MAX_VALUE, (float)((Float)resultSet.getFloatList("float32arrayvalue").get(1)).floatValue(), (float)1.0E-5f);
            Assert.assertEquals((float)-3.4028235E38f, (float)((Float)resultSet.getFloatList("float32arrayvalue").get(2)).floatValue(), (float)1.0E-5f);
            Assert.assertEquals((long)3L, (long)resultSet.getValue("float32arrayvalue").getFloat32Array().size());
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((boolean)resultSet.isNull("float32value"));
            Assert.assertTrue((boolean)resultSet.isNull("float32arrayvalue"));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    static {
        GOOGLE_STANDARD_SQL_SCHEMA = new String[]{"CREATE TABLE T (  Key                 STRING(MAX) NOT NULL,  Float32Value        FLOAT32,  Float32ArrayValue   ARRAY<FLOAT32>,) PRIMARY KEY (Key)"};
        POSTGRESQL_SCHEMA = new String[]{"CREATE TABLE T (  Key                 VARCHAR PRIMARY KEY,  Float32Value        REAL,  Float32ArrayValue   REAL[])"};
    }
}

