/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITJsonWriteReadTest {
    private static final String RESOURCES_DIR = "com/google/cloud/spanner/it/";
    private static final String VALID_JSON_DIR = "valid";
    private static final String INVALID_JSON_DIR = "invalid";
    private static final String TABLE_NAME = "TestTable";
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseClient databaseClient;

    @BeforeClass
    public static void beforeClass() {
        RemoteSpannerHelper testHelper = env.getTestHelper();
        Database database = testHelper.createTestDatabase(new String[]{"CREATE TABLE TestTable(Id INT64 NOT NULL,json JSON) PRIMARY KEY (Id)"});
        databaseClient = testHelper.getDatabaseClient(database);
    }

    @Test
    public void testWriteValidJsonValues() throws IOException {
        List<String> resources = this.getJsonFilePaths(RESOURCES_DIR + File.separator + VALID_JSON_DIR);
        long id = 0L;
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (String resource : resources) {
            String jsonStr = Resources.toString((URL)Resources.getResource(this.getClass(), (String)(VALID_JSON_DIR + File.separator + resource)), (Charset)StandardCharsets.UTF_8);
            Mutation mutation = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(id++)).set("json").to(Value.json((String)jsonStr))).build();
            mutations.add(mutation);
        }
        databaseClient.write(mutations);
        try (ResultSet resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) FROM TestTable"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((long)resultSet.getLong(0), (long)resources.size());
        }
    }

    @Test
    public void testWriteAndReadInvalidJsonValues() throws IOException {
        List<String> resources = this.getJsonFilePaths(RESOURCES_DIR + File.separator + INVALID_JSON_DIR);
        AtomicLong id = new AtomicLong(100L);
        for (String resource : resources) {
            String jsonStr = Resources.toString((URL)Resources.getResource(this.getClass(), (String)(INVALID_JSON_DIR + File.separator + resource)), (Charset)StandardCharsets.UTF_8);
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(id.getAndIncrement())).set("json").to(Value.json((String)jsonStr))).build())));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
    }

    private List<String> getJsonFilePaths(String folder) throws IOException {
        String fixturesRoot = Resources.getResource((String)folder).getPath();
        Path fixturesRootPath = Paths.get(fixturesRoot, new String[0]);
        return Files.walk(fixturesRootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> fixturesRootPath.relativize((Path)path).toString()).filter(path -> path.endsWith(".json")).collect(Collectors.toList());
    }
}

