/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITLargeReadTest {
    private static int numRows;
    private static final int WRITE_BATCH_SIZE = 0x100000;
    private static final String TABLE_NAME = "TestTable";
    @ClassRule
    public static IntegrationTestEnv env;
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private static HashFunction hasher;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    private static List<Integer> rowSizes() {
        ArrayList<Integer> rowSizes = new ArrayList<Integer>();
        rowSizes.addAll(Collections.nCopies(1000, 4096));
        rowSizes.addAll(Collections.nCopies(100, 40960));
        rowSizes.addAll(Collections.nCopies(25, 409600));
        rowSizes.addAll(Collections.nCopies(10, 0x400000));
        Collections.shuffle(rowSizes);
        return rowSizes;
    }

    @BeforeClass
    public static void setUpDatabase() {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key           INT64 NOT NULL,  Data          BYTES(MAX),  Fingerprint   INT64,  Size          INT64,) PRIMARY KEY (Key)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, (Iterable)ImmutableList.of((Object)"CREATE TABLE TestTable (  Key           BIGINT PRIMARY KEY,  Data          BYTEA,  Fingerprint   BIGINT,  Size          BIGINT)"));
        postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        hasher = Hashing.goodFastHash((int)64);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        Random rnd = new Random();
        int totalSize = 0;
        int i = 0;
        for (int rowSize : ITLargeReadTest.rowSizes()) {
            ++numRows;
            byte[] data = new byte[rowSize];
            rnd.nextBytes(data);
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to((long)i)).set("Data").to(ByteArray.copyFrom((byte[])data))).set("Fingerprint").to(hasher.hashBytes(data).asLong())).set("Size").to((long)rowSize)).build());
            ++i;
            if ((totalSize += rowSize) < 0x100000) continue;
            googleStandardSQLClient.write(mutations);
            postgreSQLClient.write(mutations);
            mutations.clear();
            totalSize = 0;
        }
        googleStandardSQLClient.write(mutations);
        postgreSQLClient.write(mutations);
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        return params;
    }

    private DatabaseClient getClient(Dialect dialect) {
        if (dialect == Dialect.POSTGRESQL) {
            return postgreSQLClient;
        }
        return googleStandardSQLClient;
    }

    @Test
    public void read() {
        try (ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse().read(TABLE_NAME, KeySet.all(), Arrays.asList("Key", "Data", "Fingerprint", "Size"), new Options.ReadOption[0]);){
            this.validate(resultSet);
        }
    }

    @Test
    public void readWithSmallPrefetchChunks() {
        try (ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse().read(TABLE_NAME, KeySet.all(), Arrays.asList("Key", "Data", "Fingerprint", "Size"), new Options.ReadOption[]{Options.prefetchChunks((int)1)});){
            this.validate(resultSet);
        }
    }

    @Test
    public void query() {
        try (ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse().executeQuery(Statement.of((String)"SELECT Key, Data, Fingerprint, Size FROM TestTable ORDER BY Key"), new Options.QueryOption[0]);){
            this.validate(resultSet);
        }
    }

    @Test
    public void queryWithSmallPrefetchChunks() {
        try (ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse().executeQuery(Statement.of((String)"SELECT Key, Data, Fingerprint, Size FROM TestTable ORDER BY Key"), new Options.QueryOption[]{Options.prefetchChunks((int)1)});){
            this.validate(resultSet);
        }
    }

    private void validate(ResultSet resultSet) {
        int i = 0;
        while (resultSet.next()) {
            Truth.assertThat((Long)resultSet.getLong(0)).isEqualTo((Object)i);
            ByteArray data = resultSet.getBytes(1);
            Truth.assertThat((Integer)data.length()).isEqualTo((Object)resultSet.getLong(3));
            Truth.assertThat((Long)resultSet.getLong(2)).isEqualTo((Object)hasher.hashBytes(data.toByteArray()).asLong());
            Truth.assertThat((Integer)(++i)).isAtMost((Comparable)Integer.valueOf(numRows));
        }
        Truth.assertThat((Integer)i).isEqualTo((Object)numRows);
    }

    static {
        env = new IntegrationTestEnv();
    }
}

