/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITProtoColumnTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseId databaseID;
    private static DatabaseAdminClient dbAdminClient;
    private static DatabaseClient databaseClient;

    @BeforeClass
    public static void setUpDatabase() throws Exception {
        Assume.assumeFalse((String)"Proto Column is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        RemoteSpannerHelper testHelper = env.getTestHelper();
        databaseID = DatabaseId.of((InstanceId)testHelper.getInstanceId(), (String)testHelper.getUniqueDatabaseId());
        dbAdminClient = testHelper.getClient().getDatabaseAdminClient();
        ITProtoColumnTest.createDatabase();
        databaseClient = testHelper.getClient().getDatabaseClient(databaseID);
    }

    public static void createDatabase() throws Exception {
        InputStream in = ITProtoColumnTest.class.getClassLoader().getResourceAsStream("com/google/cloud/spanner/descriptors.pb");
        Database databaseToCreate = dbAdminClient.newDatabaseBuilder(databaseID).setProtoDescriptors(in).build();
        Database createdDatabase = (Database)dbAdminClient.createDatabase(databaseToCreate, Arrays.asList("CREATE PROTO BUNDLE (examples.spanner.music.SingerInfo,examples.spanner.music.Genre,)", "CREATE TABLE Singers (  SingerId   INT64 NOT NULL,  FirstName  STRING(1024),  LastName   STRING(1024),  SingerInfo examples.spanner.music.SingerInfo,  SingerGenre examples.spanner.music.Genre,  SingerNationality STRING(1024) AS (SingerInfo.nationality) STORED,  ) PRIMARY KEY (SingerNationality, SingerGenre)", "CREATE TABLE Types (  RowID INT64 NOT NULL,  Int64a INT64,  Bytes BYTES(MAX),  Int64Array ARRAY<INT64>,  BytesArray ARRAY<BYTES(MAX)>,  ProtoMessage    examples.spanner.music.SingerInfo,  ProtoEnum   examples.spanner.music.Genre,  ProtoMessageArray   ARRAY<examples.spanner.music.SingerInfo>,  ProtoEnumArray  ARRAY<examples.spanner.music.Genre>,  ) PRIMARY KEY (RowID)", "CREATE INDEX SingerByNationalityAndGenre ON Singers(SingerNationality, SingerGenre)  STORING (SingerId, FirstName, LastName)")).get(5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)databaseID.getDatabase(), (Object)createdDatabase.getId().getDatabase());
        GetDatabaseDdlResponse response = dbAdminClient.getDatabaseDdlResponse(databaseID.getInstanceId().getInstance(), databaseID.getDatabase());
        Assert.assertNotNull((Object)response.getProtoDescriptors());
        in.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        try {
            if (!EmulatorSpannerHelper.isUsingEmulator()) {
                dbAdminClient.dropDatabase(databaseID.getInstanceId().getInstance(), databaseID.getDatabase());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to drop database " + dbAdminClient.getDatabase(databaseID.getInstanceId().getInstance(), databaseID.getDatabase()).getId() + ", skipping...: " + e.getMessage());
        }
    }

    @After
    public void after() throws Exception {
        databaseClient.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"Types", (KeySet)KeySet.all())));
        databaseClient.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"Singers", (KeySet)KeySet.all())));
    }

    @Test
    public void testProtoColumnsUpdateAndRead() {
        Assume.assumeFalse((String)"Proto Column is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SingerProto.SingerInfo singerInfo = SingerProto.SingerInfo.newBuilder().setSingerId(1L).setNationality("Country1").build();
        ByteArray singerInfoBytes = ByteArray.copyFrom((byte[])singerInfo.toByteArray());
        SingerProto.Genre genre = SingerProto.Genre.JAZZ;
        long genreConst = genre.getNumber();
        List<AbstractMessage> singerInfoList = Arrays.asList(singerInfo, null, SingerProto.SingerInfo.getDefaultInstance());
        List<ByteArray> singerInfoBytesList = Arrays.asList(singerInfoBytes, null, ByteArray.copyFrom((byte[])SingerProto.SingerInfo.getDefaultInstance().toByteArray()));
        List<ProtocolMessageEnum> enumList = Arrays.asList(new ProtocolMessageEnum[]{SingerProto.Genre.FOLK, null, SingerProto.Genre.ROCK});
        List<Long> enumConstList = Arrays.asList(2L, null, 3L);
        databaseClient.write((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"Types").set("RowID").to(1L)).set("Int64a").to(genreConst)).set("Bytes").to(singerInfoBytes)).set("Int64Array").toInt64Array(enumConstList)).set("BytesArray").toBytesArray(singerInfoBytesList)).set("ProtoMessage").to((AbstractMessage)singerInfo)).set("ProtoEnum").to((ProtocolMessageEnum)genre)).set("ProtoMessageArray").toProtoMessageArray(singerInfoList, SingerProto.SingerInfo.getDescriptor())).set("ProtoEnumArray").toProtoEnumArray(enumList, SingerProto.Genre.getDescriptor())).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"Types").set("RowID").to(2L)).set("Int64a").to((ProtocolMessageEnum)genre)).set("Bytes").to((AbstractMessage)singerInfo)).set("Int64Array").toProtoEnumArray(enumList, SingerProto.Genre.getDescriptor())).set("BytesArray").toProtoMessageArray(singerInfoList, SingerProto.SingerInfo.getDescriptor())).set("ProtoMessage").to(singerInfoBytes)).set("ProtoEnum").to(genreConst)).set("ProtoMessageArray").toBytesArray(singerInfoBytesList)).set("ProtoEnumArray").toInt64Array(enumConstList)).build()));
        try (ResultSet resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM Types"), new Options.QueryOption[0]);){
            for (int i = 0; i < 2; ++i) {
                resultSet.next();
                Assert.assertEquals((long)(i + 1), (long)resultSet.getLong("RowID"));
                Assert.assertEquals((long)genreConst, (long)resultSet.getLong("Int64a"));
                Assert.assertEquals((Object)singerInfoBytes, (Object)resultSet.getBytes("Bytes"));
                Assert.assertEquals(enumConstList, (Object)resultSet.getLongList("Int64Array"));
                Assert.assertEquals(singerInfoBytesList, (Object)resultSet.getBytesList("BytesArray"));
                Assert.assertEquals((Object)singerInfo, (Object)resultSet.getProtoMessage("ProtoMessage", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
                Assert.assertEquals((Object)((Object)genre), (Object)resultSet.getProtoEnum("ProtoEnum", SingerProto.Genre::forNumber));
                Assert.assertEquals(singerInfoList, (Object)resultSet.getProtoMessageList("ProtoMessageArray", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
                Assert.assertEquals(enumList, (Object)resultSet.getProtoEnumList("ProtoEnumArray", SingerProto.Genre::forNumber));
                Assert.assertEquals((Object)singerInfoBytes, (Object)resultSet.getBytes("ProtoMessage"));
                Assert.assertEquals((Object)singerInfo, (Object)resultSet.getProtoMessage("Bytes", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
                Assert.assertEquals(singerInfoBytesList, (Object)resultSet.getBytesList("ProtoMessageArray"));
                Assert.assertEquals(singerInfoList, (Object)resultSet.getProtoMessageList("BytesArray", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
                Assert.assertEquals((long)genreConst, (long)resultSet.getLong("ProtoEnum"));
                Assert.assertEquals((Object)((Object)genre), (Object)resultSet.getProtoEnum("Int64a", SingerProto.Genre::forNumber));
                Assert.assertEquals(enumConstList, (Object)resultSet.getLongList("ProtoEnumArray"));
                Assert.assertEquals(enumList, (Object)resultSet.getProtoEnumList("Int64Array", SingerProto.Genre::forNumber));
            }
        }
    }

    @Test
    public void testProtoColumnsDMLParameterizedQueriesPKAndIndexes() {
        Assume.assumeFalse((String)"Proto Column is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SingerProto.SingerInfo singerInfo1 = SingerProto.SingerInfo.newBuilder().setSingerId(1L).setNationality("Country1").build();
        SingerProto.Genre genre1 = SingerProto.Genre.FOLK;
        SingerProto.SingerInfo singerInfo2 = SingerProto.SingerInfo.newBuilder().setSingerId(2L).setNationality("Country2").build();
        SingerProto.Genre genre2 = SingerProto.Genre.JAZZ;
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            Statement statement1 = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO Singers (SingerId, FirstName, LastName, SingerInfo, SingerGenre) VALUES (1, \"FirstName1\", \"LastName1\", @singerInfo, @singerGenre)").bind("singerInfo").to((AbstractMessage)singerInfo1)).bind("singerGenre").to((ProtocolMessageEnum)genre1)).build();
            Statement statement2 = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO Singers (SingerId, FirstName, LastName, SingerInfo, SingerGenre) VALUES (2, \"FirstName2\", \"LastName2\", @singerInfo, @singerGenre)").bind("singerInfo").to((AbstractMessage)singerInfo2)).bind("singerGenre").to((ProtocolMessageEnum)genre2)).build();
            transaction.batchUpdate(Arrays.asList(statement1, statement2), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet1 = databaseClient.singleUse().read("Singers", KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"Country1", SingerProto.Genre.FOLK})).addKey(Key.of((Object[])new Object[]{"Country2", SingerProto.Genre.JAZZ})).build(), Arrays.asList("SingerId", "FirstName", "LastName", "SingerInfo", "SingerGenre"), new Options.ReadOption[0]);){
            resultSet1.next();
            Assert.assertEquals((long)1L, (long)resultSet1.getLong("SingerId"));
            Assert.assertEquals((Object)"FirstName1", (Object)resultSet1.getString("FirstName"));
            Assert.assertEquals((Object)"LastName1", (Object)resultSet1.getString("LastName"));
            Assert.assertEquals((Object)singerInfo1, (Object)resultSet1.getProtoMessage("SingerInfo", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
            Assert.assertEquals((Object)((Object)genre1), (Object)resultSet1.getProtoEnum("SingerGenre", SingerProto.Genre::forNumber));
            resultSet1.next();
            Assert.assertEquals((long)2L, (long)resultSet1.getLong("SingerId"));
            Assert.assertEquals((Object)"FirstName2", (Object)resultSet1.getString("FirstName"));
            Assert.assertEquals((Object)"LastName2", (Object)resultSet1.getString("LastName"));
            Assert.assertEquals((Object)singerInfo2, (Object)resultSet1.getProtoMessage("SingerInfo", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
            Assert.assertEquals((Object)((Object)genre2), (Object)resultSet1.getProtoEnum("SingerGenre", SingerProto.Genre::forNumber));
        }
        try (ResultSet resultSet2 = databaseClient.singleUse().readUsingIndex("Singers", "SingerByNationalityAndGenre", KeySet.singleKey((Key)Key.of((Object[])new Object[]{"Country2", SingerProto.Genre.JAZZ})), Arrays.asList("SingerId", "FirstName", "LastName"), new Options.ReadOption[0]);){
            resultSet2.next();
            Assert.assertEquals((long)2L, (long)resultSet2.getLong("SingerId"));
            Assert.assertEquals((Object)"FirstName2", (Object)resultSet2.getString("FirstName"));
            Assert.assertEquals((Object)"LastName2", (Object)resultSet2.getString("LastName"));
        }
        try (ResultSet resultSet3 = databaseClient.singleUse().executeQuery(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT SingerId, SingerInfo, SingerGenre FROM Singers WHERE SingerInfo.Nationality=@country AND SingerGenre=@genre").bind("country").to("Country2")).bind("genre").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).build(), new Options.QueryOption[0]);){
            resultSet3.next();
            Assert.assertEquals((long)2L, (long)resultSet3.getLong("SingerId"));
            Assert.assertEquals((Object)singerInfo2, (Object)resultSet3.getProtoMessage("SingerInfo", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance()));
            Assert.assertEquals((Object)((Object)genre2), (Object)resultSet3.getProtoEnum("SingerGenre", SingerProto.Genre::forNumber));
        }
    }

    @Test
    public void testProtoMessageDeserializationError() {
        Assume.assumeFalse((String)"Proto Column is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SingerProto.SingerInfo singerInfo = SingerProto.SingerInfo.newBuilder().setSingerId(1L).setNationality("Country1").build();
        databaseClient.write((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"Types").set("RowID").to(1L)).set("ProtoMessage").to((AbstractMessage)singerInfo)).build()));
        try (ResultSet resultSet = databaseClient.singleUse().read("Types", KeySet.all(), Collections.singletonList("ProtoMessage"), new Options.ReadOption[0]);){
            resultSet.next();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> resultSet.getProtoMessage("ProtoMessage", (AbstractMessage)Backup.getDefaultInstance()));
            Assert.assertEquals(InvalidProtocolBufferException.InvalidWireTypeException.class, e.getCause().getClass());
        }
    }
}

