/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import com.google.spanner.v1.DirectedReadOptions;
import io.grpc.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITReadTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static final String INDEX_NAME = "TestTableByValue";
    private static final String DESC_INDEX_NAME = "TestTableByValueDesc";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static final Type TABLE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"key", (Type)Type.string()), Type.StructField.of((String)"stringvalue", (Type)Type.string())});
    private static DirectedReadOptions DIRECTED_READ_OPTIONS = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-west1").setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).build()).setAutoFailoverDisabled(true)).build();
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    @BeforeClass
    public static void setUpDatabase() {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  key                STRING(MAX) NOT NULL,  stringvalue        STRING(MAX),) PRIMARY KEY (key)", "CREATE INDEX TestTableByValue ON TestTable(stringvalue)", "CREATE INDEX TestTableByValueDesc ON TestTable(stringvalue DESC)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Arrays.asList("CREATE TABLE TestTable (  Key                VARCHAR PRIMARY KEY,  StringValue        VARCHAR)", "CREATE INDEX TestTableByValue ON TestTable(StringValue)", "CREATE INDEX TestTableByValueDesc ON TestTable(StringValue DESC)"));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 15; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("key").to("k" + i)).set("stringvalue").to("v" + i)).build());
        }
        googleStandardSQLClient.write(mutations);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            postgreSQLClient.write(mutations);
        }
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    private DatabaseClient getClient(Dialect dialect) {
        if (dialect == Dialect.POSTGRESQL) {
            return postgreSQLClient;
        }
        return googleStandardSQLClient;
    }

    @Test
    public void emptyRead() {
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read(TABLE_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)TABLE_TYPE);
    }

    @Test
    public void indexEmptyRead() {
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)TABLE_TYPE);
    }

    @Test
    public void pointRead() {
        Struct row = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v1");
        Truth.assertThat((Object)row).isEqualTo((Object)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("key").to("k1")).set("stringvalue").to("v1")).build());
    }

    @Test
    public void indexPointRead() {
        Struct row = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRowUsingIndex(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v1");
    }

    @Test
    public void pointReadNotFound() {
        Struct row = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void indexPointReadNotFound() {
        Struct row = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRowUsingIndex(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void rangeReads() {
        this.checkRange(Source.BASE_TABLE, KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"})), 1);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 3, 4);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 3, 4, 5);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 4, 5);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 4);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), 7, 8, 9);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), 8, 9);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), 0, 1, 10);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), 0, 1, 10, 11);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.prefix((Key)Key.of((Object[])new Object[]{"k1"})), 1);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k1"}), (Key)Key.of((Object[])new Object[]{"k2"})), 1, 10, 11, 12, 13, 14);
        this.checkRange(Source.BASE_TABLE, KeySet.all(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
    }

    @Test
    public void limitRead() {
        this.checkRangeWithLimit(Source.BASE_TABLE, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k7"})), 3, 4);
        this.checkRangeWithLimit(Source.BASE_TABLE, 0L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k7"})), 3, 4, 5, 6, 7);
    }

    @Test
    public void indexRangeReads() {
        this.checkRange(Source.INDEX, KeySet.singleKey((Key)Key.of((Object[])new Object[]{"v1"})), 1);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 3, 4);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 3, 4, 5);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 4, 5);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 4);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), 7, 8, 9);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), 8, 9);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), 0, 1, 10);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), 0, 1, 10, 11);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.prefix((Key)Key.of((Object[])new Object[]{"v1"})), 1);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v1"}), (Key)Key.of((Object[])new Object[]{"v2"})), 1, 10, 11, 12, 13, 14);
        this.checkRange(Source.INDEX, KeySet.all(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.checkRange(Source.DESC_INDEX, KeySet.all(), 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0);
    }

    @Test
    public void limitReadUsingIndex() {
        this.checkRangeWithLimit(Source.INDEX, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v7"})), 3, 4);
        this.checkRangeWithLimit(Source.DESC_INDEX, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[]{"v3"})), 7, 6);
    }

    @Test
    public void multiPointRead() {
        KeySet keys = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"k3"})).addKey(Key.of((Object[])new Object[]{"k5"})).addKey(Key.of((Object[])new Object[]{"k7"})).build();
        this.checkRange(Source.BASE_TABLE, keys, 3, 5, 7);
    }

    @Test
    public void indexMultiPointRead() {
        KeySet keys = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"v3"})).addKey(Key.of((Object[])new Object[]{"v5"})).addKey(Key.of((Object[])new Object[]{"v7"})).build();
        this.checkRange(Source.INDEX, keys, 3, 5, 7);
    }

    @Test
    public void rowsAreSnapshots() {
        ArrayList<Struct> rows = new ArrayList<Struct>();
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read(TABLE_NAME, KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"k2"})).addKey(Key.of((Object[])new Object[]{"k3"})).addKey(Key.of((Object[])new Object[]{"k4"})).build(), ALL_COLUMNS, new Options.ReadOption[0]);
        while (resultSet.next()) {
            rows.add(resultSet.getCurrentRowAsStruct());
        }
        Truth.assertThat((Integer)rows.size()).isEqualTo((Object)3);
        Truth.assertThat((String)((Struct)rows.get(0)).getString(0)).isEqualTo((Object)"k2");
        Truth.assertThat((String)((Struct)rows.get(0)).getString(1)).isEqualTo((Object)"v2");
        Truth.assertThat((String)((Struct)rows.get(1)).getString(0)).isEqualTo((Object)"k3");
        Truth.assertThat((String)((Struct)rows.get(1)).getString(1)).isEqualTo((Object)"v3");
        Truth.assertThat((String)((Struct)rows.get(2)).getString(0)).isEqualTo((Object)"k4");
        Truth.assertThat((String)((Struct)rows.get(2)).getString(1)).isEqualTo((Object)"v4");
    }

    @Test
    public void pointReadWithDirectedReadOptions() {
        try (ResultSet rs = this.getClient(this.dialect.dialect).singleUse().read(TABLE_NAME, KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"})), ALL_COLUMNS, new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k1", (Object)rs.getString(0));
            Assert.assertEquals((Object)"v1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void invalidDatabase() {
        RemoteSpannerHelper helper = env.getTestHelper();
        DatabaseClient invalidClient = helper.getClient().getDatabaseClient(DatabaseId.of((InstanceId)helper.getInstanceId(), (String)"invalid"));
        try {
            invalidClient.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k99"}), ALL_COLUMNS);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void tableNotFound() {
        try {
            this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow("BadTableName", Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"BadTableName");
        }
    }

    @Test
    public void columnNotFound() {
        try {
            this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), Arrays.asList("Key", "BadColumnName"));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"BadColumnName");
        }
    }

    @Test
    public void cursorErrorDeferred() {
        ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read("BadTableName", KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"})), ALL_COLUMNS, new Options.ReadOption[0]);
        try {
            resultSet.next();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"BadTableName");
        }
    }

    @Test
    public void cancellation() {
        Context.CancellableContext context = Context.current().withCancellation();
        Runnable work = context.wrap(() -> this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS));
        context.cancel((Throwable)new RuntimeException("Cancelled by test"));
        try {
            work.run();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.CANCELLED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deadline() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Context.CancellableContext context = Context.current().withDeadlineAfter(10L, TimeUnit.NANOSECONDS, executor);
        Runnable work = context.wrap(() -> this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS));
        try {
            work.run();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        finally {
            executor.shutdown();
        }
    }

    private void checkReadRange(Source source, KeySet keySet, long limit, int[] expectedRows) {
        ResultSet resultSet;
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        for (int expectedRow : expectedRows) {
            expected.put("k" + expectedRow, "v" + expectedRow);
        }
        switch (source) {
            case INDEX: {
                resultSet = limit != 0L ? this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            case DESC_INDEX: {
                resultSet = limit != 0L ? this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, DESC_INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, DESC_INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            case BASE_TABLE: {
                resultSet = limit != 0L ? this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read(TABLE_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()).read(TABLE_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid source");
            }
        }
        LinkedHashMap<String, String> rows = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            rows.put(resultSet.getString(0), resultSet.getString(1));
        }
        Truth.assertWithMessage((String)("read of " + keySet)).that(rows).isEqualTo(expected);
    }

    private void checkRange(Source source, KeyRange range, int ... expectedRows) {
        this.checkRange(source, KeySet.range((KeyRange)range), expectedRows);
    }

    private void checkRange(Source source, KeySet keySet, int ... expectedRows) {
        this.checkReadRange(source, keySet, 0L, expectedRows);
    }

    private void checkRangeWithLimit(Source source, long limit, KeyRange range, int ... expectedRows) {
        this.checkReadRange(source, KeySet.range((KeyRange)range), limit, expectedRows);
    }

    private static enum Source {
        BASE_TABLE,
        INDEX,
        DESC_INDEX;

    }
}

