/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITWithGrpcGcpTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static RemoteSpannerHelper testHelper;
    private static Database db;
    private static DatabaseClient client;

    @BeforeClass
    public static void setUpDatabase() {
        SpannerOptions.Builder builder = env.getTestHelper().getOptions().toBuilder();
        builder.enableGrpcGcpExtension();
        testHelper = RemoteSpannerHelper.create((SpannerOptions)builder.build(), (InstanceId)env.getTestHelper().getInstanceId());
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)"});
        client = testHelper.getDatabaseClient(db);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 3; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        client.write(mutations);
    }

    @Test
    public void singleRead() {
        Struct row = client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v1");
    }

    @Test
    public void usingTransaction() {
        Long updatedCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(Statement.of((String)"UPDATE TestTable SET StringValue='v2upd' WHERE Key='k2'"), new Options.UpdateOption[0]));
        Truth.assertThat((Long)updatedCount).isEqualTo((Object)1L);
        Struct row = client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k2"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k2");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v2upd");
    }
}

