/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import java.util.concurrent.ExecutionException;

class DelayedTransactionManager
implements TransactionManager {
    private final ApiFuture<TransactionManager> transactionManagerFuture;

    DelayedTransactionManager(ApiFuture<TransactionManager> transactionManagerFuture) {
        this.transactionManagerFuture = transactionManagerFuture;
    }

    TransactionManager getTransactionManager() {
        try {
            return (TransactionManager)this.transactionManagerFuture.get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.causeAsRunTimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    @Override
    public TransactionContext begin() {
        return this.getTransactionManager().begin();
    }

    @Override
    public void commit() {
        this.getTransactionManager().commit();
    }

    @Override
    public void rollback() {
        this.getTransactionManager().rollback();
    }

    @Override
    public TransactionContext resetForRetry() {
        return this.getTransactionManager().resetForRetry();
    }

    @Override
    public Timestamp getCommitTimestamp() {
        return this.getTransactionManager().getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        return this.getTransactionManager().getCommitResponse();
    }

    @Override
    public TransactionManager.TransactionState getState() {
        return this.getTransactionManager().getState();
    }

    @Override
    public void close() {
        this.getTransactionManager().close();
    }
}

