/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DecodeMode;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;

public final class Options
implements Serializable {
    private static final long serialVersionUID = 8067099123096783941L;
    static final CommitStatsOption COMMIT_STATS_OPTION = new CommitStatsOption();
    static final OptimisticLockOption OPTIMISTIC_LOCK_OPTION = new OptimisticLockOption();
    static final ExcludeTxnFromChangeStreamsOption EXCLUDE_TXN_FROM_CHANGE_STREAMS_OPTION = new ExcludeTxnFromChangeStreamsOption();
    private boolean withCommitStats;
    private Duration maxCommitDelay;
    private Long limit;
    private Integer prefetchChunks;
    private Integer bufferRows;
    private Integer pageSize;
    private String pageToken;
    private String filter;
    private RpcPriority priority;
    private String tag;
    private String etag;
    private Boolean validateOnly;
    private Boolean withOptimisticLock;
    private Boolean withExcludeTxnFromChangeStreams;
    private Boolean dataBoostEnabled;
    private DirectedReadOptions directedReadOptions;
    private DecodeMode decodeMode;
    private RpcOrderBy orderBy;
    private RpcLockHint lockHint;

    public static TransactionOption commitStats() {
        return COMMIT_STATS_OPTION;
    }

    public static TransactionOption optimisticLock() {
        return OPTIMISTIC_LOCK_OPTION;
    }

    public static UpdateTransactionOption excludeTxnFromChangeStreams() {
        return EXCLUDE_TXN_FROM_CHANGE_STREAMS_OPTION;
    }

    public static ReadOption limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit should be greater than 0");
        return new LimitOption(limit);
    }

    public static ReadOption orderBy(RpcOrderBy orderBy) {
        return new OrderByOption(orderBy);
    }

    public static ReadOption lockHint(RpcLockHint orderBy) {
        return new LockHintOption(orderBy);
    }

    public static ReadAndQueryOption prefetchChunks(int prefetchChunks) {
        Preconditions.checkArgument((prefetchChunks > 0 ? 1 : 0) != 0, (Object)"prefetchChunks should be greater than 0");
        return new FlowControlOption(prefetchChunks);
    }

    public static ReadAndQueryOption bufferRows(int bufferRows) {
        Preconditions.checkArgument((bufferRows > 0 ? 1 : 0) != 0, (Object)"bufferRows should be greater than 0");
        return new BufferRowsOption(bufferRows);
    }

    public static ReadQueryUpdateTransactionOption priority(RpcPriority priority) {
        return new PriorityOption(priority);
    }

    public static TransactionOption maxCommitDelay(Duration maxCommitDelay) {
        Preconditions.checkArgument((!maxCommitDelay.isNegative() ? 1 : 0) != 0, (Object)"maxCommitDelay should be positive");
        return new MaxCommitDelayOption(maxCommitDelay);
    }

    public static ReadQueryUpdateTransactionOption tag(String name) {
        return new TagOption(name);
    }

    public static ListOption pageSize(int pageSize) {
        return new PageSizeOption(pageSize);
    }

    public static DataBoostQueryOption dataBoostEnabled(Boolean dataBoostEnabled) {
        return new DataBoostQueryOption(dataBoostEnabled);
    }

    public static ListOption pageToken(String pageToken) {
        return new PageTokenOption(pageToken);
    }

    public static ListOption filter(String filter) {
        return new FilterOption(filter);
    }

    public static DeleteAdminApiOption etag(String etag) {
        return new EtagOption(etag);
    }

    public static CreateUpdateDeleteAdminApiOption validateOnly(Boolean validateOnly) {
        return new ValidateOnlyOption(validateOnly);
    }

    public static ReadAndQueryOption directedRead(DirectedReadOptions directedReadOptions) {
        return new DirectedReadOption(directedReadOptions);
    }

    public static ReadAndQueryOption decodeMode(DecodeMode decodeMode) {
        return new DecodeOption(decodeMode);
    }

    private Options() {
    }

    boolean withCommitStats() {
        return this.withCommitStats;
    }

    boolean hasMaxCommitDelay() {
        return this.maxCommitDelay != null;
    }

    Duration maxCommitDelay() {
        return this.maxCommitDelay;
    }

    boolean hasLimit() {
        return this.limit != null;
    }

    long limit() {
        return this.limit;
    }

    boolean hasPrefetchChunks() {
        return this.prefetchChunks != null;
    }

    int prefetchChunks() {
        return this.prefetchChunks;
    }

    boolean hasBufferRows() {
        return this.bufferRows != null;
    }

    int bufferRows() {
        return this.bufferRows;
    }

    boolean hasPageSize() {
        return this.pageSize != null;
    }

    int pageSize() {
        return this.pageSize;
    }

    boolean hasPageToken() {
        return this.pageToken != null;
    }

    String pageToken() {
        return this.pageToken;
    }

    boolean hasFilter() {
        return this.filter != null;
    }

    String filter() {
        return this.filter;
    }

    boolean hasPriority() {
        return this.priority != null;
    }

    RequestOptions.Priority priority() {
        return this.priority == null ? null : this.priority.proto;
    }

    boolean hasTag() {
        return this.tag != null;
    }

    String tag() {
        return this.tag;
    }

    boolean hasEtag() {
        return this.etag != null;
    }

    String etag() {
        return this.etag;
    }

    boolean hasValidateOnly() {
        return this.validateOnly != null;
    }

    Boolean validateOnly() {
        return this.validateOnly;
    }

    Boolean withOptimisticLock() {
        return this.withOptimisticLock;
    }

    Boolean withExcludeTxnFromChangeStreams() {
        return this.withExcludeTxnFromChangeStreams;
    }

    boolean hasDataBoostEnabled() {
        return this.dataBoostEnabled != null;
    }

    Boolean dataBoostEnabled() {
        return this.dataBoostEnabled;
    }

    boolean hasDirectedReadOptions() {
        return this.directedReadOptions != null;
    }

    DirectedReadOptions directedReadOptions() {
        return this.directedReadOptions;
    }

    boolean hasDecodeMode() {
        return this.decodeMode != null;
    }

    DecodeMode decodeMode() {
        return this.decodeMode;
    }

    boolean hasOrderBy() {
        return this.orderBy != null;
    }

    ReadRequest.OrderBy orderBy() {
        return this.orderBy == null ? null : this.orderBy.proto;
    }

    boolean hasLockHint() {
        return this.lockHint != null;
    }

    ReadRequest.LockHint lockHint() {
        return this.lockHint == null ? null : this.lockHint.proto;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.withCommitStats) {
            b.append("withCommitStats: ").append(this.withCommitStats).append(' ');
        }
        if (this.maxCommitDelay != null) {
            b.append("maxCommitDelay: ").append(this.maxCommitDelay).append(' ');
        }
        if (this.limit != null) {
            b.append("limit: ").append(this.limit).append(' ');
        }
        if (this.prefetchChunks != null) {
            b.append("prefetchChunks: ").append(this.prefetchChunks).append(' ');
        }
        if (this.pageSize != null) {
            b.append("pageSize: ").append(this.pageSize).append(' ');
        }
        if (this.pageToken != null) {
            b.append("pageToken: ").append(this.pageToken).append(' ');
        }
        if (this.filter != null) {
            b.append("filter: ").append(this.filter).append(' ');
        }
        if (this.priority != null) {
            b.append("priority: ").append((Object)this.priority).append(' ');
        }
        if (this.tag != null) {
            b.append("tag: ").append(this.tag).append(' ');
        }
        if (this.etag != null) {
            b.append("etag: ").append(this.etag).append(' ');
        }
        if (this.validateOnly != null) {
            b.append("validateOnly: ").append(this.validateOnly).append(' ');
        }
        if (this.withOptimisticLock != null) {
            b.append("withOptimisticLock: ").append(this.withOptimisticLock).append(' ');
        }
        if (this.withExcludeTxnFromChangeStreams != null) {
            b.append("withExcludeTxnFromChangeStreams: ").append(this.withExcludeTxnFromChangeStreams).append(' ');
        }
        if (this.dataBoostEnabled != null) {
            b.append("dataBoostEnabled: ").append(this.dataBoostEnabled).append(' ');
        }
        if (this.directedReadOptions != null) {
            b.append("directedReadOptions: ").append(this.directedReadOptions).append(' ');
        }
        if (this.decodeMode != null) {
            b.append("decodeMode: ").append((Object)this.decodeMode).append(' ');
        }
        if (this.orderBy != null) {
            b.append("orderBy: ").append((Object)this.orderBy).append(' ');
        }
        if (this.lockHint != null) {
            b.append("lockHint: ").append((Object)this.lockHint).append(' ');
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options that = (Options)o;
        return Objects.equals(this.withCommitStats, that.withCommitStats) && Objects.equals(this.maxCommitDelay, that.maxCommitDelay) && (!this.hasLimit() && !that.hasLimit() || this.hasLimit() && that.hasLimit() && Objects.equals(this.limit(), that.limit())) && (!this.hasPrefetchChunks() && !that.hasPrefetchChunks() || this.hasPrefetchChunks() && that.hasPrefetchChunks() && Objects.equals(this.prefetchChunks(), that.prefetchChunks())) && (!this.hasBufferRows() && !that.hasBufferRows() || this.hasBufferRows() && that.hasBufferRows() && Objects.equals(this.bufferRows(), that.bufferRows())) && (!this.hasPageSize() && !that.hasPageSize() || this.hasPageSize() && that.hasPageSize() && Objects.equals(this.pageSize(), that.pageSize())) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.filter(), that.filter()) && Objects.equals(this.priority(), that.priority()) && Objects.equals(this.tag(), that.tag()) && Objects.equals(this.etag(), that.etag()) && Objects.equals(this.validateOnly(), that.validateOnly()) && Objects.equals(this.withOptimisticLock(), that.withOptimisticLock()) && Objects.equals(this.withExcludeTxnFromChangeStreams(), that.withExcludeTxnFromChangeStreams()) && Objects.equals(this.dataBoostEnabled(), that.dataBoostEnabled()) && Objects.equals(this.directedReadOptions(), that.directedReadOptions()) && Objects.equals(this.orderBy(), that.orderBy()) && Objects.equals(this.lockHint(), that.lockHint());
    }

    public int hashCode() {
        int result = 31;
        if (this.withCommitStats) {
            result = 31 * result + 1231;
        }
        if (this.maxCommitDelay != null) {
            result = 31 * result + this.maxCommitDelay.hashCode();
        }
        if (this.limit != null) {
            result = 31 * result + this.limit.hashCode();
        }
        if (this.prefetchChunks != null) {
            result = 31 * result + this.prefetchChunks.hashCode();
        }
        if (this.bufferRows != null) {
            result = 31 * result + this.bufferRows.hashCode();
        }
        if (this.pageSize != null) {
            result = 31 * result + this.pageSize.hashCode();
        }
        if (this.pageToken != null) {
            result = 31 * result + this.pageToken.hashCode();
        }
        if (this.filter != null) {
            result = 31 * result + this.filter.hashCode();
        }
        if (this.priority != null) {
            result = 31 * result + this.priority.hashCode();
        }
        if (this.tag != null) {
            result = 31 * result + this.tag.hashCode();
        }
        if (this.etag != null) {
            result = 31 * result + this.etag.hashCode();
        }
        if (this.validateOnly != null) {
            result = 31 * result + this.validateOnly.hashCode();
        }
        if (this.withOptimisticLock != null) {
            result = 31 * result + this.withOptimisticLock.hashCode();
        }
        if (this.withExcludeTxnFromChangeStreams != null) {
            result = 31 * result + this.withExcludeTxnFromChangeStreams.hashCode();
        }
        if (this.dataBoostEnabled != null) {
            result = 31 * result + this.dataBoostEnabled.hashCode();
        }
        if (this.directedReadOptions != null) {
            result = 31 * result + this.directedReadOptions.hashCode();
        }
        if (this.decodeMode != null) {
            result = 31 * result + this.decodeMode.hashCode();
        }
        if (this.orderBy != null) {
            result = 31 * result + this.orderBy.hashCode();
        }
        if (this.lockHint != null) {
            result = 31 * result + this.lockHint.hashCode();
        }
        return result;
    }

    static Options fromReadOptions(ReadOption ... options) {
        Options readOptions = new Options();
        for (ReadOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromQueryOptions(QueryOption ... options) {
        Options readOptions = new Options();
        for (QueryOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromUpdateOptions(UpdateOption ... options) {
        Options updateOptions = new Options();
        for (UpdateOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(updateOptions);
        }
        return updateOptions;
    }

    static Options fromTransactionOptions(TransactionOption ... options) {
        Options transactionOptions = new Options();
        for (TransactionOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(transactionOptions);
        }
        return transactionOptions;
    }

    static Options fromListOptions(ListOption ... options) {
        Options listOptions = new Options();
        for (ListOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(listOptions);
        }
        return listOptions;
    }

    static Options fromAdminApiOptions(AdminApiOption ... options) {
        Options adminApiOptions = new Options();
        for (AdminApiOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(adminApiOptions);
        }
        return adminApiOptions;
    }

    public static enum RpcLockHint {
        UNSPECIFIED(ReadRequest.LockHint.LOCK_HINT_UNSPECIFIED),
        SHARED(ReadRequest.LockHint.LOCK_HINT_SHARED),
        EXCLUSIVE(ReadRequest.LockHint.LOCK_HINT_EXCLUSIVE);

        private final ReadRequest.LockHint proto;

        private RpcLockHint(ReadRequest.LockHint proto) {
            this.proto = (ReadRequest.LockHint)Preconditions.checkNotNull((Object)proto);
        }

        public static RpcLockHint fromProto(ReadRequest.LockHint proto) {
            for (RpcLockHint e : RpcLockHint.values()) {
                if (!e.proto.equals((Object)proto)) continue;
                return e;
            }
            return UNSPECIFIED;
        }
    }

    public static enum RpcOrderBy {
        PRIMARY_KEY(ReadRequest.OrderBy.ORDER_BY_PRIMARY_KEY),
        NO_ORDER(ReadRequest.OrderBy.ORDER_BY_NO_ORDER),
        UNSPECIFIED(ReadRequest.OrderBy.ORDER_BY_UNSPECIFIED);

        private final ReadRequest.OrderBy proto;

        private RpcOrderBy(ReadRequest.OrderBy proto) {
            this.proto = (ReadRequest.OrderBy)Preconditions.checkNotNull((Object)proto);
        }

        public static RpcOrderBy fromProto(ReadRequest.OrderBy proto) {
            for (RpcOrderBy e : RpcOrderBy.values()) {
                if (!e.proto.equals((Object)proto)) continue;
                return e;
            }
            return UNSPECIFIED;
        }
    }

    public static enum RpcPriority {
        LOW(RequestOptions.Priority.PRIORITY_LOW),
        MEDIUM(RequestOptions.Priority.PRIORITY_MEDIUM),
        HIGH(RequestOptions.Priority.PRIORITY_HIGH),
        UNSPECIFIED(RequestOptions.Priority.PRIORITY_UNSPECIFIED);

        private final RequestOptions.Priority proto;

        private RpcPriority(RequestOptions.Priority proto) {
            this.proto = (RequestOptions.Priority)Preconditions.checkNotNull((Object)proto);
        }

        public static RpcPriority fromProto(RequestOptions.Priority proto) {
            for (RpcPriority e : RpcPriority.values()) {
                if (!e.proto.equals((Object)proto)) continue;
                return e;
            }
            return UNSPECIFIED;
        }
    }

    static final class CommitStatsOption
    extends InternalOption
    implements TransactionOption {
        CommitStatsOption() {
        }

        @Override
        void appendToOptions(Options options) {
            options.withCommitStats = true;
        }
    }

    static final class OptimisticLockOption
    extends InternalOption
    implements TransactionOption {
        OptimisticLockOption() {
        }

        @Override
        void appendToOptions(Options options) {
            options.withOptimisticLock = true;
        }
    }

    static final class ExcludeTxnFromChangeStreamsOption
    extends InternalOption
    implements UpdateTransactionOption {
        ExcludeTxnFromChangeStreamsOption() {
        }

        @Override
        void appendToOptions(Options options) {
            options.withExcludeTxnFromChangeStreams = true;
        }
    }

    static class LimitOption
    extends InternalOption
    implements ReadOption {
        private final long limit;

        LimitOption(long limit) {
            this.limit = limit;
        }

        @Override
        void appendToOptions(Options options) {
            options.limit = this.limit;
        }
    }

    static class OrderByOption
    extends InternalOption
    implements ReadOption {
        private final RpcOrderBy orderBy;

        OrderByOption(RpcOrderBy orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        void appendToOptions(Options options) {
            options.orderBy = this.orderBy;
        }
    }

    static class LockHintOption
    extends InternalOption
    implements ReadOption {
        private final RpcLockHint lockHint;

        LockHintOption(RpcLockHint lockHint) {
            this.lockHint = lockHint;
        }

        @Override
        void appendToOptions(Options options) {
            options.lockHint = this.lockHint;
        }
    }

    static final class FlowControlOption
    extends InternalOption
    implements ReadAndQueryOption {
        final int prefetchChunks;

        FlowControlOption(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
        }

        @Override
        void appendToOptions(Options options) {
            options.prefetchChunks = this.prefetchChunks;
        }
    }

    static final class BufferRowsOption
    extends InternalOption
    implements ReadAndQueryOption {
        final int bufferRows;

        BufferRowsOption(int bufferRows) {
            this.bufferRows = bufferRows;
        }

        @Override
        void appendToOptions(Options options) {
            options.bufferRows = this.bufferRows;
        }
    }

    static final class PriorityOption
    extends InternalOption
    implements ReadQueryUpdateTransactionOption {
        private final RpcPriority priority;

        PriorityOption(RpcPriority priority) {
            this.priority = priority;
        }

        @Override
        void appendToOptions(Options options) {
            options.priority = this.priority;
        }
    }

    static final class MaxCommitDelayOption
    extends InternalOption
    implements TransactionOption {
        final Duration maxCommitDelay;

        MaxCommitDelayOption(Duration maxCommitDelay) {
            this.maxCommitDelay = maxCommitDelay;
        }

        @Override
        void appendToOptions(Options options) {
            options.maxCommitDelay = this.maxCommitDelay;
        }
    }

    static final class TagOption
    extends InternalOption
    implements ReadQueryUpdateTransactionOption {
        private final String tag;

        TagOption(String tag) {
            this.tag = tag;
        }

        String getTag() {
            return this.tag;
        }

        @Override
        void appendToOptions(Options options) {
            options.tag = this.tag;
        }
    }

    static class PageSizeOption
    extends InternalOption
    implements ListOption {
        private final int pageSize;

        PageSizeOption(int pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageSize = this.pageSize;
        }
    }

    static final class DataBoostQueryOption
    extends InternalOption
    implements ReadAndQueryOption {
        private final Boolean dataBoostEnabled;

        DataBoostQueryOption(Boolean dataBoostEnabled) {
            this.dataBoostEnabled = dataBoostEnabled;
        }

        @Override
        void appendToOptions(Options options) {
            options.dataBoostEnabled = this.dataBoostEnabled;
        }
    }

    static class PageTokenOption
    extends InternalOption
    implements ListOption {
        private final String pageToken;

        PageTokenOption(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageToken = this.pageToken;
        }
    }

    static class FilterOption
    extends InternalOption
    implements ListOption {
        private final String filter;

        FilterOption(String filter) {
            this.filter = filter;
        }

        @Override
        void appendToOptions(Options options) {
            options.filter = this.filter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterOption)) {
                return false;
            }
            return Objects.equals(this.filter, ((FilterOption)o).filter);
        }
    }

    static final class EtagOption
    extends InternalOption
    implements DeleteAdminApiOption {
        private final String etag;

        EtagOption(String etag) {
            this.etag = etag;
        }

        @Override
        void appendToOptions(Options options) {
            options.etag = this.etag;
        }
    }

    static final class ValidateOnlyOption
    extends InternalOption
    implements CreateUpdateDeleteAdminApiOption {
        private final Boolean validateOnly;

        ValidateOnlyOption(Boolean validateOnly) {
            this.validateOnly = validateOnly;
        }

        @Override
        void appendToOptions(Options options) {
            options.validateOnly = this.validateOnly;
        }
    }

    static final class DirectedReadOption
    extends InternalOption
    implements ReadAndQueryOption {
        private final DirectedReadOptions directedReadOptions;

        DirectedReadOption(DirectedReadOptions directedReadOptions) {
            this.directedReadOptions = (DirectedReadOptions)Preconditions.checkNotNull((Object)directedReadOptions, (Object)"DirectedReadOptions cannot be null");
        }

        @Override
        void appendToOptions(Options options) {
            options.directedReadOptions = this.directedReadOptions;
        }
    }

    static final class DecodeOption
    extends InternalOption
    implements ReadAndQueryOption {
        private final DecodeMode decodeMode;

        DecodeOption(DecodeMode decodeMode) {
            this.decodeMode = (DecodeMode)((Object)Preconditions.checkNotNull((Object)((Object)decodeMode), (Object)"DecodeMode cannot be null"));
        }

        @Override
        void appendToOptions(Options options) {
            options.decodeMode = this.decodeMode;
        }
    }

    private static abstract class InternalOption {
        private InternalOption() {
        }

        abstract void appendToOptions(Options var1);
    }

    public static interface AdminApiOption {
    }

    public static interface ListOption {
    }

    public static interface UpdateOption {
    }

    public static interface TransactionOption {
    }

    public static interface QueryOption {
    }

    public static interface UpdateAdminApiOption
    extends AdminApiOption {
    }

    public static interface DeleteAdminApiOption
    extends AdminApiOption {
    }

    public static interface CreateAdminApiOption
    extends AdminApiOption {
    }

    public static interface CreateUpdateDeleteAdminApiOption
    extends CreateAdminApiOption,
    UpdateAdminApiOption,
    DeleteAdminApiOption {
    }

    public static interface UpdateTransactionOption
    extends UpdateOption,
    TransactionOption {
    }

    public static interface ReadQueryUpdateTransactionOption
    extends ReadOption,
    QueryOption,
    UpdateOption,
    TransactionOption {
    }

    public static interface ReadOption {
    }

    public static interface ReadAndQueryOption
    extends ReadOption,
    QueryOption {
    }
}

