/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import javax.annotation.Nullable;

public class TransactionMutationLimitExceededException
extends SpannerException {
    private static final long serialVersionUID = 1L;

    TransactionMutationLimitExceededException(SpannerException.DoNotConstructDirectly token, ErrorCode errorCode, String message, Throwable cause, @Nullable ApiException apiException) {
        super(token, errorCode, false, message, cause, apiException);
    }

    static boolean isTransactionMutationLimitException(Throwable cause) {
        if (cause == null || cause.getMessage() == null || !cause.getMessage().contains("The transaction contains too many mutations.")) {
            return false;
        }
        ErrorDetails errorDetails = SpannerExceptionFactory.extractErrorDetails(cause);
        if (errorDetails != null && errorDetails.getHelp() != null) {
            return errorDetails.getHelp().getLinksCount() == 1 && errorDetails.getHelp().getLinks(0).getDescription().equals("Cloud Spanner limits documentation.") && errorDetails.getHelp().getLinks(0).getUrl().equals("https://cloud.google.com/spanner/docs/limits");
        }
        return false;
    }
}

