/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class ConnectionState {
    private final Object lock = new Object();
    private final Supplier<Type> type;
    private final Map<String, ConnectionPropertyValue<?>> properties = new HashMap(ConnectionProperties.CONNECTION_PROPERTIES.size());
    private Map<String, ConnectionPropertyValue<?>> transactionProperties;
    private Map<String, ConnectionPropertyValue<?>> localProperties;

    ConnectionState(Map<String, ConnectionPropertyValue<?>> initialValues) {
        this(initialValues, (Supplier<Type>)Suppliers.ofInstance((Object)((Object)Type.NON_TRANSACTIONAL)));
    }

    ConnectionState(Map<String, ConnectionPropertyValue<?>> initialValues, Supplier<Type> defaultConnectionStateTypeSupplier) {
        for (Map.Entry entry : ConnectionProperties.CONNECTION_PROPERTIES.entrySet()) {
            this.properties.put((String)entry.getKey(), ((ConnectionProperty)entry.getValue()).createInitialValue(ConnectionPropertyValue.cast(initialValues.get(entry.getKey()))));
        }
        for (Map.Entry entry : initialValues.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.setValue(ConnectionProperty.castProperty(((ConnectionPropertyValue)entry.getValue()).getProperty()), ConnectionPropertyValue.cast((ConnectionPropertyValue)entry.getValue()).getValue(), ConnectionProperty.Context.STARTUP, false);
        }
        Type configuredType = this.getValue(ConnectionProperties.CONNECTION_STATE_TYPE).getValue();
        this.type = configuredType == null ? defaultConnectionStateTypeSupplier : Suppliers.ofInstance((Object)((Object)configuredType));
    }

    @VisibleForTesting
    Type getType() {
        return this.type.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasTransactionalChanges() {
        Object object = this.lock;
        synchronized (object) {
            return this.transactionProperties != null || this.localProperties != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ConnectionPropertyValue<?>> getAllValues() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> ConnectionPropertyValue<T> getValue(ConnectionProperty<T> property) {
        Object object = this.lock;
        synchronized (object) {
            return this.internalGetValue(property, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <T> ConnectionPropertyValue<T> tryGetValue(ConnectionProperty<T> property) {
        Object object = this.lock;
        synchronized (object) {
            return this.internalGetValue(property, false);
        }
    }

    private <T> ConnectionPropertyValue<T> internalGetValue(ConnectionProperty<T> property, boolean throwForUnknownParam) {
        if (this.localProperties != null && this.localProperties.containsKey(property.getKey())) {
            return ConnectionPropertyValue.cast(this.localProperties.get(property.getKey()));
        }
        if (this.transactionProperties != null && this.transactionProperties.containsKey(property.getKey())) {
            return ConnectionPropertyValue.cast(this.transactionProperties.get(property.getKey()));
        }
        if (this.properties.containsKey(property.getKey())) {
            return ConnectionPropertyValue.cast(this.properties.get(property.getKey()));
        }
        if (throwForUnknownParam) {
            throw ConnectionState.unknownParamError(property);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setValue(ConnectionProperty<T> property, T value, ConnectionProperty.Context context, boolean inTransaction) {
        ConnectionPreconditions.checkState(property.getContext().ordinal() >= context.ordinal(), "Property has context " + (Object)((Object)property.getContext()) + " and cannot be set in context " + (Object)((Object)context));
        Object object = this.lock;
        synchronized (object) {
            if (!inTransaction || this.getType() == Type.NON_TRANSACTIONAL || context.ordinal() < ConnectionProperty.Context.USER.ordinal()) {
                this.internalSetValue(property, value, this.properties, context);
                return;
            }
            if (this.transactionProperties == null) {
                this.transactionProperties = new HashMap();
            }
            this.internalSetValue(property, value, this.transactionProperties, context);
            if (this.localProperties != null) {
                this.localProperties.remove(property.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setLocalValue(ConnectionProperty<T> property, T value) {
        ConnectionPreconditions.checkState(property.getContext().ordinal() >= ConnectionProperty.Context.USER.ordinal(), "setLocalValue is only supported for properties with context USER or higher.");
        Object object = this.lock;
        synchronized (object) {
            if (this.localProperties == null) {
                this.localProperties = new HashMap();
            }
            this.internalSetValue(property, value, this.localProperties, ConnectionProperty.Context.USER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void resetValue(ConnectionProperty<T> property, ConnectionProperty.Context context, boolean inTransaction) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionPropertyValue<T> currentValue = this.getValue(property);
            if (currentValue == null) {
                this.setValue(property, null, context, inTransaction);
            } else {
                this.setValue(property, currentValue.getResetValue(), context, inTransaction);
            }
        }
    }

    private <T> void internalSetValue(ConnectionProperty<T> property, T value, Map<String, ConnectionPropertyValue<?>> currentProperties, ConnectionProperty.Context context) {
        ConnectionPropertyValue<Object> newValue = ConnectionPropertyValue.cast(currentProperties.get(property.getKey()));
        if (newValue == null) {
            ConnectionPropertyValue existingValue = ConnectionPropertyValue.cast(this.properties.get(property.getKey()));
            if (existingValue == null) {
                if (!property.hasExtension()) {
                    throw ConnectionState.unknownParamError(property);
                }
                newValue = new ConnectionPropertyValue<Object>(property, null, null);
            } else {
                newValue = existingValue.copy();
            }
        }
        newValue.setValue(value, context);
        currentProperties.put(property.getKey(), newValue);
    }

    static SpannerException unknownParamError(ConnectionProperty<?> property) {
        return SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("unrecognized configuration property \"%s\"", property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        Object object = this.lock;
        synchronized (object) {
            if (this.transactionProperties != null) {
                for (ConnectionPropertyValue<?> value : this.transactionProperties.values()) {
                    this.properties.put(value.getProperty().getKey(), value);
                }
            }
            this.localProperties = null;
            this.transactionProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() {
        Object object = this.lock;
        synchronized (object) {
            this.localProperties = null;
            this.transactionProperties = null;
        }
    }

    static enum Type {
        TRANSACTIONAL,
        NON_TRANSACTIONAL;

    }
}

