/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFunction;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionSpannerOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;

public class SpannerPool {
    private static final String CONNECTION_API_CLIENT_LIB_TOKEN = "sp-jdbc";
    private static final Logger logger = Logger.getLogger(SpannerPool.class.getName());
    private static final Function<Spanner, Void> DEFAULT_CLOSE_FUNCTION = spanner -> {
        spanner.close();
        return null;
    };
    private static final long DEFAULT_CLOSE_SPANNER_AFTER_MILLISECONDS_UNUSED = 60000L;
    static final SpannerPool INSTANCE = new SpannerPool(60000L, Ticker.systemTicker());
    private boolean initialized = false;
    private Thread shutdownThread = null;
    private final long closeSpannerAfterMillisecondsUnused;
    private ScheduledExecutorService closerService;
    @GuardedBy(value="this")
    private final Map<SpannerPoolKey, Spanner> spanners = new HashMap<SpannerPoolKey, Spanner>();
    @GuardedBy(value="this")
    private final Map<SpannerPoolKey, List<ConnectionImpl>> connections = new HashMap<SpannerPoolKey, List<ConnectionImpl>>();
    @GuardedBy(value="this")
    private final Map<SpannerPoolKey, Long> lastConnectionClosedAt = new HashMap<SpannerPoolKey, Long>();
    private final Ticker ticker;

    public static void closeSpannerPool() {
        INSTANCE.checkAndCloseSpanners();
    }

    @VisibleForTesting
    SpannerPool(Ticker ticker) {
        this(0L, ticker);
    }

    @VisibleForTesting
    SpannerPool(long closeSpannerAfterMillisecondsUnused, Ticker ticker) {
        this.closeSpannerAfterMillisecondsUnused = closeSpannerAfterMillisecondsUnused;
        this.ticker = ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Spanner getSpanner(ConnectionOptions options, ConnectionImpl connection) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)connection);
        SpannerPoolKey key = SpannerPoolKey.of(options);
        SpannerPool spannerPool = this;
        synchronized (spannerPool) {
            Spanner spanner;
            if (!this.initialized) {
                this.initialize();
            }
            if (this.spanners.get(key) != null) {
                spanner = this.spanners.get(key);
            } else {
                spanner = this.createSpanner(key, options);
                this.spanners.put(key, spanner);
            }
            List registeredConnectionsForSpanner = this.connections.computeIfAbsent(key, k -> new ArrayList());
            registeredConnectionsForSpanner.add(connection);
            this.lastConnectionClosedAt.remove(key);
            return spanner;
        }
    }

    private void initialize() {
        this.shutdownThread = new Thread((Runnable)new CloseSpannerRunnable(), "SpannerPool shutdown hook");
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        if (this.closeSpannerAfterMillisecondsUnused > 0L) {
            this.closerService = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable, "close-unused-spanners-worker");
                thread.setDaemon(true);
                return thread;
            });
            this.closerService.scheduleAtFixedRate(new CloseUnusedSpannersRunnable(), this.closeSpannerAfterMillisecondsUnused, this.closeSpannerAfterMillisecondsUnused, TimeUnit.MILLISECONDS);
        }
        this.initialized = true;
    }

    @VisibleForTesting
    Spanner createSpanner(SpannerPoolKey key, ConnectionOptions options) {
        ConnectionSpannerOptions.Builder builder = ConnectionSpannerOptions.newBuilder();
        ((SpannerOptions.Builder)builder.setUseVirtualThreads(key.useVirtualGrpcTransportThreads).setClientLibToken((String)MoreObjects.firstNonNull((Object)key.userAgent, (Object)CONNECTION_API_CLIENT_LIB_TOKEN)).setHost(key.host).setProjectId(key.projectId)).setDecodeMode(DecodeMode.LAZY_PER_COL).setDatabaseRole(options.getDatabaseRole()).setCredentials(options.getCredentials());
        builder.setSessionPoolOption(key.sessionPoolOptions);
        if (key.openTelemetry != null) {
            builder.setOpenTelemetry(key.openTelemetry);
        }
        if (key.enableExtendedTracing != null) {
            builder.setEnableExtendedTracing(key.enableExtendedTracing);
        }
        if (key.enableApiTracing != null) {
            builder.setEnableApiTracing(key.enableApiTracing);
        }
        if (key.numChannels != null) {
            builder.setNumChannels(key.numChannels);
        }
        if (options.getChannelProvider() != null) {
            builder.setChannelProvider(options.getChannelProvider());
        }
        if (!options.isRouteToLeader()) {
            builder.disableLeaderAwareRouting();
        }
        if (options.isEndToEndTracingEnabled()) {
            builder.setEnableEndToEndTracing(true);
        }
        if (key.usePlainText) {
            builder.setCredentials((Credentials)NoCredentials.getInstance());
            builder.setChannelConfigurator((ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>)((ApiFunction)ManagedChannelBuilder::usePlaintext));
        }
        if (key.clientCertificate != null && key.clientCertificateKey != null) {
            builder.useClientCert(key.clientCertificate, key.clientCertificateKey);
        }
        if (options.getConfigurator() != null) {
            options.getConfigurator().configure(builder);
        }
        return (Spanner)builder.build().getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ConnectionOptions options, ConnectionImpl connection) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)connection);
        SpannerPoolKey key = SpannerPoolKey.of(options);
        SpannerPool spannerPool = this;
        synchronized (spannerPool) {
            if (this.spanners.containsKey(key) && this.connections.containsKey(key)) {
                List<ConnectionImpl> registeredConnections = this.connections.get(key);
                if (registeredConnections == null || !registeredConnections.remove(connection)) {
                    logger.log(Level.WARNING, "There are no connections registered for ConnectionOptions " + options.toString());
                } else if (registeredConnections.isEmpty()) {
                    this.lastConnectionClosedAt.put(key, TimeUnit.MILLISECONDS.convert(this.ticker.read(), TimeUnit.NANOSECONDS));
                }
            } else {
                logger.log(Level.WARNING, "There is no Spanner registered for ConnectionOptions " + options.toString());
            }
        }
    }

    void checkAndCloseSpanners() {
        this.checkAndCloseSpanners(CheckAndCloseSpannersMode.ERROR);
    }

    @VisibleForTesting
    void checkAndCloseSpanners(CheckAndCloseSpannersMode mode) {
        this.checkAndCloseSpanners(mode, DEFAULT_CLOSE_FUNCTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkAndCloseSpanners(CheckAndCloseSpannersMode mode, Function<Spanner, Void> closeSpannerFunction) {
        ArrayList<SpannerPoolKey> keysStillInUse = new ArrayList<SpannerPoolKey>();
        SpannerPool spannerPool = this;
        synchronized (spannerPool) {
            block10: {
                for (Map.Entry<SpannerPoolKey, Spanner> entry : this.spanners.entrySet()) {
                    if (this.lastConnectionClosedAt.containsKey(entry.getKey())) continue;
                    keysStillInUse.add(entry.getKey());
                }
                try {
                    if (keysStillInUse.isEmpty() || mode == CheckAndCloseSpannersMode.WARN) {
                        if (!keysStillInUse.isEmpty()) {
                            this.logLeakedConnections(keysStillInUse);
                            logger.log(Level.WARNING, "There is/are " + keysStillInUse.size() + " connection(s) still open. Close all connections before stopping the application");
                        }
                        this.closeUnusedSpanners(Long.MIN_VALUE, closeSpannerFunction);
                        break block10;
                    }
                    this.logLeakedConnections(keysStillInUse);
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is/are " + keysStillInUse.size() + " connection(s) still open. Close all connections before calling closeSpanner()");
                }
                finally {
                    if (this.closerService != null) {
                        this.closerService.shutdown();
                    }
                    this.initialized = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logLeakedConnections(List<SpannerPoolKey> keysStillInUse) {
        SpannerPool spannerPool = this;
        synchronized (spannerPool) {
            for (SpannerPoolKey key : keysStillInUse) {
                for (ConnectionImpl con : this.connections.get(key)) {
                    if (con.isClosed() || con.getLeakedException() == null) continue;
                    logger.log(Level.WARNING, "Leaked connection", con.getLeakedException());
                }
            }
        }
    }

    @VisibleForTesting
    void closeUnusedSpanners(long closeSpannerAfterMillisecondsUnused) {
        this.closeUnusedSpanners(closeSpannerAfterMillisecondsUnused, DEFAULT_CLOSE_FUNCTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUnusedSpanners(long closeSpannerAfterMillisecondsUnused, Function<Spanner, Void> closeSpannerFunction) {
        ArrayList<SpannerPoolKey> keysToBeRemoved = new ArrayList<SpannerPoolKey>();
        SpannerPool spannerPool = this;
        synchronized (spannerPool) {
            for (Map.Entry<SpannerPoolKey, Long> entry : this.lastConnectionClosedAt.entrySet()) {
                Spanner spanner;
                Long closedAt = entry.getValue();
                if (closedAt == null || TimeUnit.MILLISECONDS.convert(this.ticker.read(), TimeUnit.NANOSECONDS) - closedAt <= closeSpannerAfterMillisecondsUnused || (spanner = this.spanners.get(entry.getKey())) == null) continue;
                try {
                    closeSpannerFunction.apply((Object)spanner);
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    this.spanners.remove(entry.getKey());
                    keysToBeRemoved.add(entry.getKey());
                }
            }
            for (SpannerPoolKey key : keysToBeRemoved) {
                this.lastConnectionClosedAt.remove(key);
            }
        }
    }

    static class SpannerPoolKey {
        private final String host;
        private final String projectId;
        private final CredentialsKey credentialsKey;
        private final SessionPoolOptions sessionPoolOptions;
        private final Integer numChannels;
        private final boolean usePlainText;
        private final String userAgent;
        private final String databaseRole;
        private final boolean routeToLeader;
        private final boolean useVirtualGrpcTransportThreads;
        private final OpenTelemetry openTelemetry;
        private final Boolean enableExtendedTracing;
        private final Boolean enableApiTracing;
        private final boolean enableEndToEndTracing;
        private final String clientCertificate;
        private final String clientCertificateKey;

        @VisibleForTesting
        static SpannerPoolKey of(ConnectionOptions options) {
            try {
                return new SpannerPoolKey(options);
            }
            catch (IOException ioException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to get credentials: " + ioException.getMessage(), ioException);
            }
        }

        private SpannerPoolKey(ConnectionOptions options) throws IOException {
            this.host = options.getHost();
            this.projectId = options.getProjectId();
            this.credentialsKey = CredentialsKey.create(options);
            this.databaseRole = options.getDatabaseRole();
            this.sessionPoolOptions = options.getSessionPoolOptions() == null ? SessionPoolOptions.newBuilder().build() : options.getSessionPoolOptions();
            this.numChannels = options.getNumChannels();
            this.usePlainText = options.isUsePlainText();
            this.userAgent = options.getUserAgent();
            this.routeToLeader = options.isRouteToLeader();
            this.useVirtualGrpcTransportThreads = options.isUseVirtualGrpcTransportThreads();
            this.openTelemetry = options.getOpenTelemetry();
            this.enableExtendedTracing = options.isEnableExtendedTracing();
            this.enableApiTracing = options.isEnableApiTracing();
            this.enableEndToEndTracing = options.isEndToEndTracingEnabled();
            this.clientCertificate = options.getClientCertificate();
            this.clientCertificateKey = options.getClientCertificateKey();
        }

        public boolean equals(Object o) {
            if (!(o instanceof SpannerPoolKey)) {
                return false;
            }
            SpannerPoolKey other = (SpannerPoolKey)o;
            return Objects.equals(this.host, other.host) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.credentialsKey, other.credentialsKey) && Objects.equals(this.sessionPoolOptions, other.sessionPoolOptions) && Objects.equals(this.numChannels, other.numChannels) && Objects.equals(this.databaseRole, other.databaseRole) && Objects.equals(this.usePlainText, other.usePlainText) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.routeToLeader, other.routeToLeader) && Objects.equals(this.useVirtualGrpcTransportThreads, other.useVirtualGrpcTransportThreads) && Objects.equals(this.openTelemetry, other.openTelemetry) && Objects.equals(this.enableExtendedTracing, other.enableExtendedTracing) && Objects.equals(this.enableApiTracing, other.enableApiTracing) && Objects.equals(this.enableEndToEndTracing, other.enableEndToEndTracing) && Objects.equals(this.clientCertificate, other.clientCertificate) && Objects.equals(this.clientCertificateKey, other.clientCertificateKey);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.projectId, this.credentialsKey, this.sessionPoolOptions, this.numChannels, this.usePlainText, this.databaseRole, this.userAgent, this.routeToLeader, this.useVirtualGrpcTransportThreads, this.openTelemetry, this.enableExtendedTracing, this.enableApiTracing, this.enableEndToEndTracing, this.clientCertificate, this.clientCertificateKey);
        }
    }

    private final class CloseSpannerRunnable
    implements Runnable {
        private CloseSpannerRunnable() {
        }

        @Override
        public void run() {
            try {
                SpannerPool.this.checkAndCloseSpanners(CheckAndCloseSpannersMode.WARN);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final class CloseUnusedSpannersRunnable
    implements Runnable {
        private CloseUnusedSpannersRunnable() {
        }

        @Override
        public void run() {
            try {
                SpannerPool.this.closeUnusedSpanners(SpannerPool.this.closeSpannerAfterMillisecondsUnused);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Scheduled call to closeUnusedSpanners failed", e);
            }
        }
    }

    @VisibleForTesting
    static enum CheckAndCloseSpannersMode {
        WARN,
        ERROR;

    }

    static class CredentialsKey {
        static final Object DEFAULT_CREDENTIALS_KEY = new Object();
        final Object key;

        static CredentialsKey create(ConnectionOptions options) throws IOException {
            return new CredentialsKey(Stream.of(options.getOAuthToken(), options.getCredentialsProvider() == null ? null : options.getCredentials(), options.getFixedCredentials(), options.getCredentialsUrl(), DEFAULT_CREDENTIALS_KEY).filter(Objects::nonNull).findFirst().get());
        }

        private CredentialsKey(Object key) {
            this.key = Preconditions.checkNotNull((Object)key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CredentialsKey && Objects.equals(((CredentialsKey)o).key, this.key);
        }
    }
}

