/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.SessionPool;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import org.threeten.bp.Duration;

public class SessionPoolOptions {
    private static final int DEFAULT_MAX_SESSIONS = 400;
    private static final int DEFAULT_MIN_SESSIONS = 100;
    private static final int DEFAULT_INC_STEP = 25;
    private static final ActionOnExhaustion DEFAULT_ACTION = ActionOnExhaustion.BLOCK;
    private final int minSessions;
    private final int maxSessions;
    private final int incStep;
    @Deprecated
    private final int maxIdleSessions;
    @Deprecated
    private final float writeSessionsFraction;
    private final ActionOnExhaustion actionOnExhaustion;
    private final long loopFrequency;
    private final java.time.Duration multiplexedSessionMaintenanceLoopFrequency;
    private final int keepAliveIntervalMinutes;
    private final java.time.Duration removeInactiveSessionAfter;
    private final ActionOnSessionNotFound actionOnSessionNotFound;
    private final ActionOnSessionLeak actionOnSessionLeak;
    private final boolean trackStackTraceOfSessionCheckout;
    private final InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions;
    @Deprecated
    private final long initialWaitForSessionTimeoutMillis;
    private final boolean autoDetectDialect;
    private final java.time.Duration waitForMinSessions;
    private final java.time.Duration acquireSessionTimeout;
    private final SessionPool.Position releaseToPosition;
    private final long randomizePositionQPSThreshold;
    private final Clock poolMaintainerClock;
    private final boolean useMultiplexedSession;
    private final boolean useMultiplexedSessionForRW;
    private final boolean useMultiplexedSessionForPartitionedOps;
    private final java.time.Duration multiplexedSessionMaintenanceDuration;
    private final boolean skipVerifyingBeginTransactionForMuxRW;

    private SessionPoolOptions(Builder builder) {
        this.minSessions = Math.min(builder.minSessions, builder.maxSessions);
        this.maxSessions = builder.maxSessions;
        this.incStep = builder.incStep;
        this.maxIdleSessions = builder.maxIdleSessions;
        this.writeSessionsFraction = builder.writeSessionsFraction;
        this.actionOnExhaustion = builder.actionOnExhaustion;
        this.actionOnSessionNotFound = builder.actionOnSessionNotFound;
        this.actionOnSessionLeak = builder.actionOnSessionLeak;
        this.trackStackTraceOfSessionCheckout = builder.trackStackTraceOfSessionCheckout;
        this.initialWaitForSessionTimeoutMillis = builder.initialWaitForSessionTimeoutMillis;
        this.loopFrequency = builder.loopFrequency;
        this.multiplexedSessionMaintenanceLoopFrequency = builder.multiplexedSessionMaintenanceLoopFrequency;
        this.keepAliveIntervalMinutes = builder.keepAliveIntervalMinutes;
        this.removeInactiveSessionAfter = builder.removeInactiveSessionAfter;
        this.autoDetectDialect = builder.autoDetectDialect;
        this.waitForMinSessions = builder.waitForMinSessions;
        this.acquireSessionTimeout = builder.acquireSessionTimeout;
        this.releaseToPosition = builder.releaseToPosition;
        this.randomizePositionQPSThreshold = builder.randomizePositionQPSThreshold;
        this.inactiveTransactionRemovalOptions = builder.inactiveTransactionRemovalOptions;
        this.poolMaintainerClock = builder.poolMaintainerClock;
        Boolean useMultiplexedSessionFromEnvVariable = SessionPoolOptions.getUseMultiplexedSessionFromEnvVariable();
        this.useMultiplexedSession = useMultiplexedSessionFromEnvVariable != null ? useMultiplexedSessionFromEnvVariable : builder.useMultiplexedSession;
        Boolean useMultiplexedSessionForRWFromEnvVariable = SessionPoolOptions.getUseMultiplexedSessionForRWFromEnvVariable();
        this.useMultiplexedSessionForRW = useMultiplexedSessionForRWFromEnvVariable != null ? useMultiplexedSessionForRWFromEnvVariable : builder.useMultiplexedSessionForRW;
        Boolean useMultiplexedSessionFromEnvVariablePartitionedOps = SessionPoolOptions.getUseMultiplexedSessionFromEnvVariablePartitionedOps();
        this.useMultiplexedSessionForPartitionedOps = useMultiplexedSessionFromEnvVariablePartitionedOps != null ? useMultiplexedSessionFromEnvVariablePartitionedOps : builder.useMultiplexedSessionPartitionedOps;
        this.multiplexedSessionMaintenanceDuration = builder.multiplexedSessionMaintenanceDuration;
        this.skipVerifyingBeginTransactionForMuxRW = builder.skipVerifyingBeginTransactionForMuxRW;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionPoolOptions)) {
            return false;
        }
        SessionPoolOptions other = (SessionPoolOptions)o;
        return Objects.equals(this.minSessions, other.minSessions) && Objects.equals(this.maxSessions, other.maxSessions) && Objects.equals(this.incStep, other.incStep) && Objects.equals(this.maxIdleSessions, other.maxIdleSessions) && Objects.equals(Float.valueOf(this.writeSessionsFraction), Float.valueOf(other.writeSessionsFraction)) && Objects.equals((Object)this.actionOnExhaustion, (Object)other.actionOnExhaustion) && Objects.equals((Object)this.actionOnSessionNotFound, (Object)other.actionOnSessionNotFound) && Objects.equals((Object)this.actionOnSessionLeak, (Object)other.actionOnSessionLeak) && Objects.equals(this.trackStackTraceOfSessionCheckout, other.trackStackTraceOfSessionCheckout) && Objects.equals(this.initialWaitForSessionTimeoutMillis, other.initialWaitForSessionTimeoutMillis) && Objects.equals(this.loopFrequency, other.loopFrequency) && Objects.equals(this.multiplexedSessionMaintenanceLoopFrequency, other.multiplexedSessionMaintenanceLoopFrequency) && Objects.equals(this.keepAliveIntervalMinutes, other.keepAliveIntervalMinutes) && Objects.equals(this.removeInactiveSessionAfter, other.removeInactiveSessionAfter) && Objects.equals(this.autoDetectDialect, other.autoDetectDialect) && Objects.equals(this.waitForMinSessions, other.waitForMinSessions) && Objects.equals(this.acquireSessionTimeout, other.acquireSessionTimeout) && Objects.equals((Object)this.releaseToPosition, (Object)other.releaseToPosition) && Objects.equals(this.randomizePositionQPSThreshold, other.randomizePositionQPSThreshold) && Objects.equals(this.inactiveTransactionRemovalOptions, other.inactiveTransactionRemovalOptions) && Objects.equals(this.poolMaintainerClock, other.poolMaintainerClock) && Objects.equals(this.useMultiplexedSession, other.useMultiplexedSession) && Objects.equals(this.useMultiplexedSessionForRW, other.useMultiplexedSessionForRW) && Objects.equals(this.multiplexedSessionMaintenanceDuration, other.multiplexedSessionMaintenanceDuration) && Objects.equals(this.skipVerifyingBeginTransactionForMuxRW, other.skipVerifyingBeginTransactionForMuxRW);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minSessions, this.maxSessions, this.incStep, this.maxIdleSessions, Float.valueOf(this.writeSessionsFraction), this.actionOnExhaustion, this.actionOnSessionNotFound, this.actionOnSessionLeak, this.trackStackTraceOfSessionCheckout, this.initialWaitForSessionTimeoutMillis, this.loopFrequency, this.multiplexedSessionMaintenanceLoopFrequency, this.keepAliveIntervalMinutes, this.removeInactiveSessionAfter, this.autoDetectDialect, this.waitForMinSessions, this.acquireSessionTimeout, this.releaseToPosition, this.randomizePositionQPSThreshold, this.inactiveTransactionRemovalOptions, this.poolMaintainerClock, this.useMultiplexedSession, this.useMultiplexedSessionForRW, this.multiplexedSessionMaintenanceDuration, this.skipVerifyingBeginTransactionForMuxRW});
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    int getIncStep() {
        return this.incStep;
    }

    @Deprecated
    public int getMaxIdleSessions() {
        return this.maxIdleSessions;
    }

    @Deprecated
    public float getWriteSessionsFraction() {
        return this.writeSessionsFraction;
    }

    long getLoopFrequency() {
        return this.loopFrequency;
    }

    java.time.Duration getMultiplexedSessionMaintenanceLoopFrequency() {
        return this.multiplexedSessionMaintenanceLoopFrequency;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    @ObsoleteApi(value="Use getRemoveInactiveSessionAfterDuration() instead")
    public Duration getRemoveInactiveSessionAfter() {
        return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getRemoveInactiveSessionAfterDuration());
    }

    public java.time.Duration getRemoveInactiveSessionAfterDuration() {
        return this.removeInactiveSessionAfter;
    }

    public boolean isFailIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.FAIL;
    }

    public boolean isBlockIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.BLOCK;
    }

    public boolean isAutoDetectDialect() {
        return this.autoDetectDialect;
    }

    InactiveTransactionRemovalOptions getInactiveTransactionRemovalOptions() {
        return this.inactiveTransactionRemovalOptions;
    }

    boolean closeInactiveTransactions() {
        return this.inactiveTransactionRemovalOptions.actionOnInactiveTransaction == ActionOnInactiveTransaction.CLOSE;
    }

    boolean warnAndCloseInactiveTransactions() {
        return this.inactiveTransactionRemovalOptions.actionOnInactiveTransaction == ActionOnInactiveTransaction.WARN_AND_CLOSE;
    }

    boolean warnInactiveTransactions() {
        return this.inactiveTransactionRemovalOptions.actionOnInactiveTransaction == ActionOnInactiveTransaction.WARN;
    }

    @VisibleForTesting
    long getInitialWaitForSessionTimeoutMillis() {
        return this.initialWaitForSessionTimeoutMillis;
    }

    @VisibleForTesting
    boolean isFailIfSessionNotFound() {
        return this.actionOnSessionNotFound == ActionOnSessionNotFound.FAIL;
    }

    @VisibleForTesting
    boolean isFailOnSessionLeak() {
        return this.actionOnSessionLeak == ActionOnSessionLeak.FAIL;
    }

    @VisibleForTesting
    Clock getPoolMaintainerClock() {
        return this.poolMaintainerClock;
    }

    public boolean isTrackStackTraceOfSessionCheckout() {
        return this.trackStackTraceOfSessionCheckout;
    }

    java.time.Duration getWaitForMinSessions() {
        return this.waitForMinSessions;
    }

    @VisibleForTesting
    java.time.Duration getAcquireSessionTimeout() {
        return this.acquireSessionTimeout;
    }

    SessionPool.Position getReleaseToPosition() {
        return this.releaseToPosition;
    }

    long getRandomizePositionQPSThreshold() {
        return this.randomizePositionQPSThreshold;
    }

    @InternalApi
    @VisibleForTesting
    public boolean getUseMultiplexedSession() {
        return this.useMultiplexedSession;
    }

    @InternalApi
    @VisibleForTesting
    protected boolean getUseMultiplexedSessionBlindWrite() {
        return this.getUseMultiplexedSession();
    }

    @InternalApi
    @VisibleForTesting
    public boolean getUseMultiplexedSessionForRW() {
        return this.getUseMultiplexedSession() && this.useMultiplexedSessionForRW;
    }

    @InternalApi
    @VisibleForTesting
    public boolean getUseMultiplexedSessionPartitionedOps() {
        return this.getUseMultiplexedSession() && this.useMultiplexedSessionForPartitionedOps;
    }

    private static Boolean getUseMultiplexedSessionFromEnvVariable() {
        return SessionPoolOptions.parseBooleanEnvVariable("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS");
    }

    @InternalApi
    @VisibleForTesting
    protected static Boolean getUseMultiplexedSessionFromEnvVariablePartitionedOps() {
        return SessionPoolOptions.parseBooleanEnvVariable("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS_PARTITIONED_OPS");
    }

    private static Boolean parseBooleanEnvVariable(String variableName) {
        String envVariable = System.getenv(variableName);
        if (envVariable != null && envVariable.length() > 0) {
            if ("true".equalsIgnoreCase(envVariable) || "false".equalsIgnoreCase(envVariable)) {
                return Boolean.parseBoolean(envVariable);
            }
            throw new IllegalArgumentException(variableName + " should be either true or false.");
        }
        return null;
    }

    private static Boolean getUseMultiplexedSessionForRWFromEnvVariable() {
        return SessionPoolOptions.parseBooleanEnvVariable("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS_FOR_RW");
    }

    java.time.Duration getMultiplexedSessionMaintenanceDuration() {
        return this.multiplexedSessionMaintenanceDuration;
    }

    @InternalApi
    @VisibleForTesting
    boolean getSkipVerifyBeginTransactionForMuxRW() {
        return this.skipVerifyingBeginTransactionForMuxRW;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ ActionOnExhaustion access$3200() {
        return DEFAULT_ACTION;
    }

    public static class Builder {
        private boolean minSessionsSet = false;
        private int minSessions = 100;
        private int maxSessions = 400;
        private int incStep = 25;
        @Deprecated
        private int maxIdleSessions;
        @Deprecated
        private float writeSessionsFraction = 0.2f;
        private ActionOnExhaustion actionOnExhaustion = SessionPoolOptions.access$3200();
        private long initialWaitForSessionTimeoutMillis = 30000L;
        private ActionOnSessionNotFound actionOnSessionNotFound = ActionOnSessionNotFound.RETRY;
        private ActionOnSessionLeak actionOnSessionLeak = ActionOnSessionLeak.WARN;
        private boolean trackStackTraceOfSessionCheckout = true;
        private InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = InactiveTransactionRemovalOptions.newBuilder().build();
        private long loopFrequency = 10000L;
        private java.time.Duration multiplexedSessionMaintenanceLoopFrequency = java.time.Duration.ofMinutes(10L);
        private int keepAliveIntervalMinutes = 30;
        private java.time.Duration removeInactiveSessionAfter = java.time.Duration.ofMinutes(55L);
        private boolean autoDetectDialect = false;
        private java.time.Duration waitForMinSessions = java.time.Duration.ZERO;
        private java.time.Duration acquireSessionTimeout = java.time.Duration.ofSeconds(60L);
        private final SessionPool.Position releaseToPosition = Builder.getReleaseToPositionFromSystemProperty();
        private long randomizePositionQPSThreshold = 0L;
        private boolean useMultiplexedSession = false;
        private boolean useMultiplexedSessionForRW = false;
        private boolean useMultiplexedSessionPartitionedOps = false;
        private java.time.Duration multiplexedSessionMaintenanceDuration = java.time.Duration.ofDays(7L);
        private Clock poolMaintainerClock = Clock.INSTANCE;
        private boolean skipVerifyingBeginTransactionForMuxRW = false;

        private static SessionPool.Position getReleaseToPositionFromSystemProperty() {
            String key = "com.google.cloud.spanner.session_pool_release_to_position";
            if (System.getProperties().containsKey(key)) {
                try {
                    return SessionPool.Position.valueOf(System.getProperty(key).toUpperCase(Locale.ENGLISH));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return SessionPool.Position.FIRST;
        }

        public Builder() {
        }

        private Builder(SessionPoolOptions options) {
            this.minSessionsSet = true;
            this.minSessions = options.minSessions;
            this.maxSessions = options.maxSessions;
            this.incStep = options.incStep;
            this.maxIdleSessions = options.maxIdleSessions;
            this.writeSessionsFraction = options.writeSessionsFraction;
            this.actionOnExhaustion = options.actionOnExhaustion;
            this.initialWaitForSessionTimeoutMillis = options.initialWaitForSessionTimeoutMillis;
            this.actionOnSessionNotFound = options.actionOnSessionNotFound;
            this.actionOnSessionLeak = options.actionOnSessionLeak;
            this.trackStackTraceOfSessionCheckout = options.trackStackTraceOfSessionCheckout;
            this.loopFrequency = options.loopFrequency;
            this.multiplexedSessionMaintenanceLoopFrequency = options.multiplexedSessionMaintenanceLoopFrequency;
            this.keepAliveIntervalMinutes = options.keepAliveIntervalMinutes;
            this.removeInactiveSessionAfter = options.removeInactiveSessionAfter;
            this.autoDetectDialect = options.autoDetectDialect;
            this.waitForMinSessions = options.waitForMinSessions;
            this.acquireSessionTimeout = options.acquireSessionTimeout;
            this.randomizePositionQPSThreshold = options.randomizePositionQPSThreshold;
            this.inactiveTransactionRemovalOptions = options.inactiveTransactionRemovalOptions;
            this.useMultiplexedSession = options.useMultiplexedSession;
            this.useMultiplexedSessionForRW = options.useMultiplexedSessionForRW;
            this.useMultiplexedSessionPartitionedOps = options.useMultiplexedSessionForPartitionedOps;
            this.multiplexedSessionMaintenanceDuration = options.multiplexedSessionMaintenanceDuration;
            this.poolMaintainerClock = options.poolMaintainerClock;
            this.skipVerifyingBeginTransactionForMuxRW = options.skipVerifyingBeginTransactionForMuxRW;
        }

        public Builder setMinSessions(int minSessions) {
            Preconditions.checkArgument((minSessions >= 0 ? 1 : 0) != 0, (Object)"minSessions must be >= 0");
            this.minSessionsSet = true;
            this.minSessions = minSessions;
            return this;
        }

        public Builder setMaxSessions(int maxSessions) {
            Preconditions.checkArgument((maxSessions > 0 ? 1 : 0) != 0, (Object)"maxSessions must be > 0");
            this.maxSessions = maxSessions;
            return this;
        }

        Builder setIncStep(int incStep) {
            Preconditions.checkArgument((incStep > 0 ? 1 : 0) != 0, (Object)"incStep must be > 0");
            this.incStep = incStep;
            return this;
        }

        @Deprecated
        public Builder setMaxIdleSessions(int maxIdleSessions) {
            this.maxIdleSessions = maxIdleSessions;
            return this;
        }

        Builder setLoopFrequency(long loopFrequency) {
            this.loopFrequency = loopFrequency;
            return this;
        }

        Builder setMultiplexedSessionMaintenanceLoopFrequency(java.time.Duration frequency) {
            this.multiplexedSessionMaintenanceLoopFrequency = frequency;
            return this;
        }

        Builder setInactiveTransactionRemovalOptions(InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions) {
            this.inactiveTransactionRemovalOptions = inactiveTransactionRemovalOptions;
            return this;
        }

        @ObsoleteApi(value="Use setRemoveInactiveSessionAfterDuration(Duration) instead")
        public Builder setRemoveInactiveSessionAfter(Duration duration) {
            return this.setRemoveInactiveSessionAfterDuration(TimeConversionUtils.toJavaTimeDuration((Duration)duration));
        }

        public Builder setRemoveInactiveSessionAfterDuration(java.time.Duration duration) {
            this.removeInactiveSessionAfter = duration;
            return this;
        }

        public Builder setKeepAliveIntervalMinutes(int intervalMinutes) {
            this.keepAliveIntervalMinutes = intervalMinutes;
            return this;
        }

        public Builder setFailIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.FAIL;
            return this;
        }

        public Builder setBlockIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.BLOCK;
            return this;
        }

        public Builder setWarnIfInactiveTransactions() {
            this.inactiveTransactionRemovalOptions = InactiveTransactionRemovalOptions.newBuilder().setActionOnInactiveTransaction(ActionOnInactiveTransaction.WARN).build();
            return this;
        }

        public Builder setWarnAndCloseIfInactiveTransactions() {
            this.inactiveTransactionRemovalOptions = InactiveTransactionRemovalOptions.newBuilder().setActionOnInactiveTransaction(ActionOnInactiveTransaction.WARN_AND_CLOSE).build();
            return this;
        }

        @VisibleForTesting
        Builder setCloseIfInactiveTransactions() {
            this.inactiveTransactionRemovalOptions = InactiveTransactionRemovalOptions.newBuilder().setActionOnInactiveTransaction(ActionOnInactiveTransaction.CLOSE).build();
            return this;
        }

        @VisibleForTesting
        Builder setPoolMaintainerClock(Clock poolMaintainerClock) {
            this.poolMaintainerClock = (Clock)Preconditions.checkNotNull((Object)poolMaintainerClock);
            return this;
        }

        Builder setUseMultiplexedSession(boolean useMultiplexedSession) {
            this.useMultiplexedSession = useMultiplexedSession;
            return this;
        }

        @InternalApi
        @VisibleForTesting
        Builder setUseMultiplexedSessionForRW(boolean useMultiplexedSessionForRW) {
            this.useMultiplexedSessionForRW = useMultiplexedSessionForRW;
            return this;
        }

        Builder setUseMultiplexedSessionPartitionedOps(boolean useMultiplexedSessionPartitionedOps) {
            this.useMultiplexedSessionPartitionedOps = useMultiplexedSessionPartitionedOps;
            return this;
        }

        @VisibleForTesting
        Builder setMultiplexedSessionMaintenanceDuration(java.time.Duration multiplexedSessionMaintenanceDuration) {
            this.multiplexedSessionMaintenanceDuration = multiplexedSessionMaintenanceDuration;
            return this;
        }

        @VisibleForTesting
        Builder setSkipVerifyingBeginTransactionForMuxRW(boolean skipVerifyingBeginTransactionForMuxRW) {
            this.skipVerifyingBeginTransactionForMuxRW = skipVerifyingBeginTransactionForMuxRW;
            return this;
        }

        public Builder setAutoDetectDialect(boolean autoDetectDialect) {
            this.autoDetectDialect = autoDetectDialect;
            return this;
        }

        @VisibleForTesting
        Builder setInitialWaitForSessionTimeoutMillis(long timeout) {
            this.initialWaitForSessionTimeoutMillis = timeout;
            return this;
        }

        @VisibleForTesting
        Builder setFailIfSessionNotFound() {
            this.actionOnSessionNotFound = ActionOnSessionNotFound.FAIL;
            return this;
        }

        @VisibleForTesting
        Builder setFailOnSessionLeak() {
            this.actionOnSessionLeak = ActionOnSessionLeak.FAIL;
            return this;
        }

        public Builder setTrackStackTraceOfSessionCheckout(boolean trackStackTraceOfSessionCheckout) {
            this.trackStackTraceOfSessionCheckout = trackStackTraceOfSessionCheckout;
            return this;
        }

        public Builder setWriteSessionsFraction(float writeSessionsFraction) {
            this.writeSessionsFraction = writeSessionsFraction;
            return this;
        }

        @ObsoleteApi(value="Use setWaitForMinSessionsDuration(Duration) instead")
        public Builder setWaitForMinSessions(Duration waitForMinSessions) {
            return this.setWaitForMinSessionsDuration(TimeConversionUtils.toJavaTimeDuration((Duration)waitForMinSessions));
        }

        public Builder setWaitForMinSessionsDuration(java.time.Duration waitForMinSessions) {
            this.waitForMinSessions = waitForMinSessions;
            return this;
        }

        @ObsoleteApi(value="Use setAcquireSessionTimeoutDuration(Duration) instead")
        public Builder setAcquireSessionTimeout(Duration acquireSessionTimeout) {
            return this.setAcquireSessionTimeoutDuration(TimeConversionUtils.toJavaTimeDuration((Duration)acquireSessionTimeout));
        }

        public Builder setAcquireSessionTimeoutDuration(java.time.Duration acquireSessionTimeout) {
            try {
                if (acquireSessionTimeout != null) {
                    Preconditions.checkArgument((acquireSessionTimeout.toMillis() > 0L ? 1 : 0) != 0, (Object)"acquireSessionTimeout should be greater than 0 ns");
                }
            }
            catch (ArithmeticException ex) {
                throw new IllegalArgumentException("acquireSessionTimeout in millis should be lesser than Long.MAX_VALUE");
            }
            this.acquireSessionTimeout = acquireSessionTimeout;
            return this;
        }

        Builder setRandomizePositionQPSThreshold(long randomizePositionQPSThreshold) {
            Preconditions.checkArgument((randomizePositionQPSThreshold >= 0L ? 1 : 0) != 0, (Object)"randomizePositionQPSThreshold must be >= 0");
            this.randomizePositionQPSThreshold = randomizePositionQPSThreshold;
            return this;
        }

        public SessionPoolOptions build() {
            this.validate();
            return new SessionPoolOptions(this);
        }

        private void validate() {
            if (this.minSessionsSet) {
                Preconditions.checkArgument((this.maxSessions >= this.minSessions ? 1 : 0) != 0, (String)"Min sessions(%s) must be <= max sessions(%s)", (int)this.minSessions, (int)this.maxSessions);
            }
            Preconditions.checkArgument((this.keepAliveIntervalMinutes < 60 ? 1 : 0) != 0, (Object)"Keep alive interval should be less than60 minutes");
        }
    }

    static class InactiveTransactionRemovalOptions {
        private final ActionOnInactiveTransaction actionOnInactiveTransaction;
        private final java.time.Duration executionFrequency;
        private final double usedSessionsRatioThreshold;
        private final java.time.Duration idleTimeThreshold;

        InactiveTransactionRemovalOptions(Builder builder) {
            this.actionOnInactiveTransaction = builder.actionOnInactiveTransaction;
            this.idleTimeThreshold = builder.idleTimeThreshold;
            this.executionFrequency = builder.executionFrequency;
            this.usedSessionsRatioThreshold = builder.usedSessionsRatioThreshold;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InactiveTransactionRemovalOptions)) {
                return false;
            }
            InactiveTransactionRemovalOptions other = (InactiveTransactionRemovalOptions)o;
            return Objects.equals((Object)this.actionOnInactiveTransaction, (Object)other.actionOnInactiveTransaction) && Objects.equals(this.idleTimeThreshold, other.idleTimeThreshold) && Objects.equals(this.executionFrequency, other.executionFrequency) && Objects.equals(this.usedSessionsRatioThreshold, other.usedSessionsRatioThreshold);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.actionOnInactiveTransaction, this.idleTimeThreshold, this.executionFrequency, this.usedSessionsRatioThreshold});
        }

        java.time.Duration getExecutionFrequency() {
            return this.executionFrequency;
        }

        double getUsedSessionsRatioThreshold() {
            return this.usedSessionsRatioThreshold;
        }

        java.time.Duration getIdleTimeThreshold() {
            return this.idleTimeThreshold;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static class Builder {
            private ActionOnInactiveTransaction actionOnInactiveTransaction = ActionOnInactiveTransaction.WARN;
            private java.time.Duration executionFrequency = java.time.Duration.ofMinutes(2L);
            private double usedSessionsRatioThreshold = 0.95;
            private java.time.Duration idleTimeThreshold = java.time.Duration.ofMinutes(60L);

            InactiveTransactionRemovalOptions build() {
                this.validate();
                return new InactiveTransactionRemovalOptions(this);
            }

            private void validate() {
                Preconditions.checkArgument((this.executionFrequency.toMillis() > 0L ? 1 : 0) != 0, (String)"Execution frequency %s should be positive", (long)this.executionFrequency.toMillis());
                Preconditions.checkArgument((this.idleTimeThreshold.toMillis() > 0L ? 1 : 0) != 0, (String)"Idle Time Threshold duration %s should be positive", (long)this.idleTimeThreshold.toMillis());
            }

            @VisibleForTesting
            Builder setActionOnInactiveTransaction(ActionOnInactiveTransaction actionOnInactiveTransaction) {
                this.actionOnInactiveTransaction = actionOnInactiveTransaction;
                return this;
            }

            @VisibleForTesting
            Builder setExecutionFrequency(java.time.Duration executionFrequency) {
                this.executionFrequency = executionFrequency;
                return this;
            }

            @VisibleForTesting
            Builder setUsedSessionsRatioThreshold(double usedSessionsRatioThreshold) {
                this.usedSessionsRatioThreshold = usedSessionsRatioThreshold;
                return this;
            }

            @VisibleForTesting
            Builder setIdleTimeThreshold(java.time.Duration idleTimeThreshold) {
                this.idleTimeThreshold = idleTimeThreshold;
                return this;
            }
        }
    }

    private static enum ActionOnSessionLeak {
        WARN,
        FAIL;

    }

    private static enum ActionOnSessionNotFound {
        RETRY,
        FAIL;

    }

    private static enum ActionOnExhaustion {
        BLOCK,
        FAIL;

    }

    @VisibleForTesting
    static enum ActionOnInactiveTransaction {
        WARN,
        WARN_AND_CLOSE,
        CLOSE;

    }
}

