/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.tracing.OpenTelemetryMetricsRecorder;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;

class BuiltInMetricsRecorder
extends OpenTelemetryMetricsRecorder {
    private final DoubleHistogram gfeLatencyRecorder;

    BuiltInMetricsRecorder(OpenTelemetry openTelemetry, String serviceName) {
        super(openTelemetry, serviceName);
        Meter meter = openTelemetry.meterBuilder("spanner-java").setInstrumentationVersion(GaxProperties.getLibraryVersion(((Object)((Object)this)).getClass())).build();
        this.gfeLatencyRecorder = meter.histogramBuilder(serviceName + '/' + "gfe_latencies").setDescription("Latency between Google's network receiving an RPC and reading back the first byte of the response").setUnit("ms").build();
    }

    void recordGFELatency(double gfeLatency, Map<String, String> attributes) {
        this.gfeLatencyRecorder.record(gfeLatency, this.toOtelAttributes(attributes));
    }

    Attributes toOtelAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull(attributes, (Object)"Attributes map cannot be null");
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }
}

