/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Tuple;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientSideStatementSetExecutor<T>
implements ClientSideStatementExecutor {
    private final Cache<String, Tuple<T, Boolean>> cache;
    private final ClientSideStatementImpl statement;
    private final Method method;
    private final boolean supportsLocal;
    private final ClientSideStatementValueConverter<T> converter;
    private final Pattern allowedValuesPattern;

    ClientSideStatementSetExecutor(ClientSideStatementImpl statement) throws ClientSideStatementImpl.CompileException {
        Preconditions.checkNotNull((Object)statement.getSetStatement());
        this.cache = CacheBuilder.newBuilder().maximumSize(25L).concurrencyLevel(1).build();
        try {
            boolean supportsLocal;
            Method method;
            this.statement = statement;
            this.allowedValuesPattern = Pattern.compile(String.format("(?is)\\A\\s*set\\s+((?:local|session)\\s+)?%s\\s*%s\\s*%s\\s*\\z", statement.getSetStatement().getPropertyName(), statement.getSetStatement().getSeparator(), statement.getSetStatement().getAllowedValues()));
            Class<?> converterClass = Class.forName(this.getClass().getPackage().getName() + "." + statement.getSetStatement().getConverterName());
            Constructor<?> constructor = converterClass.getConstructor(String.class);
            this.converter = (ClientSideStatementValueConverter)constructor.newInstance(statement.getSetStatement().getAllowedValues());
            try {
                method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), this.converter.getParameterClass());
                supportsLocal = false;
            }
            catch (NoSuchMethodException ignore) {
                method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), this.converter.getParameterClass(), Boolean.class);
                supportsLocal = true;
            }
            this.method = method;
            this.supportsLocal = supportsLocal;
        }
        catch (Exception e) {
            throw new ClientSideStatementImpl.CompileException(e, statement);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, AbstractStatementParser.ParsedStatement statement) throws Exception {
        Tuple value;
        try {
            value = (Tuple)this.cache.get((Object)statement.getSqlWithoutComments(), () -> this.getParameterValue(statement.getSqlWithoutComments()));
        }
        catch (UncheckedExecutionException | ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        if (this.supportsLocal) {
            return (StatementResult)this.method.invoke((Object)connection, value.x(), value.y());
        }
        return (StatementResult)this.method.invoke((Object)connection, value.x());
    }

    Tuple<T, Boolean> getParameterValue(String sql) {
        int valueGroup;
        Matcher matcher = this.allowedValuesPattern.matcher(sql);
        if (matcher.find() && matcher.groupCount() >= 2) {
            boolean local = matcher.group(1) != null && "local".equalsIgnoreCase(matcher.group(1).trim());
            String value = matcher.group(2);
            T res = this.converter.convert(value);
            if (res != null) {
                return Tuple.of(res, (Object)local);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown value for %s: %s", this.statement.getSetStatement().getPropertyName(), value));
        }
        Matcher invalidMatcher = this.statement.getPattern().matcher(sql);
        int n = valueGroup = this.supportsLocal ? 2 : 1;
        if (invalidMatcher.find() && invalidMatcher.groupCount() == valueGroup) {
            String invalidValue = invalidMatcher.group(valueGroup);
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown value for %s: %s", this.statement.getSetStatement().getPropertyName(), invalidValue));
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown statement: %s", sql));
    }
}

