/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.LocalConnectionChecker;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@InternalApi
public class ConnectionOptions {
    public static String ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY = "spanner.enable_transactional_connection_state_for_postgresql";
    private static final LocalConnectionChecker LOCAL_CONNECTION_CHECKER = new LocalConnectionChecker();
    static final boolean DEFAULT_USE_PLAIN_TEXT = false;
    static final boolean DEFAULT_AUTOCOMMIT = true;
    static final boolean DEFAULT_READONLY = false;
    static final boolean DEFAULT_RETRY_ABORTS_INTERNALLY = true;
    static final boolean DEFAULT_USE_VIRTUAL_THREADS = false;
    static final boolean DEFAULT_USE_VIRTUAL_GRPC_TRANSPORT_THREADS = false;
    static final String DEFAULT_CREDENTIALS = null;
    static final String DEFAULT_CLIENT_CERTIFICATE = null;
    static final String DEFAULT_CLIENT_KEY = null;
    static final String DEFAULT_OAUTH_TOKEN = null;
    static final Integer DEFAULT_MIN_SESSIONS = null;
    static final Integer DEFAULT_MAX_SESSIONS = null;
    static final Integer DEFAULT_NUM_CHANNELS = null;
    static final String DEFAULT_ENDPOINT = null;
    static final String DEFAULT_CHANNEL_PROVIDER = null;
    static final String DEFAULT_DATABASE_ROLE = null;
    static final String DEFAULT_USER_AGENT = null;
    static final String DEFAULT_OPTIMIZER_VERSION = "";
    static final String DEFAULT_OPTIMIZER_STATISTICS_PACKAGE = "";
    static final Options.RpcPriority DEFAULT_RPC_PRIORITY = null;
    static final DdlInTransactionMode DEFAULT_DDL_IN_TRANSACTION_MODE = DdlInTransactionMode.ALLOW_IN_EMPTY_TRANSACTION;
    static final String DEFAULT_DEFAULT_SEQUENCE_KIND = null;
    static final boolean DEFAULT_RETURN_COMMIT_STATS = false;
    static final boolean DEFAULT_LENIENT = false;
    static final boolean DEFAULT_ROUTE_TO_LEADER = true;
    static final boolean DEFAULT_DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE = false;
    static final boolean DEFAULT_KEEP_TRANSACTION_ALIVE = false;
    static final boolean DEFAULT_TRACK_SESSION_LEAKS = true;
    static final boolean DEFAULT_TRACK_CONNECTION_LEAKS = true;
    static final boolean DEFAULT_DATA_BOOST_ENABLED = false;
    static final boolean DEFAULT_AUTO_PARTITION_MODE = false;
    static final int DEFAULT_MAX_PARTITIONS = 0;
    static final int DEFAULT_MAX_PARTITIONED_PARALLELISM = 1;
    static final Boolean DEFAULT_ENABLE_EXTENDED_TRACING = null;
    static final Boolean DEFAULT_ENABLE_API_TRACING = null;
    static final boolean DEFAULT_ENABLE_END_TO_END_TRACING = false;
    static final boolean DEFAULT_AUTO_BATCH_DML = false;
    static final long DEFAULT_AUTO_BATCH_DML_UPDATE_COUNT = 1L;
    static final boolean DEFAULT_AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION = true;
    private static final String PLAIN_TEXT_PROTOCOL = "http:";
    private static final String HOST_PROTOCOL = "https:";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String SPANNER_EMULATOR_HOST_ENV_VAR = "SPANNER_EMULATOR_HOST";
    private static final String DEFAULT_EMULATOR_HOST = "http://localhost:9010";
    static final String USE_PLAIN_TEXT_PROPERTY_NAME = "usePlainText";
    static final String CLIENT_CERTIFICATE_PROPERTY_NAME = "clientCertificate";
    static final String CLIENT_KEY_PROPERTY_NAME = "clientKey";
    public static final String AUTOCOMMIT_PROPERTY_NAME = "autocommit";
    public static final String READONLY_PROPERTY_NAME = "readonly";
    public static final String ROUTE_TO_LEADER_PROPERTY_NAME = "routeToLeader";
    public static final String RETRY_ABORTS_INTERNALLY_PROPERTY_NAME = "retryAbortsInternally";
    public static final String USE_VIRTUAL_THREADS_PROPERTY_NAME = "useVirtualThreads";
    public static final String USE_VIRTUAL_GRPC_TRANSPORT_THREADS_PROPERTY_NAME = "useVirtualGrpcTransportThreads";
    public static final String CREDENTIALS_PROPERTY_NAME = "credentials";
    public static final String ENCODED_CREDENTIALS_PROPERTY_NAME = "encodedCredentials";
    public static final String ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY = "ENABLE_ENCODED_CREDENTIALS";
    public static final String CREDENTIALS_PROVIDER_PROPERTY_NAME = "credentialsProvider";
    public static final String ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CREDENTIALS_PROVIDER";
    public static final String OAUTH_TOKEN_PROPERTY_NAME = "oauthToken";
    public static final String MIN_SESSIONS_PROPERTY_NAME = "minSessions";
    public static final String MAX_SESSIONS_PROPERTY_NAME = "maxSessions";
    public static final String NUM_CHANNELS_PROPERTY_NAME = "numChannels";
    public static final String ENDPOINT_PROPERTY_NAME = "endpoint";
    public static final String CHANNEL_PROVIDER_PROPERTY_NAME = "channelProvider";
    public static final String ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CHANNEL_PROVIDER";
    static final String USER_AGENT_PROPERTY_NAME = "userAgent";
    static final String OPTIMIZER_VERSION_PROPERTY_NAME = "optimizerVersion";
    static final String OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME = "optimizerStatisticsPackage";
    public static final String LENIENT_PROPERTY_NAME = "lenient";
    public static final String RPC_PRIORITY_NAME = "rpcPriority";
    public static final String DDL_IN_TRANSACTION_MODE_PROPERTY_NAME = "ddlInTransactionMode";
    public static final String DEFAULT_SEQUENCE_KIND_PROPERTY_NAME = "defaultSequenceKind";
    static final String DIALECT_PROPERTY_NAME = "dialect";
    public static final String DATABASE_ROLE_PROPERTY_NAME = "databaseRole";
    public static final String DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE_NAME = "delayTransactionStartUntilFirstWrite";
    public static final String KEEP_TRANSACTION_ALIVE_PROPERTY_NAME = "keepTransactionAlive";
    public static final String TRACK_SESSION_LEAKS_PROPERTY_NAME = "trackSessionLeaks";
    public static final String TRACK_CONNECTION_LEAKS_PROPERTY_NAME = "trackConnectionLeaks";
    public static final String DATA_BOOST_ENABLED_PROPERTY_NAME = "dataBoostEnabled";
    public static final String AUTO_PARTITION_MODE_PROPERTY_NAME = "autoPartitionMode";
    public static final String MAX_PARTITIONS_PROPERTY_NAME = "maxPartitions";
    public static final String MAX_PARTITIONED_PARALLELISM_PROPERTY_NAME = "maxPartitionedParallelism";
    public static final String ENABLE_EXTENDED_TRACING_PROPERTY_NAME = "enableExtendedTracing";
    public static final String ENABLE_API_TRACING_PROPERTY_NAME = "enableApiTracing";
    public static final String ENABLE_END_TO_END_TRACING_PROPERTY_NAME = "enableEndToEndTracing";
    public static final String AUTO_BATCH_DML_PROPERTY_NAME = "auto_batch_dml";
    public static final String AUTO_BATCH_DML_UPDATE_COUNT_PROPERTY_NAME = "auto_batch_dml_update_count";
    public static final String AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION_PROPERTY_NAME = "auto_batch_dml_update_count_verification";
    private static final String GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE = "%s can only be used if the system property %s has been set to true. Start the application with the JVM command line option -D%s=true";
    @Deprecated
    public static final Set<ConnectionProperty> VALID_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(ConnectionProperty.access$000("autocommit", "Should the connection start in autocommit (true/false)", true), ConnectionProperty.access$000("readonly", "Should the connection start in read-only mode (true/false)", false), ConnectionProperty.access$000("routeToLeader", "Should read/write transactions and partitioned DML be routed to leader region (true/false)", true), ConnectionProperty.access$000("retryAbortsInternally", "Should the connection automatically retry Aborted errors (true/false)", true), ConnectionProperty.access$000("useVirtualThreads", "Use a virtual thread instead of a platform thread for each connection (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false), ConnectionProperty.access$000("useVirtualGrpcTransportThreads", "Use a virtual thread instead of a platform thread for the gRPC executor (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false), ConnectionProperty.access$100("credentials", "The location of the credentials file to use for this connection. If neither this property or encoded credentials are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("encodedCredentials", "Base64-encoded credentials to use for this connection. If neither this property or a credentials location are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("credentialsProvider", "The class name of the com.google.api.gax.core.CredentialsProvider implementation that should be used to obtain credentials for connections."), ConnectionProperty.access$100("oauthToken", "A valid pre-existing OAuth token to use for authentication for this connection. Setting this property will take precedence over any value set for a credentials file."), ConnectionProperty.access$100("minSessions", "The minimum number of sessions in the backing session pool. The default is 100."), ConnectionProperty.access$100("maxSessions", "The maximum number of sessions in the backing session pool. The default is 400."), ConnectionProperty.access$100("numChannels", "The number of gRPC channels to use to communicate with Cloud Spanner. The default is 4."), ConnectionProperty.access$100("endpoint", "The endpoint that the JDBC driver should connect to. The default is the default Spanner production endpoint when autoConfigEmulator=false, and the default Spanner emulator endpoint (localhost:9010) when autoConfigEmulator=true. This property takes precedence over any host name at the start of the connection URL."), ConnectionProperty.access$100("channelProvider", "The name of the channel provider class. The name must reference an implementation of ExternalChannelProvider. If this property is not set, the connection will use the default grpc channel provider."), ConnectionProperty.access$000("usePlainText", "Use a plain text communication channel (i.e. non-TLS) for communicating with the server (true/false). Set this value to true for communication with the Cloud Spanner emulator.", false), ConnectionProperty.access$100("clientCertificate", "Specifies the file path to the client certificate required for establishing an mTLS connection."), ConnectionProperty.access$100("clientKey", "Specifies the file path to the client private key required for establishing an mTLS connection."), ConnectionProperty.access$100("userAgent", "The custom user-agent property name to use when communicating with Cloud Spanner. This property is intended for internal library usage, and should not be set by applications."), ConnectionProperty.access$100("optimizerVersion", "Sets the default query optimizer version to use for this connection."), ConnectionProperty.access$100("optimizerStatisticsPackage", ""), ConnectionProperty.access$000("returnCommitStats", "", false), ConnectionProperty.access$100("maxCommitDelay", "The maximum commit delay in milliseconds that should be applied to commit requests from this connection."), ConnectionProperty.access$000("autoConfigEmulator", "Automatically configure the connection to try to connect to the Cloud Spanner emulator (true/false). The instance and database in the connection string will automatically be created if these do not yet exist on the emulator. Add dialect=postgresql to the connection string to make sure that the database that is created uses the PostgreSQL dialect.", false), ConnectionProperty.access$000("useAutoSavepointsForEmulator", "Automatically creates savepoints for each statement in a read/write transaction when using the Emulator. This is no longer needed when using Emulator version 1.5.23 or higher.", false), ConnectionProperty.access$000("lenient", "Silently ignore unknown properties in the connection string/properties (true/false)", false), ConnectionProperty.access$100("rpcPriority", "Sets the priority for all RPC invocations from this connection (HIGH/MEDIUM/LOW). The default is HIGH."), ConnectionProperty.access$100("ddlInTransactionMode", "Sets the behavior of a connection when a DDL statement is executed in a read/write transaction. The default is " + (Object)((Object)DEFAULT_DDL_IN_TRANSACTION_MODE) + "."), ConnectionProperty.access$100("dialect", "Sets the dialect to use for new databases that are created by this connection."), ConnectionProperty.access$100("databaseRole", "Sets the database role to use for this connection. The default is privileges assigned to IAM role"), ConnectionProperty.access$000("delayTransactionStartUntilFirstWrite", "Enabling this option will delay the actual start of a read/write transaction until the first write operation is seen in that transaction. All reads that happen before the first write in a transaction will instead be executed as if the connection was in auto-commit mode. Enabling this option will make read/write transactions lose their SERIALIZABLE isolation level. Read operations that are executed after the first write operation in a read/write transaction will be executed using the read/write transaction. Enabling this mode can reduce locking and improve performance for applications that can handle the lower transaction isolation semantics.", false), ConnectionProperty.access$000("keepTransactionAlive", "Enabling this option will trigger the connection to keep read/write transactions alive by executing a SELECT 1 query once every 10 seconds if no other statements are being executed. This option should be used with caution, as it can keep transactions alive and hold on to locks longer than intended. This option should typically be used for CLI-type application that might wait for user input for a longer period of time.", false), ConnectionProperty.access$000("trackSessionLeaks", "Capture the call stack of the thread that checked out a session of the session pool. This will pre-create a LeakedSessionException already when a session is checked out. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedSessionException will only be created when an actual session leak is detected. The stack trace of the exception will in that case not contain the call stack of when the session was checked out.", true), ConnectionProperty.access$000("trackConnectionLeaks", "Capture the call stack of the thread that created a connection. This will pre-create a LeakedConnectionException already when a connection is created. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedConnectionException will only be created when an actual connection leak is detected. The stack trace of the exception will in that case not contain the call stack of when the connection was created.", true), ConnectionProperty.access$000("dataBoostEnabled", "Enable data boost for all partitioned queries that are executed by this connection. This setting is only used for partitioned queries and is ignored by all other statements.", false), ConnectionProperty.access$000("autoPartitionMode", "Execute all queries on this connection as partitioned queries. Executing a query that cannot be partitioned will fail. Executing a query in a read/write transaction will also fail.", false), ConnectionProperty.access$200("maxPartitions", "The max partitions hint value to use for partitioned queries. Use 0 if you do not want to specify a hint.", 0), ConnectionProperty.access$200("maxPartitionedParallelism", "The maximum number of partitions that will be executed in parallel for partitioned queries on this connection. Set this value to 0 to dynamically use the number of processors available in the runtime.", 1), ConnectionProperty.access$000("enableExtendedTracing", "Include the SQL string in the OpenTelemetry traces that are generated by this connection. The SQL string is added as the standard OpenTelemetry attribute 'db.statement'.", DEFAULT_ENABLE_EXTENDED_TRACING), ConnectionProperty.access$000("enableApiTracing", "Add OpenTelemetry traces for each individual RPC call. Enable this to get a detailed view of each RPC that is being executed by your application, or if you want to debug potential latency problems caused by RPCs that are being retried.", DEFAULT_ENABLE_API_TRACING), ConnectionProperty.access$000("enableEndToEndTracing", "Enable end-to-end tracing (true/false) to generate traces for both the time that is spent in the client, as well as time that is spent in the Spanner server. Server side traces can only go to Google Cloud Trace, so to see end to end traces, the application should configure an exporter that exports the traces to Google Cloud Trace.", false))));
    private static final Set<ConnectionProperty> INTERNAL_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Collections.singletonList(ConnectionProperty.access$100("userAgent", ""))));
    private static final Set<ConnectionProperty> INTERNAL_VALID_PROPERTIES = Sets.union(VALID_PROPERTIES, INTERNAL_PROPERTIES);
    private final ConnectionState initialConnectionState;
    private final String uri;
    private final String warnings;
    private final Credentials fixedCredentials;
    private final String host;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;
    private final StatementExecutor.StatementExecutorType statementExecutorType;
    private final SessionPoolOptions sessionPoolOptions;
    private final OpenTelemetry openTelemetry;
    private final List<StatementExecutionInterceptor> statementExecutionInterceptors;
    private final SpannerOptionsConfigurator configurator;

    private static String generateGuardedConnectionPropertyError(String systemPropertyName, String connectionPropertyName) {
        return String.format(GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE, connectionPropertyName, systemPropertyName, systemPropertyName);
    }

    static boolean isEnableTransactionalConnectionStateForPostgreSQL() {
        return Boolean.parseBoolean(System.getProperty(ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY, "false"));
    }

    public static String getDefaultProjectId(Credentials credentials) {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && credentials != null && credentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)credentials).getProjectId();
        }
        return projectId;
    }

    public static void closeSpanner() {
        SpannerPool.INSTANCE.checkAndCloseSpanners();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConnectionOptions(Builder builder) {
        Matcher matcher;
        boolean isExternalHost = false;
        if (builder.isValidExternalHostUri(builder.uri)) {
            matcher = Builder.EXTERNAL_HOST_PATTERN.matcher(builder.uri);
            isExternalHost = true;
        } else {
            matcher = Builder.SPANNER_URI_PATTERN.matcher(builder.uri);
        }
        Preconditions.checkArgument((boolean)matcher.find(), (Object)String.format("Invalid connection URI specified: %s", builder.uri));
        ImmutableMap connectionPropertyValues = ImmutableMap.builder().putAll(ConnectionProperties.parseValues(builder.uri)).putAll(builder.connectionPropertyValues).buildKeepingLast();
        this.uri = builder.uri;
        ConnectionPropertyValue value = ConnectionPropertyValue.cast((ConnectionPropertyValue)connectionPropertyValues.get((Object)ConnectionProperties.LENIENT.getKey()));
        this.warnings = ConnectionOptions.checkValidProperties(value != null && (Boolean)value.getValue() != false, this.uri);
        this.fixedCredentials = builder.credentials;
        this.statementExecutorType = builder.statementExecutorType;
        this.openTelemetry = builder.openTelemetry;
        this.statementExecutionInterceptors = Collections.unmodifiableList(builder.statementExecutionInterceptors);
        this.configurator = builder.configurator;
        this.initialConnectionState = new ConnectionState((Map<String, ConnectionPropertyValue<?>>)connectionPropertyValues);
        Preconditions.checkArgument((Stream.of(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL), this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS), this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER), this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN)).filter(Objects::nonNull).count() <= 1L ? 1 : 0) != 0, (Object)"Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token");
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS), ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY, ENCODED_CREDENTIALS_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) == null ? null : this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER).getClass().getName(), ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY, CREDENTIALS_PROVIDER_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.CHANNEL_PROVIDER), ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY, CHANNEL_PROVIDER_PROPERTY_NAME);
        boolean usePlainText = this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR) != false || this.getInitialConnectionPropertyValue(ConnectionProperties.USE_PLAIN_TEXT) != false;
        this.host = ConnectionOptions.determineHost(matcher, this.getInitialConnectionPropertyValue(ConnectionProperties.ENDPOINT), this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR), usePlainText, System.getenv());
        GoogleCredentials defaultExternalHostCredentials = SpannerOptions.getDefaultExternalHostCredentialsFromSysEnv();
        if (this.fixedCredentials == null && this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN) == null && usePlainText) {
            this.credentials = NoCredentials.getInstance();
        } else if (this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN) != null) {
            this.credentials = new GoogleCredentials(new AccessToken(this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN), null));
        } else if (isExternalHost && defaultExternalHostCredentials != null) {
            this.credentials = defaultExternalHostCredentials;
        } else if (this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) != null) {
            try {
                this.credentials = this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER).getCredentials();
            }
            catch (IOException exception) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to get credentials from CredentialsProvider: " + exception.getMessage(), exception);
            }
        } else {
            this.credentials = this.fixedCredentials != null ? this.fixedCredentials : (this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS) != null ? this.getCredentialsService().decodeCredentials(this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS)) : this.getCredentialsService().createCredentials(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL)));
        }
        if (this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS) != null || this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS) != null || !this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_SESSION_LEAKS).booleanValue()) {
            SessionPoolOptions.Builder sessionPoolOptionsBuilder = builder.sessionPoolOptions == null ? SessionPoolOptions.newBuilder() : builder.sessionPoolOptions.toBuilder();
            sessionPoolOptionsBuilder.setTrackStackTraceOfSessionCheckout(this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_SESSION_LEAKS));
            sessionPoolOptionsBuilder.setAutoDetectDialect(true);
            if (this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS) != null) {
                sessionPoolOptionsBuilder.setMinSessions(this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS));
            }
            if (this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS) != null) {
                sessionPoolOptionsBuilder.setMaxSessions(this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS));
            }
            this.sessionPoolOptions = sessionPoolOptionsBuilder.build();
        } else {
            this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build();
        }
        String projectId = "default";
        String instanceId = matcher.group("INSTANCEGROUP");
        if (!isExternalHost) {
            projectId = matcher.group("PROJECTGROUP");
        } else if (instanceId == null) {
            instanceId = "default";
        }
        if ("DEFAULT_PROJECT_ID".equalsIgnoreCase(projectId)) {
            projectId = ConnectionOptions.getDefaultProjectId(this.credentials);
        }
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.databaseName = matcher.group("DATABASEGROUP");
    }

    @VisibleForTesting
    static String determineHost(Matcher matcher, String endpoint, boolean autoConfigEmulator, boolean usePlainText, Map<String, String> environment) {
        String host;
        if (Objects.equals(endpoint, DEFAULT_ENDPOINT) && matcher.group("HOSTGROUP") == null) {
            if (autoConfigEmulator) {
                if (Strings.isNullOrEmpty((String)environment.get(SPANNER_EMULATOR_HOST_ENV_VAR))) {
                    return DEFAULT_EMULATOR_HOST;
                }
                return "http://" + environment.get(SPANNER_EMULATOR_HOST_ENV_VAR);
            }
            return DEFAULT_HOST;
        }
        if (!Objects.equals(endpoint, DEFAULT_ENDPOINT)) {
            host = "//" + endpoint;
        } else {
            host = matcher.group("HOSTGROUP");
            if ("(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?".equals(matcher.pattern().pattern()) && !host.matches(".*:\\d+$")) {
                host = String.format("%s:15000", host);
            }
        }
        if (usePlainText) {
            return PLAIN_TEXT_PROTOCOL + host;
        }
        return HOST_PROTOCOL + host;
    }

    OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    SpannerOptionsConfigurator getConfigurator() {
        return this.configurator;
    }

    @VisibleForTesting
    CredentialsService getCredentialsService() {
        return CredentialsService.INSTANCE;
    }

    private static void checkGuardedProperty(String value, String systemPropertyName, String connectionPropertyName) {
        if (!Strings.isNullOrEmpty((String)value) && !Boolean.parseBoolean(System.getProperty(systemPropertyName))) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, ConnectionOptions.generateGuardedConnectionPropertyError(systemPropertyName, connectionPropertyName));
        }
    }

    @VisibleForTesting
    static String parseUriProperty(String uri, String property) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    @VisibleForTesting
    static String checkValidProperties(boolean lenient, String uri) {
        StringBuilder invalidProperties = new StringBuilder();
        List<String> properties = ConnectionOptions.parseProperties(uri);
        for (String property : properties) {
            if (ConnectionProperties.CONNECTION_PROPERTIES.containsKey((Object)property.toLowerCase(Locale.ENGLISH))) continue;
            if (invalidProperties.length() > 0) {
                invalidProperties.append(", ");
            }
            invalidProperties.append(property);
        }
        if (lenient) {
            return String.format("Invalid properties found in connection URI: %s", invalidProperties);
        }
        Preconditions.checkArgument((invalidProperties.length() == 0 ? 1 : 0) != 0, (Object)String.format("Invalid properties found in connection URI. Add lenient=true to the connection string to ignore unknown properties. Invalid properties: %s", invalidProperties));
        return null;
    }

    @VisibleForTesting
    static List<String> parseProperties(String uri) {
        Pattern pattern = Pattern.compile("(?is)(?:\\?|;)(?<PROPERTY>.*?)=(?:.*?)");
        Matcher matcher = pattern.matcher(uri);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find() && matcher.group("PROPERTY") != null) {
            res.add(matcher.group("PROPERTY"));
        }
        return res;
    }

    static long tryParseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public Connection getConnection() {
        LOCAL_CONNECTION_CHECKER.checkLocalConnection(this);
        return new ConnectionImpl(this);
    }

    public String getUri() {
        return this.uri;
    }

    Map<String, ConnectionPropertyValue<?>> getInitialConnectionPropertyValues() {
        return this.initialConnectionState.getAllValues();
    }

    <T> T getInitialConnectionPropertyValue(com.google.cloud.spanner.connection.ConnectionProperty<T> property) {
        return this.initialConnectionState.getValue(property).getValue();
    }

    public String getCredentialsUrl() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL);
    }

    String getOAuthToken() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN);
    }

    Credentials getFixedCredentials() {
        return this.fixedCredentials;
    }

    CredentialsProvider getCredentialsProvider() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER);
    }

    StatementExecutor.StatementExecutorType getStatementExecutorType() {
        return this.statementExecutorType;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Integer getMinSessions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS);
    }

    public Integer getMaxSessions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS);
    }

    public Integer getNumChannels() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.NUM_CHANNELS);
    }

    public TransportChannelProvider getChannelProvider() {
        String channelProvider = this.getInitialConnectionPropertyValue(ConnectionProperties.CHANNEL_PROVIDER);
        if (channelProvider == null) {
            return null;
        }
        try {
            URL url = new URL(this.host);
            ExternalChannelProvider provider = (ExternalChannelProvider)ExternalChannelProvider.class.cast(Class.forName(channelProvider).newInstance());
            return provider.getChannelProvider(url.getHost(), url.getPort());
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("%s : Failed to create channel with external provider: %s", e.toString(), channelProvider));
        }
    }

    public String getDatabaseRole() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DATABASE_ROLE);
    }

    public String getHost() {
        return this.host;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project ID is not specified");
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance ID is not specified");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"Database name is not specified");
        return DatabaseId.of(this.projectId, this.instanceId, this.databaseName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAutocommit() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT);
    }

    public boolean isReadOnly() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.READONLY);
    }

    public boolean isRouteToLeader() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ROUTE_TO_LEADER);
    }

    public boolean isEndToEndTracingEnabled() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_END_TO_END_TRACING);
    }

    public boolean isRetryAbortsInternally() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY);
    }

    public boolean isUseVirtualThreads() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_VIRTUAL_THREADS);
    }

    public boolean isUseVirtualGrpcTransportThreads() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_VIRTUAL_GRPC_TRANSPORT_THREADS);
    }

    @Nullable
    public String getWarnings() {
        return this.warnings;
    }

    boolean isUsePlainText() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR) != false || this.getInitialConnectionPropertyValue(ConnectionProperties.USE_PLAIN_TEXT) != false;
    }

    String getClientCertificate() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CLIENT_CERTIFICATE);
    }

    String getClientCertificateKey() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CLIENT_KEY);
    }

    String getUserAgent() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USER_AGENT);
    }

    public boolean isReturnCommitStats() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.RETURN_COMMIT_STATS);
    }

    public Duration getMaxCommitDelay() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_COMMIT_DELAY);
    }

    boolean usesEmulator() {
        return (Boolean)Suppliers.memoize(() -> this.isAutoConfigEmulator() || !Strings.isNullOrEmpty((String)System.getenv(SPANNER_EMULATOR_HOST_ENV_VAR))).get();
    }

    public boolean isAutoConfigEmulator() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR);
    }

    boolean useAutoSavepointsForEmulator() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_AUTO_SAVEPOINTS_FOR_EMULATOR);
    }

    public Dialect getDialect() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DIALECT);
    }

    boolean isTrackConnectionLeaks() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_CONNECTION_LEAKS);
    }

    boolean isDataBoostEnabled() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DATA_BOOST_ENABLED);
    }

    boolean isAutoPartitionMode() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_PARTITION_MODE);
    }

    int getMaxPartitions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONS);
    }

    int getMaxPartitionedParallelism() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONED_PARALLELISM);
    }

    Boolean isEnableExtendedTracing() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_EXTENDED_TRACING);
    }

    Boolean isEnableApiTracing() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_API_TRACING);
    }

    List<StatementExecutionInterceptor> getStatementExecutionInterceptors() {
        return this.statementExecutionInterceptors;
    }

    public String toString() {
        return this.getUri();
    }

    public static class Builder {
        private final Map<String, ConnectionPropertyValue<?>> connectionPropertyValues = new HashMap();
        private String uri;
        private Credentials credentials;
        private StatementExecutor.StatementExecutorType statementExecutorType;
        private SessionPoolOptions sessionPoolOptions;
        private List<StatementExecutionInterceptor> statementExecutionInterceptors = Collections.emptyList();
        private SpannerOptionsConfigurator configurator;
        private OpenTelemetry openTelemetry;
        public static final String SPANNER_URI_FORMAT = "(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
        public static final String EXTERNAL_HOST_FORMAT = "(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?";
        private static final String SPANNER_URI_REGEX = "(?is)^(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$";
        @VisibleForTesting
        static final Pattern SPANNER_URI_PATTERN = Pattern.compile("(?is)^(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$");
        @VisibleForTesting
        static final Pattern EXTERNAL_HOST_PATTERN = Pattern.compile("(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?");
        private static final String HOST_GROUP = "HOSTGROUP";
        private static final String PROJECT_GROUP = "PROJECTGROUP";
        private static final String INSTANCE_GROUP = "INSTANCEGROUP";
        private static final String DATABASE_GROUP = "DATABASEGROUP";
        private static final String DEFAULT_PROJECT_ID_PLACEHOLDER = "DEFAULT_PROJECT_ID";

        private Builder() {
        }

        private boolean isValidUri(String uri) {
            return SPANNER_URI_PATTERN.matcher(uri).matches();
        }

        private boolean isValidExternalHostUri(String uri) {
            return EXTERNAL_HOST_PATTERN.matcher(uri).matches();
        }

        public Builder setUri(String uri) {
            ConnectionPropertyValue value;
            if (!this.isValidExternalHostUri(uri)) {
                Preconditions.checkArgument((boolean)this.isValidUri(uri), (Object)"The specified URI is not a valid Cloud Spanner connection URI. Please specify a URI in the format \"cloudspanner:[//host[:port]]/projects/project-id[/instances/instance-id[/databases/database-name]][\\?property-name=property-value[;property-name=property-value]*]?\"");
            }
            ConnectionOptions.checkValidProperties((value = ConnectionPropertyValue.cast((ConnectionPropertyValue)ConnectionProperties.parseValues(uri).get((Object)ConnectionProperties.LENIENT.getKey()))) != null && (Boolean)value.getValue() != false, uri);
            this.uri = uri;
            return this;
        }

        <T> Builder setConnectionPropertyValue(com.google.cloud.spanner.connection.ConnectionProperty<T> property, T value) {
            this.connectionPropertyValues.put(property.getKey(), new ConnectionPropertyValue<T>(property, value, value));
            return this;
        }

        public Builder setSessionPoolOptions(SessionPoolOptions sessionPoolOptions) {
            Preconditions.checkNotNull((Object)sessionPoolOptions);
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setCredentialsUrl(String credentialsUrl) {
            this.setConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL, credentialsUrl);
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.setConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN, oauthToken);
            return this;
        }

        @VisibleForTesting
        Builder setStatementExecutionInterceptors(List<StatementExecutionInterceptor> interceptors) {
            this.statementExecutionInterceptors = interceptors;
            return this;
        }

        @VisibleForTesting
        Builder setConfigurator(SpannerOptionsConfigurator configurator) {
            this.configurator = (SpannerOptionsConfigurator)Preconditions.checkNotNull((Object)configurator);
            return this;
        }

        @VisibleForTesting
        Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        Builder setStatementExecutorType(StatementExecutor.StatementExecutorType statementExecutorType) {
            this.statementExecutorType = statementExecutorType;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public Builder setTracingPrefix(String tracingPrefix) {
            this.setConnectionPropertyValue(ConnectionProperties.TRACING_PREFIX, tracingPrefix);
            return this;
        }

        public ConnectionOptions build() {
            Preconditions.checkState((this.uri != null ? 1 : 0) != 0, (Object)"Connection URI is required");
            return new ConnectionOptions(this);
        }
    }

    @VisibleForTesting
    static interface SpannerOptionsConfigurator {
        public void configure(SpannerOptions.Builder var1);
    }

    public static interface ExternalChannelProvider {
        public TransportChannelProvider getChannelProvider(String var1, int var2);
    }

    @Deprecated
    public static class ConnectionProperty {
        private static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
        private final String name;
        private final String description;
        private final String defaultValue;
        private final String[] validValues;
        private final int hashCode;

        private static ConnectionProperty createStringProperty(String name, String description) {
            return new ConnectionProperty(name, description, "", null);
        }

        private static ConnectionProperty createBooleanProperty(String name, String description, Boolean defaultValue) {
            return new ConnectionProperty(name, description, defaultValue == null ? "" : String.valueOf(defaultValue), BOOLEAN_VALUES);
        }

        private static ConnectionProperty createIntProperty(String name, String description, int defaultValue) {
            return new ConnectionProperty(name, description, String.valueOf(defaultValue), null);
        }

        private static ConnectionProperty createEmptyProperty(String name) {
            return new ConnectionProperty(name, "", "", null);
        }

        private ConnectionProperty(String name, String description, String defaultValue, String[] validValues) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)description);
            Preconditions.checkNotNull((Object)defaultValue);
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
            this.validValues = validValues;
            this.hashCode = name.toLowerCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionProperty)) {
                return false;
            }
            return ((ConnectionProperty)o).name.equalsIgnoreCase(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getValidValues() {
            return this.validValues;
        }

        static /* synthetic */ ConnectionProperty access$000(String x0, String x1, Boolean x2) {
            return ConnectionProperty.createBooleanProperty(x0, x1, x2);
        }

        static /* synthetic */ ConnectionProperty access$100(String x0, String x1) {
            return ConnectionProperty.createStringProperty(x0, x1);
        }

        static /* synthetic */ ConnectionProperty access$200(String x0, String x1, int x2) {
            return ConnectionProperty.createIntProperty(x0, x1, x2);
        }
    }
}

