/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncRunnerImpl;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ErrorHandler;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionedDmlTransaction;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.RetryOnDifferentGrpcChannelErrorHandler;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BatchWriteRequest;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class SessionImpl
implements Session {
    private final TraceWrapper tracer;
    static final ThreadLocal<Boolean> hasPendingTransaction = ThreadLocal.withInitial(() -> false);
    private static final Map<SpannerRpc.Option, ?>[] CHANNEL_HINT_OPTIONS = new Map[256];
    static final int NO_CHANNEL_HINT = -1;
    private final SpannerImpl spanner;
    private final SessionReference sessionReference;
    private SessionTransaction activeTransaction;
    private ISpan currentSpan;
    private final Clock clock;
    private final Map<SpannerRpc.Option, ?> options;
    private final ErrorHandler errorHandler;

    static void throwIfTransactionsPending() {
        if (hasPendingTransaction.get() == Boolean.TRUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Nested transactions are not supported");
        }
    }

    static TransactionOptions createReadWriteTransactionOptions(Options options, ByteString previousTransactionId) {
        TransactionOptions.Builder transactionOptions = TransactionOptions.newBuilder();
        if (options.withExcludeTxnFromChangeStreams() == Boolean.TRUE) {
            transactionOptions.setExcludeTxnFromChangeStreams(true);
        }
        TransactionOptions.ReadWrite.Builder readWrite = TransactionOptions.ReadWrite.newBuilder();
        if (options.withOptimisticLock() == Boolean.TRUE) {
            readWrite.setReadLockMode(TransactionOptions.ReadWrite.ReadLockMode.OPTIMISTIC);
        }
        if (previousTransactionId != null && previousTransactionId != ByteString.EMPTY) {
            readWrite.setMultiplexedSessionPreviousTransactionId(previousTransactionId);
        }
        if (options.isolationLevel() != null) {
            transactionOptions.setIsolationLevel(options.isolationLevel());
        }
        transactionOptions.setReadWrite(readWrite);
        return transactionOptions.build();
    }

    SessionImpl(SpannerImpl spanner, SessionReference sessionReference) {
        this(spanner, sessionReference, -1);
    }

    SessionImpl(SpannerImpl spanner, SessionReference sessionReference, int channelHint) {
        this.spanner = spanner;
        this.tracer = spanner.getTracer();
        this.sessionReference = sessionReference;
        this.clock = ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getPoolMaintainerClock();
        this.options = SessionImpl.createOptions(sessionReference, channelHint);
        this.errorHandler = this.createErrorHandler((SpannerOptions)spanner.getOptions());
    }

    static Map<SpannerRpc.Option, ?> createOptions(SessionReference sessionReference, int channelHint) {
        if (channelHint == -1) {
            return sessionReference.getOptions();
        }
        return CHANNEL_HINT_OPTIONS[channelHint % CHANNEL_HINT_OPTIONS.length];
    }

    private ErrorHandler createErrorHandler(SpannerOptions options) {
        if (RetryOnDifferentGrpcChannelErrorHandler.isEnabled()) {
            return new RetryOnDifferentGrpcChannelErrorHandler(options.getNumChannels(), this);
        }
        return ErrorHandler.DefaultErrorHandler.INSTANCE;
    }

    @Override
    public String getName() {
        return this.sessionReference.getName();
    }

    Map<SpannerRpc.Option, ?> getOptions() {
        return this.options;
    }

    ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    void setCurrentSpan(ISpan span) {
        this.currentSpan = span;
    }

    ISpan getCurrentSpan() {
        return this.currentSpan;
    }

    Instant getLastUseTime() {
        return this.sessionReference.getLastUseTime();
    }

    Instant getCreateTime() {
        return this.sessionReference.getCreateTime();
    }

    boolean getIsMultiplexed() {
        return this.sessionReference.getIsMultiplexed();
    }

    SessionReference getSessionReference() {
        return this.sessionReference;
    }

    void markUsed(Instant instant) {
        this.sessionReference.markUsed(instant);
    }

    TransactionOptions defaultTransactionOptions() {
        return ((SpannerOptions)this.spanner.getOptions()).getDefaultTransactionOptions();
    }

    public DatabaseId getDatabaseId() {
        return this.sessionReference.getDatabaseId();
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        this.setActive(null);
        PartitionedDmlTransaction txn = new PartitionedDmlTransaction(this, this.spanner.getRpc(), Ticker.systemTicker());
        return txn.executeStreamingPartitionedUpdate(stmt, ((SpannerOptions)this.spanner.getOptions()).getPartitionedDmlTimeoutDuration(), options);
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        TransactionRunner runner = this.readWriteTransaction(options);
        Collection finalMutations = mutations instanceof Collection ? (Collection)mutations : Lists.newArrayList(mutations);
        runner.run(ctx -> {
            ctx.buffer(finalMutations);
            return null;
        });
        return runner.getCommitResponse();
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... transactionOptions) throws SpannerException {
        RequestOptions commitRequestOptions;
        this.setActive(null);
        ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
        Mutation.toProtoAndReturnRandomMutation(mutations, mutationsProto);
        Options options = Options.fromTransactionOptions(transactionOptions);
        CommitRequest.Builder requestBuilder = CommitRequest.newBuilder().setSession(this.getName()).setReturnCommitStats(options.withCommitStats()).addAllMutations(mutationsProto);
        TransactionOptions.Builder transactionOptionsBuilder = TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance());
        if (options.withExcludeTxnFromChangeStreams() == Boolean.TRUE) {
            transactionOptionsBuilder.setExcludeTxnFromChangeStreams(true);
        }
        if (options.isolationLevel() != null) {
            transactionOptionsBuilder.setIsolationLevel(options.isolationLevel());
        }
        requestBuilder.setSingleUseTransaction(this.defaultTransactionOptions().toBuilder().mergeFrom(transactionOptionsBuilder.build()));
        if (options.hasMaxCommitDelay()) {
            requestBuilder.setMaxCommitDelay(Duration.newBuilder().setSeconds(options.maxCommitDelay().getSeconds()).setNanos(options.maxCommitDelay().getNano()).build());
        }
        if ((commitRequestOptions = this.getRequestOptions(transactionOptions)) != null) {
            requestBuilder.setRequestOptions(commitRequestOptions);
        }
        CommitRequest request = requestBuilder.build();
        ISpan span = this.tracer.spanBuilder("CloudSpannerOperation.Commit");
        try {
            IScope s = this.tracer.withSpan(span);
            try {
                CommitResponse commitResponse = SpannerRetryHelper.runTxWithRetriesOnAborted(() -> new CommitResponse(this.spanner.getRpc().commit(request, this.getOptions())));
                if (s != null) {
                    s.close();
                }
                return commitResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    span.setStatus(e);
                    throw e;
                }
            }
        }
        finally {
            span.end();
        }
    }

    private RequestOptions getRequestOptions(Options.TransactionOption ... transactionOptions) {
        Options requestOptions = Options.fromTransactionOptions(transactionOptions);
        if (requestOptions.hasPriority() || requestOptions.hasTag()) {
            RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
            if (requestOptions.hasPriority()) {
                requestOptionsBuilder.setPriority(requestOptions.priority());
            }
            if (requestOptions.hasTag()) {
                requestOptionsBuilder.setTransactionTag(requestOptions.tag());
            }
            return requestOptionsBuilder.build();
        }
        return null;
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... transactionOptions) throws SpannerException {
        this.setActive(null);
        List<BatchWriteRequest.MutationGroup> mutationGroupsProto = MutationGroup.toListProto(mutationGroups);
        BatchWriteRequest.Builder requestBuilder = BatchWriteRequest.newBuilder().setSession(this.getName()).addAllMutationGroups(mutationGroupsProto);
        RequestOptions batchWriteRequestOptions = this.getRequestOptions(transactionOptions);
        if (batchWriteRequestOptions != null) {
            requestBuilder.setRequestOptions(batchWriteRequestOptions);
        }
        if (Options.fromTransactionOptions(transactionOptions).withExcludeTxnFromChangeStreams() == Boolean.TRUE) {
            requestBuilder.setExcludeTxnFromChangeStreams(true);
        }
        ISpan span = this.tracer.spanBuilder("CloudSpannerOperation.BatchWrite");
        try {
            IScope s = this.tracer.withSpan(span);
            try {
                ServerStream<BatchWriteResponse> serverStream = this.spanner.getRpc().batchWriteAtLeastOnce(requestBuilder.build(), this.getOptions());
                if (s != null) {
                    s.close();
                }
                return serverStream;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    span.setStatus(e);
                    throw SpannerExceptionFactory.newSpannerException(e);
                }
            }
        }
        finally {
            span.end();
            this.onTransactionDone();
        }
    }

    @Override
    public ReadContext singleUse() {
        return this.singleUse(TimestampBound.strong());
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleReadContext.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.getDatabaseId()))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setDefaultDecodeMode(this.spanner.getDefaultDecodeMode())).setDefaultDirectedReadOptions(((SpannerOptions)this.spanner.getOptions()).getDirectedReadOptions())).setSpan(this.currentSpan)).setTracer(this.tracer)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).setClock(this.clock)).build());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.singleUseReadOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.getDatabaseId()))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setDefaultDecodeMode(this.spanner.getDefaultDecodeMode())).setDefaultDirectedReadOptions(((SpannerOptions)this.spanner.getOptions()).getDirectedReadOptions())).setSpan(this.currentSpan)).setTracer(this.tracer)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).setClock(this.clock)).buildSingleUseReadOnlyTransaction());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.readOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)AbstractReadContext.MultiUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.getDatabaseId()))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setDefaultDecodeMode(this.spanner.getDefaultDecodeMode())).setDefaultDirectedReadOptions(((SpannerOptions)this.spanner.getOptions()).getDirectedReadOptions())).setSpan(this.currentSpan)).setTracer(this.tracer)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).setClock(this.clock)).build());
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        return this.setActive(new TransactionRunnerImpl(this, options));
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        return new AsyncRunnerImpl(this.setActive(new TransactionRunnerImpl(this, options)));
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        return new TransactionManagerImpl(this, this.currentSpan, this.tracer, options);
    }

    @Override
    public AsyncTransactionManagerImpl transactionManagerAsync(Options.TransactionOption ... options) {
        return new AsyncTransactionManagerImpl(this, this.currentSpan, options);
    }

    @Override
    public ApiFuture<Empty> asyncClose() {
        return this.spanner.getRpc().asyncDeleteSession(this.getName(), this.getOptions());
    }

    @Override
    public void close() {
        ISpan span = this.tracer.spanBuilder("CloudSpannerOperation.DeleteSession");
        try (IScope s = this.tracer.withSpan(span);){
            this.spanner.getRpc().deleteSession(this.getName(), this.getOptions());
        }
        catch (RuntimeException e) {
            span.setStatus(e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    ApiFuture<Transaction> beginTransactionAsync(Options transactionOptions, boolean routeToLeader, Map<SpannerRpc.Option, ?> channelHint, ByteString previousTransactionId, com.google.spanner.v1.Mutation mutation) {
        ApiFuture<Transaction> requestFuture;
        SettableApiFuture res = SettableApiFuture.create();
        ISpan span = this.tracer.spanBuilder("CloudSpannerOperation.BeginTransaction");
        BeginTransactionRequest.Builder requestBuilder = BeginTransactionRequest.newBuilder().setSession(this.getName()).setOptions(this.defaultTransactionOptions().toBuilder().mergeFrom(SessionImpl.createReadWriteTransactionOptions(transactionOptions, previousTransactionId)));
        if (this.sessionReference.getIsMultiplexed() && mutation != null) {
            requestBuilder.setMutationKey(mutation);
        }
        BeginTransactionRequest request = requestBuilder.build();
        try (IScope ignore = this.tracer.withSpan(span);){
            requestFuture = this.spanner.getRpc().beginTransactionAsync(request, channelHint, routeToLeader);
        }
        requestFuture.addListener(() -> {
            try (IScope ignore = this.tracer.withSpan(span);){
                Transaction txn = (Transaction)requestFuture.get();
                if (txn.getId().isEmpty()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + this.getName());
                }
                span.end();
                res.set((Object)txn);
            }
            catch (ExecutionException e) {
                span.setStatus(e);
                span.end();
                res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
            }
            catch (InterruptedException e) {
                span.setStatus(e);
                span.end();
                res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
            }
            catch (Exception e) {
                span.setStatus(e);
                span.end();
                res.setException((Throwable)e);
            }
        }, MoreExecutors.directExecutor());
        return res;
    }

    TransactionRunnerImpl.TransactionContextImpl newTransaction(Options options, ByteString previousTransactionId) {
        return ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this)).setOptions(options).setTransactionId(null).setPreviousTransactionId(previousTransactionId).setTrackTransactionStarter(((SpannerOptions)this.spanner.getOptions()).isTrackTransactionStarter()).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.getDatabaseId()))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setDefaultDecodeMode(this.spanner.getDefaultDecodeMode())).setSpan(this.currentSpan)).setTracer(this.tracer)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).setClock(this.clock).build();
    }

    SessionTransaction getActiveTransaction() {
        return this.activeTransaction;
    }

    <T extends SessionTransaction> T setActive(@Nullable T ctx) {
        SessionImpl.throwIfTransactionsPending();
        if (!this.getIsMultiplexed() && this.activeTransaction != null) {
            this.activeTransaction.invalidate();
        }
        this.activeTransaction = ctx;
        if (this.activeTransaction != null) {
            this.activeTransaction.setSpan(this.currentSpan);
        }
        return ctx;
    }

    void onError(SpannerException spannerException) {
    }

    void onReadDone() {
    }

    void onTransactionDone() {
    }

    TraceWrapper getTracer() {
        return this.tracer;
    }

    static {
        for (int i = 0; i < CHANNEL_HINT_OPTIONS.length; ++i) {
            SessionImpl.CHANNEL_HINT_OPTIONS[i] = SessionClient.optionMap(SessionClient.SessionOption.channelHint(i));
        }
    }

    static interface SessionTransaction {
        public void invalidate();

        public void setSpan(ISpan var1);

        public void close();
    }
}

