/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ProtobufResultSet;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.ReplaceableForwardingResultSet;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Value;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

@VisibleForTesting
class ChecksumResultSet
extends ReplaceableForwardingResultSet
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final AtomicLong numberOfNextCalls = new AtomicLong();
    private final AbstractStatementParser.ParsedStatement statement;
    private final AnalyzeMode analyzeMode;
    private final Options.QueryOption[] options;
    private final ChecksumCalculator checksumCalculator = new ChecksumCalculator();
    private final NextCallable nextCallable = new NextCallable();

    ChecksumResultSet(ReadWriteTransaction transaction, ProtobufResultSet delegate, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        super(delegate);
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull((Object)statement.getStatement());
        Preconditions.checkNotNull((Object)statement.getStatement().getSql());
        this.transaction = transaction;
        this.statement = statement;
        this.analyzeMode = analyzeMode;
        this.options = options;
    }

    @Override
    public Value getProtobufValue(int columnIndex) {
        return ((ProtobufResultSet)this.getDelegate()).getProtobufValue(columnIndex);
    }

    @Override
    public boolean next() {
        return this.transaction.runWithRetry(this.nextCallable);
    }

    @VisibleForTesting
    byte[] getChecksum() {
        return this.checksumCalculator.getChecksum();
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        long counter;
        ChecksumCalculator newChecksumCalculator = new ChecksumCalculator();
        ResultSet resultSet = null;
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            resultSet = DirectExecuteResultSet.ofResultSet(this.transaction.internalExecuteQuery(this.statement, this.analyzeMode, this.options));
            boolean next = true;
            for (counter = 0L; counter < this.numberOfNextCalls.get() && next; ++counter) {
                this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_NEXT_ON_RESULT_SET, this.transaction);
                next = resultSet.next();
                if (!next) continue;
                newChecksumCalculator.calculateNextChecksum((ProtobufResultSet)resultSet);
            }
        }
        catch (Throwable e) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (e instanceof SpannerException && !(e instanceof AbortedException)) {
                throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, (SpannerException)((Object)e));
            }
            throw e;
        }
        byte[] newChecksum = newChecksumCalculator.getChecksum();
        byte[] currentChecksum = this.checksumCalculator.getChecksum();
        if (counter == this.numberOfNextCalls.get() && Arrays.equals(newChecksum, currentChecksum)) {
            if (this.isClosed()) {
                resultSet.close();
            } else {
                this.replaceDelegate(resultSet);
            }
        } else {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
        }
    }

    private static final class ChecksumCalculator {
        private static final int MAX_BUFFER_SIZE = 0x100000;
        private boolean firstRow = true;
        private final MessageDigest digest;
        private ByteBuffer buffer;
        private ByteBuffer float64Buffer;

        ChecksumCalculator() {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (Throwable t) {
                throw SpannerExceptionFactory.asSpannerException(t);
            }
        }

        private byte[] getChecksum() {
            try {
                MessageDigest clone = (MessageDigest)this.digest.clone();
                return clone.digest();
            }
            catch (CloneNotSupportedException e) {
                throw SpannerExceptionFactory.asSpannerException(e);
            }
        }

        private void calculateNextChecksum(ProtobufResultSet resultSet) {
            if (this.firstRow) {
                for (Type.StructField field : resultSet.getType().getStructFields()) {
                    this.digest.update(field.getType().toString().getBytes(StandardCharsets.UTF_8));
                }
            }
            for (int col = 0; col < resultSet.getColumnCount(); ++col) {
                Type type = resultSet.getColumnType(col);
                if (!resultSet.canGetProtobufValue(col)) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Failed to get the underlying protobuf value for the column " + resultSet.getMetadata().getRowType().getFields(col).getName() + ". Executing queries with DecodeMode#DIRECT is not supported in read/write transactions.");
                }
                Value value = resultSet.getProtobufValue(col);
                this.digest.update((byte)value.getKindCase().getNumber());
                this.pushValue(type, value);
            }
            this.firstRow = false;
        }

        private void pushValue(Type type, Value value) {
            switch (value.getKindCase()) {
                case NULL_VALUE: {
                    break;
                }
                case BOOL_VALUE: {
                    this.digest.update(value.getBoolValue() ? (byte)1 : 0);
                    break;
                }
                case STRING_VALUE: {
                    this.putString(value.getStringValue());
                    break;
                }
                case NUMBER_VALUE: {
                    if (this.float64Buffer == null) {
                        this.float64Buffer = ByteBuffer.allocate(8);
                    } else {
                        this.float64Buffer.clear();
                    }
                    this.float64Buffer.putDouble(value.getNumberValue());
                    this.float64Buffer.flip();
                    this.digest.update(this.float64Buffer);
                    break;
                }
                case LIST_VALUE: {
                    if (type.getCode() == Type.Code.ARRAY) {
                        for (Value item : value.getListValue().getValuesList()) {
                            this.digest.update((byte)item.getKindCase().getNumber());
                            this.pushValue(type.getArrayElementType(), item);
                        }
                        break;
                    }
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "List values that are not an ARRAY are not supported");
                }
                case STRUCT_VALUE: {
                    if (type.getCode() == Type.Code.STRUCT) {
                        for (int col = 0; col < type.getStructFields().size(); ++col) {
                            String name = type.getStructFields().get(col).getName();
                            this.putString(name);
                            Value item = (Value)value.getStructValue().getFieldsMap().get(name);
                            this.digest.update((byte)item.getKindCase().getNumber());
                            this.pushValue(type.getStructFields().get(col).getType(), item);
                        }
                        break;
                    }
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Struct values without a struct type are not supported");
                }
                default: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNIMPLEMENTED, "Unsupported protobuf value: " + value.getKindCase());
                }
            }
        }

        private void putString(String stringValue) {
            int length = stringValue.length();
            if (this.buffer == null || this.buffer.capacity() < 0x100000 && this.buffer.capacity() < length) {
                this.buffer = ByteBuffer.allocate(Math.min(0x100000, length));
            } else {
                this.buffer.clear();
            }
            CharBuffer source = CharBuffer.wrap(stringValue);
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            while (source.hasRemaining()) {
                encoder.encode(source, this.buffer, false);
                this.buffer.flip();
                this.digest.update(this.buffer);
                this.buffer.flip();
            }
        }
    }

    private final class NextCallable
    implements Callable<Boolean> {
        private NextCallable() {
        }

        @Override
        public Boolean call() {
            ChecksumResultSet.this.transaction.getStatementExecutor().invokeInterceptors(ChecksumResultSet.this.statement, StatementExecutionStep.CALL_NEXT_ON_RESULT_SET, ChecksumResultSet.this.transaction);
            boolean res = ChecksumResultSet.super.next();
            if (res) {
                ChecksumResultSet.this.checksumCalculator.calculateNextChecksum(ChecksumResultSet.this);
            }
            ChecksumResultSet.this.numberOfNextCalls.incrementAndGet();
            return res;
        }
    }
}

