/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.DmlBatchUpdateCountVerificationFailedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.DirectedReadOptionsUtil;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.spanner.v1.DirectedReadOptions;
import java.time.Duration;
import java.util.Collection;

public class ConnectionProperties {
    private static final ImmutableMap.Builder<String, ConnectionProperty<?>> CONNECTION_PROPERTIES_BUILDER = ImmutableMap.builder();
    private static final Boolean[] BOOLEANS = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    static final ConnectionProperty<ConnectionState.Type> CONNECTION_STATE_TYPE = ConnectionProperties.create("connection_state_type", "The type of connection state to use for this connection. Can only be set at start up. If no value is set, then the database dialect default will be used, which is NON_TRANSACTIONAL for GoogleSQL and TRANSACTIONAL for PostgreSQL.", null, ConnectionState.Type.values(), ClientSideStatementValueConverters.ConnectionStateTypeConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> TRACING_PREFIX = ConnectionProperties.create("tracing_prefix", "The prefix that will be prepended to all OpenTelemetry traces that are generated by a Connection.", "CloudSpanner", ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> LENIENT = ConnectionProperties.create("lenient", "Silently ignore unknown properties in the connection string/properties (true/false)", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> ENDPOINT = ConnectionProperties.create("endpoint", "The endpoint that the JDBC driver should connect to. The default is the default Spanner production endpoint when autoConfigEmulator=false, and the default Spanner emulator endpoint (localhost:9010) when autoConfigEmulator=true. This property takes precedence over any host name at the start of the connection URL.", ConnectionOptions.DEFAULT_ENDPOINT, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> AUTO_CONFIG_EMULATOR = ConnectionProperties.create("autoConfigEmulator", "Automatically configure the connection to try to connect to the Cloud Spanner emulator (true/false). The instance and database in the connection string will automatically be created if these do not yet exist on the emulator. Add dialect=postgresql to the connection string to make sure that the database that is created uses the PostgreSQL dialect.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> USE_AUTO_SAVEPOINTS_FOR_EMULATOR = ConnectionProperties.create("useAutoSavepointsForEmulator", "Automatically creates savepoints for each statement in a read/write transaction when using the Emulator. This is no longer needed when using Emulator version 1.5.23 or higher.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> USE_PLAIN_TEXT = ConnectionProperties.create("usePlainText", "Use a plain text communication channel (i.e. non-TLS) for communicating with the server (true/false). Set this value to true for communication with the Cloud Spanner emulator.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> IS_EXPERIMENTAL_HOST = ConnectionProperties.create("isExperimentalHost", "Set this value to true for communication with a Experimental Host.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> CLIENT_CERTIFICATE = ConnectionProperties.create("clientCertificate", "Specifies the file path to the client certificate required for establishing an mTLS connection.", ConnectionOptions.DEFAULT_CLIENT_CERTIFICATE, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> CLIENT_KEY = ConnectionProperties.create("clientKey", "Specifies the file path to the client private key required for establishing an mTLS connection.", ConnectionOptions.DEFAULT_CLIENT_KEY, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> CREDENTIALS_URL = ConnectionProperties.create("credentials", "The location of the credentials file to use for this connection. If neither this property or encoded credentials are set, the connection will use the default Google Cloud credentials for the runtime environment.", ConnectionOptions.DEFAULT_CREDENTIALS, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> ENCODED_CREDENTIALS = ConnectionProperties.create("encodedCredentials", "Base64-encoded credentials to use for this connection. If neither this property or a credentials location are set, the connection will use the default Google Cloud credentials for the runtime environment.", null, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> OAUTH_TOKEN = ConnectionProperties.create("oauthToken", "A valid pre-existing OAuth token to use for authentication for this connection. Setting this property will take precedence over any value set for a credentials file.", ConnectionOptions.DEFAULT_OAUTH_TOKEN, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<CredentialsProvider> CREDENTIALS_PROVIDER = ConnectionProperties.create("credentialsProvider", "The class name of the com.google.api.gax.core.CredentialsProvider implementation that should be used to obtain credentials for connections.", null, ClientSideStatementValueConverters.CredentialsProviderConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> USER_AGENT = ConnectionProperties.create("userAgent", "The custom user-agent property name to use when communicating with Cloud Spanner. This property is intended for internal library usage, and should not be set by applications.", ConnectionOptions.DEFAULT_USER_AGENT, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Dialect> DIALECT = ConnectionProperties.create("dialect", "Sets the dialect to use for new databases that are created by this connection.", Dialect.GOOGLE_STANDARD_SQL, Dialect.values(), ClientSideStatementValueConverters.DialectConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> TRACK_SESSION_LEAKS = ConnectionProperties.create("trackSessionLeaks", "Capture the call stack of the thread that checked out a session of the session pool. This will pre-create a LeakedSessionException already when a session is checked out. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedSessionException will only be created when an actual session leak is detected. The stack trace of the exception will in that case not contain the call stack of when the session was checked out.", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> TRACK_CONNECTION_LEAKS = ConnectionProperties.create("trackConnectionLeaks", "Capture the call stack of the thread that created a connection. This will pre-create a LeakedConnectionException already when a connection is created. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedConnectionException will only be created when an actual connection leak is detected. The stack trace of the exception will in that case not contain the call stack of when the connection was created.", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> ROUTE_TO_LEADER = ConnectionProperties.create("routeToLeader", "Should read/write transactions and partitioned DML be routed to leader region (true/false)", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> USE_VIRTUAL_THREADS = ConnectionProperties.create("useVirtualThreads", "Use a virtual thread instead of a platform thread for each connection (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> USE_VIRTUAL_GRPC_TRANSPORT_THREADS = ConnectionProperties.create("useVirtualGrpcTransportThreads", "Use a virtual thread instead of a platform thread for the gRPC executor (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> ENABLE_EXTENDED_TRACING = ConnectionProperties.create("enableExtendedTracing", "Include the SQL string in the OpenTelemetry traces that are generated by this connection. The SQL string is added as the standard OpenTelemetry attribute 'db.statement'.", ConnectionOptions.DEFAULT_ENABLE_EXTENDED_TRACING, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> ENABLE_API_TRACING = ConnectionProperties.create("enableApiTracing", "Add OpenTelemetry traces for each individual RPC call. Enable this to get a detailed view of each RPC that is being executed by your application, or if you want to debug potential latency problems caused by RPCs that are being retried.", ConnectionOptions.DEFAULT_ENABLE_API_TRACING, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> ENABLE_END_TO_END_TRACING = ConnectionProperties.create("enableEndToEndTracing", "Enable end-to-end tracing (true/false) to generate traces for both the time that is spent in the client, as well as time that is spent in the Spanner server. Server side traces can only go to Google Cloud Trace, so to see end to end traces, the application should configure an exporter that exports the traces to Google Cloud Trace.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Integer> MIN_SESSIONS = ConnectionProperties.create("minSessions", "The minimum number of sessions in the backing session pool. The default is 100.", ConnectionOptions.DEFAULT_MIN_SESSIONS, ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Integer> MAX_SESSIONS = ConnectionProperties.create("maxSessions", "The maximum number of sessions in the backing session pool. The default is 400.", ConnectionOptions.DEFAULT_MAX_SESSIONS, ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Integer> NUM_CHANNELS = ConnectionProperties.create("numChannels", "The number of gRPC channels to use to communicate with Cloud Spanner. The default is 4.", ConnectionOptions.DEFAULT_NUM_CHANNELS, ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> CHANNEL_PROVIDER = ConnectionProperties.create("channelProvider", "The name of the channel provider class. The name must reference an implementation of ExternalChannelProvider. If this property is not set, the connection will use the default grpc channel provider.", ConnectionOptions.DEFAULT_CHANNEL_PROVIDER, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<String> DATABASE_ROLE = ConnectionProperties.create("databaseRole", "Sets the database role to use for this connection. The default is privileges assigned to IAM role", ConnectionOptions.DEFAULT_DATABASE_ROLE, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.STARTUP);
    static final ConnectionProperty<Boolean> AUTOCOMMIT = ConnectionProperties.create("autocommit", "Should the connection start in autocommit (true/false)", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> READONLY = ConnectionProperties.create("readonly", "Should the connection start in read-only mode (true/false)", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<AutocommitDmlMode> AUTOCOMMIT_DML_MODE = ConnectionProperties.create("autocommit_dml_mode", "Determines the transaction type that is used to execute DML statements when the connection is in auto-commit mode.", AutocommitDmlMode.TRANSACTIONAL, AutocommitDmlMode.values(), ClientSideStatementValueConverters.AutocommitDmlModeConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> RETRY_ABORTS_INTERNALLY = ConnectionProperties.create("retryAbortsInternally", "Should the connection automatically retry Aborted errors (true/false)", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> RETURN_COMMIT_STATS = ConnectionProperties.create("returnCommitStats", "Request that Spanner returns commit statistics for read/write transactions (true/false)", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE = ConnectionProperties.create("delayTransactionStartUntilFirstWrite", "Enabling this option will delay the actual start of a read/write transaction until the first write operation is seen in that transaction. All reads that happen before the first write in a transaction will instead be executed as if the connection was in auto-commit mode. Enabling this option will make read/write transactions lose their SERIALIZABLE isolation level. Read operations that are executed after the first write operation in a read/write transaction will be executed using the read/write transaction. Enabling this mode can reduce locking and improve performance for applications that can handle the lower transaction isolation semantics.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> KEEP_TRANSACTION_ALIVE = ConnectionProperties.create("keepTransactionAlive", "Enabling this option will trigger the connection to keep read/write transactions alive by executing a SELECT 1 query once every 10 seconds if no other statements are being executed. This option should be used with caution, as it can keep transactions alive and hold on to locks longer than intended. This option should typically be used for CLI-type application that might wait for user input for a longer period of time.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<TimestampBound> READ_ONLY_STALENESS = ConnectionProperties.create("read_only_staleness", "The read-only staleness to use for read-only transactions and single-use queries.", TimestampBound.strong(), ClientSideStatementValueConverters.ReadOnlyStalenessConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> AUTO_PARTITION_MODE = ConnectionProperties.create("autoPartitionMode", "Execute all queries on this connection as partitioned queries. Executing a query that cannot be partitioned will fail. Executing a query in a read/write transaction will also fail.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> DATA_BOOST_ENABLED = ConnectionProperties.create("dataBoostEnabled", "Enable data boost for all partitioned queries that are executed by this connection. This setting is only used for partitioned queries and is ignored by all other statements.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Integer> MAX_PARTITIONS = ConnectionProperties.create("maxPartitions", "The max partitions hint value to use for partitioned queries. Use 0 if you do not want to specify a hint.", 0, ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Integer> MAX_PARTITIONED_PARALLELISM = ConnectionProperties.create("maxPartitionedParallelism", "The max partitions hint value to use for partitioned queries. Use 0 if you do not want to specify a hint.", 1, ClientSideStatementValueConverters.NonNegativeIntegerConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<DirectedReadOptions> DIRECTED_READ = ConnectionProperties.create("directed_read", "The directed read options to apply to read-only transactions.", null, DirectedReadOptionsUtil.DirectedReadOptionsConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<String> OPTIMIZER_VERSION = ConnectionProperties.create("optimizerVersion", "Sets the default query optimizer version to use for this connection.", "", ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<String> OPTIMIZER_STATISTICS_PACKAGE = ConnectionProperties.create("optimizerStatisticsPackage", "Sets the query optimizer statistics package to use for this connection.", "", ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Options.RpcPriority> RPC_PRIORITY = ConnectionProperties.create("rpcPriority", "Sets the priority for all RPC invocations from this connection (HIGH/MEDIUM/LOW). The default is HIGH.", ConnectionOptions.DEFAULT_RPC_PRIORITY, Options.RpcPriority.values(), ClientSideStatementValueConverters.RpcPriorityConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<SavepointSupport> SAVEPOINT_SUPPORT = ConnectionProperties.create("savepoint_support", "Determines the behavior of the connection when savepoints are used.", SavepointSupport.FAIL_AFTER_ROLLBACK, SavepointSupport.values(), ClientSideStatementValueConverters.SavepointSupportConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<DdlInTransactionMode> DDL_IN_TRANSACTION_MODE = ConnectionProperties.create("ddlInTransactionMode", "Determines how the connection should handle DDL statements in a read/write transaction.", ConnectionOptions.DEFAULT_DDL_IN_TRANSACTION_MODE, DdlInTransactionMode.values(), ClientSideStatementValueConverters.DdlInTransactionModeConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<String> DEFAULT_SEQUENCE_KIND = ConnectionProperties.create("defaultSequenceKind", "The default sequence kind that should be used for the database. This property is only used when a DDL statement that requires a default sequence kind is executed on this connection.", ConnectionOptions.DEFAULT_DEFAULT_SEQUENCE_KIND, ClientSideStatementValueConverters.StringValueConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Duration> MAX_COMMIT_DELAY = ConnectionProperties.create("maxCommitDelay", "The max delay that Spanner may apply to commit requests to improve throughput.", null, ClientSideStatementValueConverters.DurationConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> AUTO_BATCH_DML = ConnectionProperties.create("auto_batch_dml", "Automatically buffer DML statements that are executed on this connection and execute them as one batch when a non-DML statement is executed, or when the current transaction is committed. The update count that is returned for DML statements that are buffered is by default 1. This default can be changed by setting the connection variable auto_batch_dml_update_count to value other than 1. This setting is only in read/write transactions. DML statements in auto-commit mode are executed directly.", false, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Long> AUTO_BATCH_DML_UPDATE_COUNT = ConnectionProperties.create("auto_batch_dml_update_count", "DML statements that are executed when auto_batch_dml is set to true, are not directly sent to Spanner, but are buffered in the client until the batch is flushed. This property determines the update count that is returned for these DML statements. The default is 1, as that is the update count that is expected by most ORMs (e.g. Hibernate).", 1L, ClientSideStatementValueConverters.LongConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ConnectionProperty<Boolean> AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION = ConnectionProperties.create("auto_batch_dml_update_count_verification", "The update count that is returned for DML statements that are buffered during an automatic DML batch is by default 1. This value can be changed by setting the connection variable auto_batch_dml_update_count. The update counts that are returned by Spanner when the DML statements are actually executed are verified against the update counts that were returned when they were buffered. If these do not match, a " + DmlBatchUpdateCountVerificationFailedException.class.getName() + " will be thrown. You can disable this verification by setting " + "auto_batch_dml_update_count_verification" + " to false.", true, BOOLEANS, ClientSideStatementValueConverters.BooleanConverter.INSTANCE, ConnectionProperty.Context.USER);
    static final ImmutableMap<String, ConnectionProperty<?>> CONNECTION_PROPERTIES = CONNECTION_PROPERTIES_BUILDER.build();
    public static ImmutableList<ConnectionProperty<?>> VALID_CONNECTION_PROPERTIES = ImmutableList.copyOf((Collection)CONNECTION_PROPERTIES.values());

    private static <T> ConnectionProperty<T> create(String name, String description, T defaultValue, ClientSideStatementValueConverter<T> converter, ConnectionProperty.Context context) {
        return ConnectionProperties.create(name, description, defaultValue, null, converter, context);
    }

    private static <T> ConnectionProperty<T> create(String name, String description, T defaultValue, T[] validValues, ClientSideStatementValueConverter<T> converter, ConnectionProperty.Context context) {
        ConnectionProperty<T> property = ConnectionProperty.create(name, description, defaultValue, validValues, converter, context);
        CONNECTION_PROPERTIES_BUILDER.put((Object)property.getKey(), property);
        return property;
    }

    static ImmutableMap<String, ConnectionPropertyValue<?>> parseValues(String url) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConnectionProperty property : CONNECTION_PROPERTIES.values()) {
            ConnectionPropertyValue value = ConnectionProperties.parseValue(ConnectionProperty.castProperty(property), url);
            if (value == null) continue;
            builder.put((Object)property.getKey(), value);
        }
        return builder.build();
    }

    private static <T> ConnectionPropertyValue<T> parseValue(ConnectionProperty<T> property, String url) {
        String stringValue = ConnectionOptions.parseUriProperty(url, property.getKey());
        return property.convert(stringValue);
    }

    private ConnectionProperties() {
    }
}

