/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public class DelayedAsyncRunner
implements AsyncRunner {
    private final ApiFuture<AsyncRunner> asyncRunnerFuture;

    public DelayedAsyncRunner(ApiFuture<AsyncRunner> asyncRunnerFuture) {
        this.asyncRunnerFuture = asyncRunnerFuture;
    }

    ApiFuture<AsyncRunner> getAsyncRunner() {
        return ApiFutures.catchingAsync(this.asyncRunnerFuture, Exception.class, exception -> {
            if (exception instanceof InterruptedException) {
                throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)exception);
            }
            if (exception instanceof ExecutionException) {
                throw SpannerExceptionFactory.causeAsRunTimeException((ExecutionException)exception);
            }
            throw exception;
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public <R> ApiFuture<R> runAsync(AsyncRunner.AsyncWork<R> work, Executor executor) {
        return ApiFutures.transformAsync(this.getAsyncRunner(), asyncRunner -> asyncRunner.runAsync(work, executor), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Timestamp> getCommitTimestamp() {
        return ApiFutures.transformAsync(this.getAsyncRunner(), AsyncRunner::getCommitTimestamp, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<CommitResponse> getCommitResponse() {
        return ApiFutures.transformAsync(this.getAsyncRunner(), AsyncRunner::getCommitResponse, (Executor)MoreExecutors.directExecutor());
    }
}

