/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.InternalApi;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Objects;

@InternalApi
public class XGoogSpannerRequestId {
    @VisibleForTesting
    static final String RAND_PROCESS_ID = XGoogSpannerRequestId.generateRandProcessId();
    @VisibleForTesting
    static final long VERSION = 1L;
    private final long nthClientId;
    private final long nthChannelId;
    private final long nthRequest;
    private long attempt;

    XGoogSpannerRequestId(long nthClientId, long nthChannelId, long nthRequest, long attempt) {
        this.nthClientId = nthClientId;
        this.nthChannelId = nthChannelId;
        this.nthRequest = nthRequest;
        this.attempt = attempt;
    }

    public static XGoogSpannerRequestId of(long nthClientId, long nthChannelId, long nthRequest, long attempt) {
        return new XGoogSpannerRequestId(nthClientId, nthChannelId, nthRequest, attempt);
    }

    private static String generateRandProcessId() {
        BigInteger bigInt = new BigInteger(64, new SecureRandom());
        return String.format("%016x", bigInt);
    }

    public String toString() {
        return String.format("%d.%s.%d.%d.%d.%d", 1L, RAND_PROCESS_ID, this.nthClientId, this.nthChannelId, this.nthRequest, this.attempt);
    }

    public boolean equals(Object other) {
        if (!(other instanceof XGoogSpannerRequestId)) {
            return false;
        }
        XGoogSpannerRequestId otherReqId = (XGoogSpannerRequestId)other;
        return Objects.equals(this.nthClientId, otherReqId.nthClientId) && Objects.equals(this.nthChannelId, otherReqId.nthChannelId) && Objects.equals(this.nthRequest, otherReqId.nthRequest) && Objects.equals(this.attempt, otherReqId.attempt);
    }

    public int hashCode() {
        return Objects.hash(this.nthClientId, this.nthChannelId, this.nthRequest, this.attempt);
    }
}

