/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConnectionProperty<T> {
    private final String extension;
    @Nonnull
    private final String name;
    @Nonnull
    private final String key;
    @Nonnull
    private final String description;
    private final T defaultValue;
    private final T[] validValues;
    private final ClientSideStatementValueConverter<T> converter;
    private final Context context;

    static <T> ConnectionProperty<T> castProperty(ConnectionProperty<?> property) {
        return property;
    }

    @Nonnull
    static String createKey(String extension, @Nonnull String name) {
        ConnectionPreconditions.checkArgument(!Strings.isNullOrEmpty((String)name), "property name must be a non-empty string");
        return extension == null ? name.toLowerCase(Locale.ENGLISH) : extension.toLowerCase(Locale.ENGLISH) + "." + name.toLowerCase(Locale.ENGLISH);
    }

    @Nonnull
    static <T> ConnectionProperty<T> create(@Nonnull String name, String description, T defaultValue, ClientSideStatementValueConverter<T> converter, Context context) {
        return ConnectionProperty.create(name, description, defaultValue, null, converter, context);
    }

    @Nonnull
    static <T> ConnectionProperty<T> create(@Nonnull String name, String description, T defaultValue, T[] validValues, ClientSideStatementValueConverter<T> converter, Context context) {
        return new ConnectionProperty<T>(null, name, description, defaultValue, validValues, converter, context);
    }

    ConnectionProperty(String extension, @Nonnull String name, @Nonnull String description, T defaultValue, T[] validValues, ClientSideStatementValueConverter<T> converter, Context context) {
        ConnectionPreconditions.checkArgument(!Strings.isNullOrEmpty((String)name), "property name must be a non-empty string");
        ConnectionPreconditions.checkArgument(!Strings.isNullOrEmpty((String)description), "property description must be a non-empty string");
        this.extension = extension == null ? null : extension.toLowerCase(Locale.ENGLISH);
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.description = description;
        this.defaultValue = defaultValue;
        this.validValues = validValues;
        this.converter = converter;
        this.context = context;
        this.key = ConnectionProperty.createKey(this.extension, this.name);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionProperty)) {
            return false;
        }
        ConnectionProperty other = (ConnectionProperty)o;
        return this.key.equals(other.key);
    }

    ConnectionPropertyValue<T> createInitialValue(@Nullable ConnectionPropertyValue<T> initialValue) {
        return initialValue == null ? new ConnectionPropertyValue<T>(this, this.defaultValue, this.defaultValue) : initialValue.copy();
    }

    @Nullable
    ConnectionPropertyValue<T> convert(@Nullable String stringValue) {
        if (stringValue == null) {
            return null;
        }
        T convertedValue = this.converter.convert(stringValue);
        if (convertedValue == null) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid value for property " + this + ": " + stringValue);
        }
        return new ConnectionPropertyValue<T>(this, convertedValue, convertedValue);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public boolean hasExtension() {
        return this.extension != null;
    }

    public String getExtension() {
        return this.extension;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T[] getValidValues() {
        return this.validValues;
    }

    public Context getContext() {
        return this.context;
    }

    public static enum Context {
        STARTUP,
        USER;

    }
}

