/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class DmlBatch
extends AbstractBaseUnitOfWork {
    private final boolean autoBatch;
    private final Supplier<Long> autoBatchUpdateCountSupplier;
    private final Supplier<Boolean> verifyUpdateCountsSupplier;
    private final UnitOfWork transaction;
    private final String statementTag;
    private final List<AbstractStatementParser.ParsedStatement> statements = new ArrayList<AbstractStatementParser.ParsedStatement>();
    private long[] updateCounts = new long[0];
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    private DmlBatch(Builder builder) {
        super(builder);
        this.autoBatch = builder.autoBatch;
        this.autoBatchUpdateCountSupplier = builder.autoBatchUpdateCountSupplier;
        this.verifyUpdateCountsSupplier = builder.verifyUpdateCountsSupplier;
        this.transaction = (UnitOfWork)Preconditions.checkNotNull((Object)builder.transaction);
        this.statementTag = builder.statementTag;
    }

    boolean isAutoBatch() {
        return this.autoBatch;
    }

    @Override
    public boolean isSingleUse() {
        return false;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.BATCH;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing queries is not allowed for DML batches.");
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for DML batches.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for DML batches.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit response available for DML batches.");
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing DDL statements is not allowed for DML batches.");
    }

    long getUpdateCount() {
        return this.isAutoBatch() ? this.autoBatchUpdateCountSupplier.get() : -1L;
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)("Only DML statements are allowed. \"" + update.getSql() + "\" is not a DML-statement."));
        long updateCount = this.getUpdateCount();
        this.statements.add(update);
        this.updateCounts = Arrays.copyOf(this.updateCounts, this.updateCounts.length + 1);
        this.updateCounts[this.updateCounts.length - 1] = updateCount;
        return ApiFutures.immediateFuture((Object)updateCount);
    }

    @Override
    public ApiFuture<ResultSet> analyzeUpdateAsync(UnitOfWork.CallType callType, AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        if (this.transaction.isSingleUse()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Analyzing updates is not allowed for DML batches.");
        }
        return this.transaction.analyzeUpdateAsync(callType, update, analyzeMode, options);
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(UnitOfWork.CallType callType, Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        for (AbstractStatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((update.getType() == AbstractStatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)("Only DML statements are allowed. \"" + update.getSql() + "\" is not a DML-statement."));
        }
        long[] updateCountArray = new long[Iterables.size(updates)];
        Arrays.fill(updateCountArray, this.getUpdateCount());
        Iterables.addAll(this.statements, updates);
        this.updateCounts = Arrays.copyOf(this.updateCounts, this.updateCounts.length + updateCountArray.length);
        System.arraycopy(updateCountArray, 0, this.updateCounts, this.updateCounts.length - updateCountArray.length, updateCountArray.length);
        return ApiFutures.immediateFuture((Object)updateCountArray);
    }

    @Override
    public ApiFuture<Void> writeAsync(UnitOfWork.CallType callType, Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<long[]> runBatchAsync(UnitOfWork.CallType callType) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be ran");
        try (Scope ignore = this.span.makeCurrent();){
            if (this.statements.isEmpty()) {
                this.state = UnitOfWork.UnitOfWorkState.RAN;
                ApiFuture apiFuture = ApiFutures.immediateFuture((Object)new long[0]);
                return apiFuture;
            }
            this.state = UnitOfWork.UnitOfWorkState.RUNNING;
            final SettableApiFuture res = SettableApiFuture.create();
            int numOptions = 0;
            if (this.statementTag != null) {
                ++numOptions;
            }
            if (this.rpcPriority != null) {
                ++numOptions;
            }
            Options.UpdateOption[] options = new Options.UpdateOption[numOptions];
            int index = 0;
            if (this.statementTag != null) {
                options[index++] = Options.tag(this.statementTag);
            }
            if (this.rpcPriority != null) {
                options[index++] = Options.priority(this.rpcPriority);
            }
            ApiFuture<long[]> updateCounts = this.transaction.executeBatchUpdateAsync(callType, this.statements, options);
            ApiFutures.addCallback(updateCounts, (ApiFutureCallback)new ApiFutureCallback<long[]>(){

                public void onFailure(Throwable t) {
                    DmlBatch.this.state = UnitOfWork.UnitOfWorkState.RUN_FAILED;
                    res.setException(t);
                }

                public void onSuccess(long[] result) {
                    DmlBatch.this.state = UnitOfWork.UnitOfWorkState.RAN;
                    if (!DmlBatch.this.verifyUpdateCounts(result)) {
                        res.setException((Throwable)((Object)SpannerExceptionFactory.newDmlBatchUpdateCountVerificationFailedException(DmlBatch.this.updateCounts, result)));
                    } else {
                        res.set((Object)result);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
            this.asyncEndUnitOfWorkSpan();
            SettableApiFuture settableApiFuture = res;
            return settableApiFuture;
        }
    }

    private boolean verifyUpdateCounts(long[] actualUpdateCounts) {
        if (!this.autoBatch || !this.verifyUpdateCountsSupplier.get().booleanValue()) {
            return true;
        }
        return Arrays.equals(this.updateCounts, actualUpdateCounts);
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be aborted.");
        this.asyncEndUnitOfWorkSpan();
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    public ApiFuture<Void> commitAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<Void> rollbackAsync(@Nonnull UnitOfWork.CallType callType, @Nonnull UnitOfWork.EndTransactionCallback callback) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not allowed for DML batches.");
    }

    @Override
    String getUnitOfWorkName() {
        return "DML batch";
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, DmlBatch> {
        private boolean autoBatch;
        private Supplier<Long> autoBatchUpdateCountSupplier = Suppliers.ofInstance((Object)1L);
        private Supplier<Boolean> verifyUpdateCountsSupplier = Suppliers.ofInstance((Object)Boolean.FALSE);
        private UnitOfWork transaction;
        private String statementTag;

        private Builder() {
        }

        Builder setAutoBatch(boolean autoBatch) {
            this.autoBatch = autoBatch;
            return this;
        }

        Builder setAutoBatchUpdateCountSupplier(Supplier<Long> updateCountSupplier) {
            this.autoBatchUpdateCountSupplier = (Supplier)Preconditions.checkNotNull(updateCountSupplier);
            return this;
        }

        Builder setAutoBatchUpdateCountVerificationSupplier(Supplier<Boolean> verificationSupplier) {
            this.verifyUpdateCountsSupplier = verificationSupplier;
            return this;
        }

        Builder setTransaction(UnitOfWork transaction) {
            Preconditions.checkNotNull((Object)transaction);
            this.transaction = transaction;
            return this;
        }

        Builder setStatementTag(String tag) {
            this.statementTag = tag;
            return this;
        }

        @Override
        DmlBatch build() {
            Preconditions.checkState((this.transaction != null ? 1 : 0) != 0, (Object)"No transaction specified");
            return new DmlBatch(this);
        }
    }
}

