/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionProperties;
import com.google.cloud.spanner.connection.ConnectionProperty;
import com.google.cloud.spanner.connection.ConnectionPropertyValue;
import com.google.cloud.spanner.connection.ConnectionState;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.LocalConnectionChecker;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@InternalApi
public class ConnectionOptions {
    public static String ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY = "spanner.enable_transactional_connection_state_for_postgresql";
    private static final LocalConnectionChecker LOCAL_CONNECTION_CHECKER = new LocalConnectionChecker();
    static final boolean DEFAULT_USE_PLAIN_TEXT = false;
    static final boolean DEFAULT_IS_EXPERIMENTAL_HOST = false;
    static final boolean DEFAULT_AUTOCOMMIT = true;
    static final boolean DEFAULT_READONLY = false;
    static final boolean DEFAULT_RETRY_ABORTS_INTERNALLY = true;
    static final boolean DEFAULT_USE_VIRTUAL_THREADS = false;
    static final boolean DEFAULT_USE_VIRTUAL_GRPC_TRANSPORT_THREADS = false;
    static final String DEFAULT_CREDENTIALS = null;
    static final String DEFAULT_CLIENT_CERTIFICATE = null;
    static final String DEFAULT_CLIENT_KEY = null;
    static final String DEFAULT_OAUTH_TOKEN = null;
    static final Integer DEFAULT_MIN_SESSIONS = null;
    static final Integer DEFAULT_MAX_SESSIONS = null;
    static final Integer DEFAULT_NUM_CHANNELS = null;
    static final String DEFAULT_ENDPOINT = null;
    static final String DEFAULT_CHANNEL_PROVIDER = null;
    static final String DEFAULT_DATABASE_ROLE = null;
    static final String DEFAULT_USER_AGENT = null;
    static final String DEFAULT_OPTIMIZER_VERSION = "";
    static final String DEFAULT_OPTIMIZER_STATISTICS_PACKAGE = "";
    static final Options.RpcPriority DEFAULT_RPC_PRIORITY = null;
    static final DdlInTransactionMode DEFAULT_DDL_IN_TRANSACTION_MODE = DdlInTransactionMode.ALLOW_IN_EMPTY_TRANSACTION;
    static final String DEFAULT_DEFAULT_SEQUENCE_KIND = null;
    static final boolean DEFAULT_RETURN_COMMIT_STATS = false;
    static final boolean DEFAULT_LENIENT = false;
    static final boolean DEFAULT_ROUTE_TO_LEADER = true;
    static final boolean DEFAULT_DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE = false;
    static final boolean DEFAULT_KEEP_TRANSACTION_ALIVE = false;
    static final boolean DEFAULT_TRACK_SESSION_LEAKS = true;
    static final boolean DEFAULT_TRACK_CONNECTION_LEAKS = true;
    static final boolean DEFAULT_DATA_BOOST_ENABLED = false;
    static final boolean DEFAULT_AUTO_PARTITION_MODE = false;
    static final int DEFAULT_MAX_PARTITIONS = 0;
    static final int DEFAULT_MAX_PARTITIONED_PARALLELISM = 1;
    static final Boolean DEFAULT_ENABLE_EXTENDED_TRACING = null;
    static final Boolean DEFAULT_ENABLE_API_TRACING = null;
    static final boolean DEFAULT_ENABLE_END_TO_END_TRACING = false;
    static final boolean DEFAULT_AUTO_BATCH_DML = false;
    static final long DEFAULT_AUTO_BATCH_DML_UPDATE_COUNT = 1L;
    static final boolean DEFAULT_AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION = true;
    private static final String EXPERIMENTAL_HOST_PROJECT_ID = "default";
    private static final String DEFAULT_EXPERIMENTAL_HOST_INSTANCE_ID = "default";
    private static final String PLAIN_TEXT_PROTOCOL = "http:";
    private static final String HOST_PROTOCOL = "https:";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String SPANNER_EMULATOR_HOST_ENV_VAR = "SPANNER_EMULATOR_HOST";
    private static final String DEFAULT_EMULATOR_HOST = "http://localhost:9010";
    static final String USE_PLAIN_TEXT_PROPERTY_NAME = "usePlainText";
    static final String IS_EXPERIMENTAL_HOST_PROPERTY_NAME = "isExperimentalHost";
    static final String CLIENT_CERTIFICATE_PROPERTY_NAME = "clientCertificate";
    static final String CLIENT_KEY_PROPERTY_NAME = "clientKey";
    public static final String AUTOCOMMIT_PROPERTY_NAME = "autocommit";
    public static final String READONLY_PROPERTY_NAME = "readonly";
    public static final String ROUTE_TO_LEADER_PROPERTY_NAME = "routeToLeader";
    public static final String RETRY_ABORTS_INTERNALLY_PROPERTY_NAME = "retryAbortsInternally";
    public static final String USE_VIRTUAL_THREADS_PROPERTY_NAME = "useVirtualThreads";
    public static final String USE_VIRTUAL_GRPC_TRANSPORT_THREADS_PROPERTY_NAME = "useVirtualGrpcTransportThreads";
    public static final String CREDENTIALS_PROPERTY_NAME = "credentials";
    public static final String ENCODED_CREDENTIALS_PROPERTY_NAME = "encodedCredentials";
    public static final String ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY = "ENABLE_ENCODED_CREDENTIALS";
    public static final String CREDENTIALS_PROVIDER_PROPERTY_NAME = "credentialsProvider";
    public static final String ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CREDENTIALS_PROVIDER";
    public static final String OAUTH_TOKEN_PROPERTY_NAME = "oauthToken";
    public static final String MIN_SESSIONS_PROPERTY_NAME = "minSessions";
    public static final String MAX_SESSIONS_PROPERTY_NAME = "maxSessions";
    public static final String NUM_CHANNELS_PROPERTY_NAME = "numChannels";
    public static final String ENDPOINT_PROPERTY_NAME = "endpoint";
    public static final String CHANNEL_PROVIDER_PROPERTY_NAME = "channelProvider";
    public static final String ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CHANNEL_PROVIDER";
    static final String USER_AGENT_PROPERTY_NAME = "userAgent";
    static final String OPTIMIZER_VERSION_PROPERTY_NAME = "optimizerVersion";
    static final String OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME = "optimizerStatisticsPackage";
    public static final String LENIENT_PROPERTY_NAME = "lenient";
    public static final String RPC_PRIORITY_NAME = "rpcPriority";
    public static final String DDL_IN_TRANSACTION_MODE_PROPERTY_NAME = "ddlInTransactionMode";
    public static final String DEFAULT_SEQUENCE_KIND_PROPERTY_NAME = "defaultSequenceKind";
    static final String DIALECT_PROPERTY_NAME = "dialect";
    public static final String DATABASE_ROLE_PROPERTY_NAME = "databaseRole";
    public static final String DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE_NAME = "delayTransactionStartUntilFirstWrite";
    public static final String KEEP_TRANSACTION_ALIVE_PROPERTY_NAME = "keepTransactionAlive";
    public static final String TRACK_SESSION_LEAKS_PROPERTY_NAME = "trackSessionLeaks";
    public static final String TRACK_CONNECTION_LEAKS_PROPERTY_NAME = "trackConnectionLeaks";
    public static final String DATA_BOOST_ENABLED_PROPERTY_NAME = "dataBoostEnabled";
    public static final String AUTO_PARTITION_MODE_PROPERTY_NAME = "autoPartitionMode";
    public static final String MAX_PARTITIONS_PROPERTY_NAME = "maxPartitions";
    public static final String MAX_PARTITIONED_PARALLELISM_PROPERTY_NAME = "maxPartitionedParallelism";
    public static final String ENABLE_EXTENDED_TRACING_PROPERTY_NAME = "enableExtendedTracing";
    public static final String ENABLE_API_TRACING_PROPERTY_NAME = "enableApiTracing";
    public static final String ENABLE_END_TO_END_TRACING_PROPERTY_NAME = "enableEndToEndTracing";
    public static final String AUTO_BATCH_DML_PROPERTY_NAME = "auto_batch_dml";
    public static final String AUTO_BATCH_DML_UPDATE_COUNT_PROPERTY_NAME = "auto_batch_dml_update_count";
    public static final String AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION_PROPERTY_NAME = "auto_batch_dml_update_count_verification";
    private static final String GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE = "%s can only be used if the system property %s has been set to true. Start the application with the JVM command line option -D%s=true";
    private final ConnectionState initialConnectionState;
    private final String uri;
    private final String warnings;
    private final Credentials fixedCredentials;
    private final String host;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;
    private final StatementExecutor.StatementExecutorType statementExecutorType;
    private final SessionPoolOptions sessionPoolOptions;
    private final OpenTelemetry openTelemetry;
    private final List<StatementExecutionInterceptor> statementExecutionInterceptors;
    private final SpannerOptionsConfigurator configurator;

    private static String generateGuardedConnectionPropertyError(String systemPropertyName, String connectionPropertyName) {
        return String.format(GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE, connectionPropertyName, systemPropertyName, systemPropertyName);
    }

    static boolean isEnableTransactionalConnectionStateForPostgreSQL() {
        return Boolean.parseBoolean(System.getProperty(ENABLE_TRANSACTIONAL_CONNECTION_STATE_FOR_POSTGRESQL_PROPERTY, "false"));
    }

    public static String getDefaultProjectId(Credentials credentials) {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && credentials != null && credentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)credentials).getProjectId();
        }
        return projectId;
    }

    public static void closeSpanner() {
        SpannerPool.INSTANCE.checkAndCloseSpanners();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConnectionOptions(Builder builder) {
        Matcher matcher;
        boolean isExperimentalHostPattern = false;
        if (builder.isValidExperimentalHostUri(builder.uri)) {
            matcher = Builder.EXTERNAL_HOST_PATTERN.matcher(builder.uri);
            isExperimentalHostPattern = true;
        } else {
            matcher = Builder.SPANNER_URI_PATTERN.matcher(builder.uri);
        }
        Preconditions.checkArgument((boolean)matcher.find(), (Object)String.format("Invalid connection URI specified: %s", builder.uri));
        ImmutableMap connectionPropertyValues = ImmutableMap.builder().putAll(ConnectionProperties.parseValues(builder.uri)).putAll(builder.connectionPropertyValues).buildKeepingLast();
        this.uri = builder.uri;
        ConnectionPropertyValue value = ConnectionPropertyValue.cast((ConnectionPropertyValue)connectionPropertyValues.get((Object)ConnectionProperties.LENIENT.getKey()));
        this.warnings = ConnectionOptions.checkValidProperties(value != null && (Boolean)value.getValue() != false, this.uri);
        this.fixedCredentials = builder.credentials;
        this.statementExecutorType = builder.statementExecutorType;
        this.openTelemetry = builder.openTelemetry;
        this.statementExecutionInterceptors = Collections.unmodifiableList(builder.statementExecutionInterceptors);
        this.configurator = builder.configurator;
        this.initialConnectionState = new ConnectionState((Map<String, ConnectionPropertyValue<?>>)connectionPropertyValues);
        Preconditions.checkArgument((Stream.of(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL), this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS), this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER), this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN)).filter(Objects::nonNull).count() <= 1L ? 1 : 0) != 0, (Object)"Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token");
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS), ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY, ENCODED_CREDENTIALS_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) == null ? null : this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER).getClass().getName(), ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY, CREDENTIALS_PROVIDER_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(this.getInitialConnectionPropertyValue(ConnectionProperties.CHANNEL_PROVIDER), ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY, CHANNEL_PROVIDER_PROPERTY_NAME);
        boolean usePlainText = this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR) != false || this.getInitialConnectionPropertyValue(ConnectionProperties.USE_PLAIN_TEXT) != false;
        this.host = ConnectionOptions.determineHost(matcher, this.getInitialConnectionPropertyValue(ConnectionProperties.ENDPOINT), this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR), usePlainText, System.getenv());
        GoogleCredentials defaultExperimentalHostCredentials = SpannerOptions.getDefaultExperimentalCredentialsFromSysEnv();
        if (this.fixedCredentials == null && this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) == null && this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN) == null && usePlainText) {
            this.credentials = NoCredentials.getInstance();
        } else if (this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN) != null) {
            this.credentials = new GoogleCredentials(new AccessToken(this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN), null));
        } else if ((isExperimentalHostPattern || this.isExperimentalHost()) && defaultExperimentalHostCredentials != null) {
            this.credentials = defaultExperimentalHostCredentials;
        } else if (this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER) != null) {
            try {
                this.credentials = this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER).getCredentials();
            }
            catch (IOException exception) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to get credentials from CredentialsProvider: " + exception.getMessage(), exception);
            }
        } else {
            this.credentials = this.fixedCredentials != null ? this.fixedCredentials : (this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS) != null ? this.getCredentialsService().decodeCredentials(this.getInitialConnectionPropertyValue(ConnectionProperties.ENCODED_CREDENTIALS)) : this.getCredentialsService().createCredentials(this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL)));
        }
        if (this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS) != null || this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS) != null || !this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_SESSION_LEAKS).booleanValue()) {
            SessionPoolOptions.Builder sessionPoolOptionsBuilder = builder.sessionPoolOptions == null ? SessionPoolOptions.newBuilder() : builder.sessionPoolOptions.toBuilder();
            sessionPoolOptionsBuilder.setTrackStackTraceOfSessionCheckout(this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_SESSION_LEAKS));
            sessionPoolOptionsBuilder.setAutoDetectDialect(true);
            if (this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS) != null) {
                sessionPoolOptionsBuilder.setMinSessions(this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS));
            }
            if (this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS) != null) {
                sessionPoolOptionsBuilder.setMaxSessions(this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS));
            }
            this.sessionPoolOptions = sessionPoolOptionsBuilder.build();
        } else {
            this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : (isExperimentalHostPattern || this.isExperimentalHost() ? SessionPoolOptions.newBuilder().setExperimentalHost().setAutoDetectDialect(true).build() : SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build());
        }
        String projectId = "default";
        String instanceId = matcher.group("INSTANCEGROUP");
        if (!this.isExperimentalHost() && !isExperimentalHostPattern) {
            projectId = matcher.group("PROJECTGROUP");
        } else if (instanceId == null && this.isExperimentalHost()) {
            instanceId = "default";
        }
        if ("DEFAULT_PROJECT_ID".equalsIgnoreCase(projectId)) {
            projectId = ConnectionOptions.getDefaultProjectId(this.credentials);
        }
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.databaseName = matcher.group("DATABASEGROUP");
    }

    @VisibleForTesting
    static String determineHost(Matcher matcher, String endpoint, boolean autoConfigEmulator, boolean usePlainText, Map<String, String> environment) {
        String host;
        if (Objects.equals(endpoint, DEFAULT_ENDPOINT) && matcher.group("HOSTGROUP") == null) {
            if (autoConfigEmulator) {
                if (Strings.isNullOrEmpty((String)environment.get(SPANNER_EMULATOR_HOST_ENV_VAR))) {
                    return DEFAULT_EMULATOR_HOST;
                }
                return "http://" + environment.get(SPANNER_EMULATOR_HOST_ENV_VAR);
            }
            return DEFAULT_HOST;
        }
        if (!Objects.equals(endpoint, DEFAULT_ENDPOINT)) {
            host = "//" + endpoint;
        } else {
            host = matcher.group("HOSTGROUP");
            if ("(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?".equals(matcher.pattern().pattern()) && !host.matches(".*:\\d+$")) {
                host = String.format("%s:15000", host);
            }
        }
        if (usePlainText) {
            return PLAIN_TEXT_PROTOCOL + host;
        }
        return HOST_PROTOCOL + host;
    }

    OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    SpannerOptionsConfigurator getConfigurator() {
        return this.configurator;
    }

    @VisibleForTesting
    CredentialsService getCredentialsService() {
        return CredentialsService.INSTANCE;
    }

    private static void checkGuardedProperty(String value, String systemPropertyName, String connectionPropertyName) {
        if (!Strings.isNullOrEmpty((String)value) && !Boolean.parseBoolean(System.getProperty(systemPropertyName))) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, ConnectionOptions.generateGuardedConnectionPropertyError(systemPropertyName, connectionPropertyName));
        }
    }

    @VisibleForTesting
    static String parseUriProperty(String uri, String property) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    @VisibleForTesting
    static String checkValidProperties(boolean lenient, String uri) {
        StringBuilder invalidProperties = new StringBuilder();
        List<String> properties = ConnectionOptions.parseProperties(uri);
        for (String property : properties) {
            if (ConnectionProperties.CONNECTION_PROPERTIES.containsKey((Object)property.toLowerCase(Locale.ENGLISH))) continue;
            if (invalidProperties.length() > 0) {
                invalidProperties.append(", ");
            }
            invalidProperties.append(property);
        }
        if (lenient) {
            return String.format("Invalid properties found in connection URI: %s", invalidProperties);
        }
        Preconditions.checkArgument((invalidProperties.length() == 0 ? 1 : 0) != 0, (Object)String.format("Invalid properties found in connection URI. Add lenient=true to the connection string to ignore unknown properties. Invalid properties: %s", invalidProperties));
        return null;
    }

    @VisibleForTesting
    static List<String> parseProperties(String uri) {
        Pattern pattern = Pattern.compile("(?is)(?:\\?|;)(?<PROPERTY>.*?)=(?:.*?)");
        Matcher matcher = pattern.matcher(uri);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find() && matcher.group("PROPERTY") != null) {
            res.add(matcher.group("PROPERTY"));
        }
        return res;
    }

    static long tryParseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public Connection getConnection() {
        LOCAL_CONNECTION_CHECKER.checkLocalConnection(this);
        return new ConnectionImpl(this);
    }

    public String getUri() {
        return this.uri;
    }

    Map<String, ConnectionPropertyValue<?>> getInitialConnectionPropertyValues() {
        return this.initialConnectionState.getAllValues();
    }

    <T> T getInitialConnectionPropertyValue(ConnectionProperty<T> property) {
        return this.initialConnectionState.getValue(property).getValue();
    }

    public String getCredentialsUrl() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL);
    }

    String getOAuthToken() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN);
    }

    Credentials getFixedCredentials() {
        return this.fixedCredentials;
    }

    CredentialsProvider getCredentialsProvider() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CREDENTIALS_PROVIDER);
    }

    public StatementExecutor.StatementExecutorType getStatementExecutorType() {
        return this.statementExecutorType;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Integer getMinSessions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MIN_SESSIONS);
    }

    public Integer getMaxSessions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_SESSIONS);
    }

    public Integer getNumChannels() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.NUM_CHANNELS);
    }

    public TransportChannelProvider getChannelProvider() {
        String channelProvider = this.getInitialConnectionPropertyValue(ConnectionProperties.CHANNEL_PROVIDER);
        if (channelProvider == null) {
            return null;
        }
        try {
            URL url = new URL(this.host);
            ExternalChannelProvider provider = (ExternalChannelProvider)ExternalChannelProvider.class.cast(Class.forName(channelProvider).newInstance());
            return provider.getChannelProvider(url.getHost(), url.getPort());
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("%s : Failed to create channel with external provider: %s", e.toString(), channelProvider));
        }
    }

    public String getDatabaseRole() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DATABASE_ROLE);
    }

    public String getHost() {
        return this.host;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project ID is not specified");
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance ID is not specified");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"Database name is not specified");
        return DatabaseId.of(this.projectId, this.instanceId, this.databaseName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAutocommit() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTOCOMMIT);
    }

    public boolean isReadOnly() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.READONLY);
    }

    public boolean isRouteToLeader() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ROUTE_TO_LEADER);
    }

    public boolean isEndToEndTracingEnabled() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_END_TO_END_TRACING);
    }

    public boolean isRetryAbortsInternally() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.RETRY_ABORTS_INTERNALLY);
    }

    public boolean isUseVirtualThreads() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_VIRTUAL_THREADS);
    }

    public boolean isUseVirtualGrpcTransportThreads() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_VIRTUAL_GRPC_TRANSPORT_THREADS);
    }

    @Nullable
    public String getWarnings() {
        return this.warnings;
    }

    boolean isUsePlainText() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR) != false || this.getInitialConnectionPropertyValue(ConnectionProperties.USE_PLAIN_TEXT) != false;
    }

    boolean isExperimentalHost() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.IS_EXPERIMENTAL_HOST);
    }

    String getClientCertificate() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CLIENT_CERTIFICATE);
    }

    String getClientCertificateKey() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.CLIENT_KEY);
    }

    String getUserAgent() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USER_AGENT);
    }

    public boolean isReturnCommitStats() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.RETURN_COMMIT_STATS);
    }

    public Duration getMaxCommitDelay() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_COMMIT_DELAY);
    }

    boolean usesEmulator() {
        return (Boolean)Suppliers.memoize(() -> this.isAutoConfigEmulator() || !Strings.isNullOrEmpty((String)System.getenv(SPANNER_EMULATOR_HOST_ENV_VAR))).get();
    }

    public boolean isAutoConfigEmulator() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_CONFIG_EMULATOR);
    }

    boolean useAutoSavepointsForEmulator() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.USE_AUTO_SAVEPOINTS_FOR_EMULATOR);
    }

    public Dialect getDialect() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DIALECT);
    }

    boolean isTrackConnectionLeaks() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.TRACK_CONNECTION_LEAKS);
    }

    boolean isDataBoostEnabled() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.DATA_BOOST_ENABLED);
    }

    boolean isAutoPartitionMode() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.AUTO_PARTITION_MODE);
    }

    int getMaxPartitions() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONS);
    }

    int getMaxPartitionedParallelism() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.MAX_PARTITIONED_PARALLELISM);
    }

    Boolean isEnableExtendedTracing() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_EXTENDED_TRACING);
    }

    Boolean isEnableApiTracing() {
        return this.getInitialConnectionPropertyValue(ConnectionProperties.ENABLE_API_TRACING);
    }

    List<StatementExecutionInterceptor> getStatementExecutionInterceptors() {
        return this.statementExecutionInterceptors;
    }

    public String toString() {
        return this.getUri();
    }

    public static class Builder {
        private final Map<String, ConnectionPropertyValue<?>> connectionPropertyValues = new HashMap();
        private String uri;
        private Credentials credentials;
        private StatementExecutor.StatementExecutorType statementExecutorType;
        private SessionPoolOptions sessionPoolOptions;
        private List<StatementExecutionInterceptor> statementExecutionInterceptors = Collections.emptyList();
        private SpannerOptionsConfigurator configurator;
        private OpenTelemetry openTelemetry;
        public static final String SPANNER_URI_FORMAT = "(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
        public static final String EXTERNAL_HOST_FORMAT = "(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?";
        private static final String SPANNER_URI_REGEX = "(?is)^(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$";
        @VisibleForTesting
        static final Pattern SPANNER_URI_PATTERN = Pattern.compile("(?is)^(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$");
        @VisibleForTesting
        static final Pattern EXTERNAL_HOST_PATTERN = Pattern.compile("(?:(?:spanner|cloudspanner):)(?<HOSTGROUP>//[\\w.-]+(?::\\d+)?)(/instances/(?<INSTANCEGROUP>[a-z0-9-]+))?(/databases/(?<DATABASEGROUP>[a-z0-9_-]+))(?:[?;].*)?");
        private static final String HOST_GROUP = "HOSTGROUP";
        private static final String PROJECT_GROUP = "PROJECTGROUP";
        private static final String INSTANCE_GROUP = "INSTANCEGROUP";
        private static final String DATABASE_GROUP = "DATABASEGROUP";
        private static final String DEFAULT_PROJECT_ID_PLACEHOLDER = "DEFAULT_PROJECT_ID";

        private Builder() {
        }

        private boolean isValidUri(String uri) {
            return SPANNER_URI_PATTERN.matcher(uri).matches();
        }

        private boolean isValidExperimentalHostUri(String uri) {
            return EXTERNAL_HOST_PATTERN.matcher(uri).matches();
        }

        public Builder setUri(String uri) {
            ConnectionPropertyValue value;
            if (!this.isValidExperimentalHostUri(uri)) {
                Preconditions.checkArgument((boolean)this.isValidUri(uri), (Object)"The specified URI is not a valid Cloud Spanner connection URI. Please specify a URI in the format \"cloudspanner:[//host[:port]]/projects/project-id[/instances/instance-id[/databases/database-name]][\\?property-name=property-value[;property-name=property-value]*]?\"");
            }
            ConnectionOptions.checkValidProperties((value = ConnectionPropertyValue.cast((ConnectionPropertyValue)ConnectionProperties.parseValues(uri).get((Object)ConnectionProperties.LENIENT.getKey()))) != null && (Boolean)value.getValue() != false, uri);
            this.uri = uri;
            return this;
        }

        <T> Builder setConnectionPropertyValue(ConnectionProperty<T> property, T value) {
            this.connectionPropertyValues.put(property.getKey(), new ConnectionPropertyValue<T>(property, value, value));
            return this;
        }

        public Builder setSessionPoolOptions(SessionPoolOptions sessionPoolOptions) {
            Preconditions.checkNotNull((Object)sessionPoolOptions);
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setCredentialsUrl(String credentialsUrl) {
            this.setConnectionPropertyValue(ConnectionProperties.CREDENTIALS_URL, credentialsUrl);
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.setConnectionPropertyValue(ConnectionProperties.OAUTH_TOKEN, oauthToken);
            return this;
        }

        @VisibleForTesting
        Builder setStatementExecutionInterceptors(List<StatementExecutionInterceptor> interceptors) {
            this.statementExecutionInterceptors = interceptors;
            return this;
        }

        @VisibleForTesting
        Builder setConfigurator(SpannerOptionsConfigurator configurator) {
            this.configurator = (SpannerOptionsConfigurator)Preconditions.checkNotNull((Object)configurator);
            return this;
        }

        @VisibleForTesting
        Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder setStatementExecutorType(StatementExecutor.StatementExecutorType statementExecutorType) {
            this.statementExecutorType = statementExecutorType;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public Builder setTracingPrefix(String tracingPrefix) {
            this.setConnectionPropertyValue(ConnectionProperties.TRACING_PREFIX, tracingPrefix);
            return this;
        }

        public ConnectionOptions build() {
            Preconditions.checkState((this.uri != null ? 1 : 0) != 0, (Object)"Connection URI is required");
            return new ConnectionOptions(this);
        }
    }

    @VisibleForTesting
    static interface SpannerOptionsConfigurator {
        public void configure(SpannerOptions.Builder var1);
    }

    public static interface ExternalChannelProvider {
        public TransportChannelProvider getChannelProvider(String var1, int var2);
    }
}

