/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Objects;

public class BatchTransactionId
implements Serializable {
    private final ByteString transactionId;
    private final String sessionId;
    private final Timestamp timestamp;
    private static final long serialVersionUID = 8067099123096783939L;

    @VisibleForTesting
    BatchTransactionId(String sessionId, ByteString transactionId, Timestamp timestamp) {
        this.transactionId = (ByteString)Preconditions.checkNotNull((Object)transactionId);
        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId);
        this.timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp);
    }

    ByteString getTransactionId() {
        return this.transactionId;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("transactionId: %s, sessionId: %s, timestamp: %s", this.transactionId.toStringUtf8(), this.sessionId, this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchTransactionId that = (BatchTransactionId)o;
        return Objects.equals(this.getTransactionId(), that.getTransactionId()) && Objects.equals(this.getTimestamp(), that.getTimestamp()) && Objects.equals(this.getSessionId(), that.getSessionId());
    }

    public int hashCode() {
        return Objects.hash(this.getTransactionId(), this.getTimestamp(), this.getSessionId());
    }
}

