/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractLazyInitializer;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.XGoogSpannerRequestId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.spanner.v1.BatchWriteResponse;
import io.opentelemetry.api.common.Attributes;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

class DatabaseClientImpl
implements DatabaseClient {
    private static final String READ_WRITE_TRANSACTION = "CloudSpanner.ReadWriteTransaction";
    private static final String READ_ONLY_TRANSACTION = "CloudSpanner.ReadOnlyTransaction";
    private static final String PARTITION_DML_TRANSACTION = "CloudSpanner.PartitionDMLTransaction";
    private final TraceWrapper tracer;
    private Attributes commonAttributes;
    @VisibleForTesting
    final String clientId;
    @VisibleForTesting
    final SessionPool pool;
    @VisibleForTesting
    final MultiplexedSessionDatabaseClient multiplexedSessionDatabaseClient;
    @VisibleForTesting
    final boolean useMultiplexedSessionPartitionedOps;
    @VisibleForTesting
    final boolean useMultiplexedSessionForRW;
    private final int dbId;
    private final AtomicInteger nthRequest;
    private final Map<String, Integer> clientIdToOrdinalMap;
    final boolean useMultiplexedSessionBlindWrite;
    private final AbstractLazyInitializer<Statement.StatementFactory> statementFactorySupplier = new AbstractLazyInitializer<Statement.StatementFactory>(){

        @Override
        protected Statement.StatementFactory initialize() {
            try {
                Dialect dialect = (Dialect)((Object)DatabaseClientImpl.this.getDialectAsync().get(30L, TimeUnit.SECONDS));
                return new Statement.StatementFactory(dialect);
            }
            catch (ExecutionException | TimeoutException e) {
                throw SpannerExceptionFactory.asSpannerException(e);
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }
    };

    @VisibleForTesting
    DatabaseClientImpl(SessionPool pool, TraceWrapper tracer) {
        this("", pool, false, null, false, tracer, false, Attributes.empty());
    }

    @VisibleForTesting
    DatabaseClientImpl(String clientId, SessionPool pool, TraceWrapper tracer) {
        this(clientId, pool, false, null, false, tracer, false, Attributes.empty());
    }

    DatabaseClientImpl(String clientId, SessionPool pool, boolean useMultiplexedSessionBlindWrite, @Nullable MultiplexedSessionDatabaseClient multiplexedSessionDatabaseClient, boolean useMultiplexedSessionPartitionedOps, TraceWrapper tracer, boolean useMultiplexedSessionForRW, Attributes commonAttributes) {
        this.clientId = clientId;
        this.pool = pool;
        this.useMultiplexedSessionBlindWrite = useMultiplexedSessionBlindWrite;
        this.multiplexedSessionDatabaseClient = multiplexedSessionDatabaseClient;
        this.useMultiplexedSessionPartitionedOps = useMultiplexedSessionPartitionedOps;
        this.tracer = tracer;
        this.useMultiplexedSessionForRW = useMultiplexedSessionForRW;
        this.commonAttributes = commonAttributes;
        this.clientIdToOrdinalMap = new HashMap<String, Integer>();
        this.dbId = this.dbIdFromClientId(this.clientId);
        this.nthRequest = new AtomicInteger(0);
    }

    @VisibleForTesting
    synchronized int dbIdFromClientId(String clientId) {
        Integer id = this.clientIdToOrdinalMap.get(clientId);
        if (id == null) {
            id = this.clientIdToOrdinalMap.size() + 1;
            this.clientIdToOrdinalMap.put(clientId, id);
        }
        return id;
    }

    @VisibleForTesting
    SessionPool.PooledSessionFuture getSession() {
        return this.pool.getSession();
    }

    @VisibleForTesting
    DatabaseClient getMultiplexedSession() {
        if (this.canUseMultiplexedSessions()) {
            return this.multiplexedSessionDatabaseClient;
        }
        return this.pool.getMultiplexedSessionWithFallback();
    }

    @VisibleForTesting
    DatabaseClient getMultiplexedSessionForRW() {
        if (this.canUseMultiplexedSessionsForRW()) {
            return this.getMultiplexedSession();
        }
        return this.getSession();
    }

    private MultiplexedSessionDatabaseClient getMultiplexedSessionDatabaseClient() {
        return this.canUseMultiplexedSessions() ? this.multiplexedSessionDatabaseClient : null;
    }

    private boolean canUseMultiplexedSessions() {
        return this.multiplexedSessionDatabaseClient != null && this.multiplexedSessionDatabaseClient.isMultiplexedSessionsSupported();
    }

    private boolean canUseMultiplexedSessionsForRW() {
        return this.useMultiplexedSessionForRW && this.multiplexedSessionDatabaseClient != null && this.multiplexedSessionDatabaseClient.isMultiplexedSessionsForRWSupported();
    }

    private boolean canUseMultiplexedSessionsForPartitionedOps() {
        return this.useMultiplexedSessionPartitionedOps && this.multiplexedSessionDatabaseClient != null && this.multiplexedSessionDatabaseClient.isMultiplexedSessionsForPartitionedOpsSupported();
    }

    @Override
    public Dialect getDialect() {
        MultiplexedSessionDatabaseClient client = this.getMultiplexedSessionDatabaseClient();
        if (client != null) {
            return client.getDialect();
        }
        return this.pool.getDialect();
    }

    @Override
    public Statement.StatementFactory getStatementFactory() {
        try {
            return this.statementFactorySupplier.get();
        }
        catch (Exception exception) {
            throw SpannerExceptionFactory.asSpannerException(exception);
        }
    }

    @Override
    @Nullable
    public String getDatabaseRole() {
        return this.pool.getDatabaseRole();
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        try {
            IScope s;
            block15: {
                s = this.tracer.withSpan(span);
                try {
                    if (!this.canUseMultiplexedSessionsForRW() || this.getMultiplexedSessionDatabaseClient() == null) break block15;
                    CommitResponse commitResponse = this.getMultiplexedSessionDatabaseClient().writeWithOptions(mutations, options);
                    if (s != null) {
                        s.close();
                    }
                    return commitResponse;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        span.setStatus(e);
                        throw e;
                    }
                }
            }
            CommitResponse commitResponse = this.runWithSessionRetry((session, reqId) -> session.writeWithOptions(mutations, this.withReqId((XGoogSpannerRequestId)reqId, options)));
            if (s != null) {
                s.close();
            }
            return commitResponse;
        }
        finally {
            span.end();
        }
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        try {
            IScope s;
            block15: {
                s = this.tracer.withSpan(span);
                try {
                    if (!this.useMultiplexedSessionBlindWrite || this.getMultiplexedSessionDatabaseClient() == null) break block15;
                    CommitResponse commitResponse = this.getMultiplexedSessionDatabaseClient().writeAtLeastOnceWithOptions(mutations, options);
                    if (s != null) {
                        s.close();
                    }
                    return commitResponse;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        span.setStatus(e);
                        throw e;
                    }
                }
            }
            CommitResponse commitResponse = this.runWithSessionRetry((session, reqId) -> session.writeAtLeastOnceWithOptions(mutations, this.withReqId((XGoogSpannerRequestId)reqId, options)));
            if (s != null) {
                s.close();
            }
            return commitResponse;
        }
        finally {
            span.end();
        }
    }

    private int nextNthRequest() {
        return this.nthRequest.incrementAndGet();
    }

    @VisibleForTesting
    int getNthRequest() {
        return this.nthRequest.get();
    }

    @Override
    public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        try {
            IScope s;
            block15: {
                s = this.tracer.withSpan(span);
                try {
                    if (!this.canUseMultiplexedSessionsForRW() || this.getMultiplexedSessionDatabaseClient() == null) break block15;
                    ServerStream<BatchWriteResponse> serverStream = this.getMultiplexedSessionDatabaseClient().batchWriteAtLeastOnce(mutationGroups, options);
                    if (s != null) {
                        s.close();
                    }
                    return serverStream;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        span.setStatus(e);
                        throw e;
                    }
                }
            }
            ServerStream serverStream = this.runWithSessionRetry((session, reqId) -> session.batchWriteAtLeastOnce(mutationGroups, this.withReqId((XGoogSpannerRequestId)reqId, options)));
            if (s != null) {
                s.close();
            }
            return serverStream;
        }
        finally {
            span.end();
        }
    }

    @Override
    public ReadContext singleUse() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadContext readContext = this.getMultiplexedSession().singleUse();
            if (s != null) {
                s.close();
            }
            return readContext;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadContext readContext = this.getMultiplexedSession().singleUse(bound);
            if (s != null) {
                s.close();
            }
            return readContext;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getMultiplexedSession().singleUseReadOnlyTransaction();
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getMultiplexedSession().singleUseReadOnlyTransaction(bound);
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getMultiplexedSession().readOnlyTransaction();
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        ISpan span = this.tracer.spanBuilder(READ_ONLY_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            ReadOnlyTransaction readOnlyTransaction = this.getMultiplexedSession().readOnlyTransaction(bound);
            if (s != null) {
                s.close();
            }
            return readOnlyTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        IScope s = this.tracer.withSpan(span);
        try {
            TransactionRunner transactionRunner = this.getMultiplexedSessionForRW().readWriteTransaction(options);
            if (s != null) {
                s.close();
            }
            return transactionRunner;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        IScope s = this.tracer.withSpan(span);
        try {
            TransactionManager transactionManager = this.getMultiplexedSessionForRW().transactionManager(options);
            if (s != null) {
                s.close();
            }
            return transactionManager;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        IScope s = this.tracer.withSpan(span);
        try {
            AsyncRunner asyncRunner = this.getMultiplexedSessionForRW().runAsync(options);
            if (s != null) {
                s.close();
            }
            return asyncRunner;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        ISpan span = this.tracer.spanBuilder(READ_WRITE_TRANSACTION, this.commonAttributes, options);
        IScope s = this.tracer.withSpan(span);
        try {
            AsyncTransactionManager asyncTransactionManager = this.getMultiplexedSessionForRW().transactionManagerAsync(options);
            if (s != null) {
                s.close();
            }
            return asyncTransactionManager;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        block3: {
            if (this.canUseMultiplexedSessionsForPartitionedOps()) {
                try {
                    return this.getMultiplexedSession().executePartitionedUpdate(stmt, options);
                }
                catch (SpannerException e) {
                    if (this.multiplexedSessionDatabaseClient.maybeMarkUnimplementedForPartitionedOps(e)) break block3;
                    throw e;
                }
            }
        }
        return this.executePartitionedUpdateWithPooledSession(stmt, options);
    }

    private Future<Dialect> getDialectAsync() {
        MultiplexedSessionDatabaseClient client = this.getMultiplexedSessionDatabaseClient();
        if (client != null) {
            return client.getDialectAsync();
        }
        return this.pool.getDialectAsync();
    }

    private Options.UpdateOption[] withReqId(XGoogSpannerRequestId reqId, Options.UpdateOption ... options) {
        if (reqId == null) {
            return options;
        }
        if (options == null || options.length == 0) {
            return new Options.UpdateOption[]{new Options.RequestIdOption(reqId)};
        }
        Options.UpdateOption[] allOptions = new Options.UpdateOption[options.length + 1];
        System.arraycopy(options, 0, allOptions, 0, options.length);
        allOptions[options.length] = new Options.RequestIdOption(reqId);
        return allOptions;
    }

    private Options.TransactionOption[] withReqId(XGoogSpannerRequestId reqId, Options.TransactionOption ... options) {
        if (reqId == null) {
            return options;
        }
        if (options == null || options.length == 0) {
            return new Options.TransactionOption[]{new Options.RequestIdOption(reqId)};
        }
        Options.TransactionOption[] allOptions = new Options.TransactionOption[options.length + 1];
        System.arraycopy(options, 0, allOptions, 0, options.length);
        allOptions[options.length] = new Options.RequestIdOption(reqId);
        return allOptions;
    }

    private long executePartitionedUpdateWithPooledSession(Statement stmt, Options.UpdateOption ... options) {
        ISpan span = this.tracer.spanBuilder(PARTITION_DML_TRANSACTION, this.commonAttributes);
        IScope s = this.tracer.withSpan(span);
        try {
            long l = this.runWithSessionRetry((session, reqId) -> session.executePartitionedUpdate(stmt, this.withReqId((XGoogSpannerRequestId)reqId, options)));
            if (s != null) {
                s.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                span.setStatus(e);
                span.end();
                throw e;
            }
        }
    }

    @VisibleForTesting
    <T> T runWithSessionRetry(BiFunction<Session, XGoogSpannerRequestId, T> callable) {
        SessionPool.PooledSessionFuture session = this.getSession();
        XGoogSpannerRequestId reqId = XGoogSpannerRequestId.of(this.dbId, session.getChannel(), this.nextNthRequest(), 1L);
        while (true) {
            try {
                return callable.apply(session, reqId);
            }
            catch (SessionNotFoundException e) {
                session = this.pool.getPooledSessionReplacementHandler().replaceSession(e, session);
                reqId = XGoogSpannerRequestId.of(this.dbId, session.getChannel(), this.nextNthRequest(), 1L);
                continue;
            }
            break;
        }
    }

    boolean isValid() {
        return this.pool.isValid() && (this.multiplexedSessionDatabaseClient == null || this.multiplexedSessionDatabaseClient.isValid() || !this.multiplexedSessionDatabaseClient.isMultiplexedSessionsSupported());
    }

    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        if (this.multiplexedSessionDatabaseClient != null) {
            this.multiplexedSessionDatabaseClient.close();
        }
        return this.pool.closeAsync(closedException);
    }
}

