/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.Preconditions;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class Interval
implements Serializable {
    private final int months;
    private final int days;
    private final BigInteger nanos;
    private static final long MONTHS_PER_YEAR = 12L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_MILLI = 1000L;
    private static final long NANOS_PER_MICRO = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final long MICROS_PER_MINUTE = 60000000L;
    private static final long MICROS_PER_HOUR = 3600000000L;
    private static final BigInteger NANOS_PER_MILLI = BigInteger.valueOf(1000000L);
    private static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    private static final BigInteger NANOS_PER_MINUTE = BigInteger.valueOf(60000000000L);
    private static final BigInteger NANOS_PER_HOUR = BigInteger.valueOf(3600000000000L);
    private static final Interval ZERO = Interval.builder().build();
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("^P(?!$)(-?\\d+Y)?(-?\\d+M)?(-?\\d+D)?(T(?=-?[.,]?\\d)(-?\\d+H)?(-?\\d+M)?(-?((\\d+([.,]\\d{1,9})?)|([.,]\\d{1,9}))S)?)?$");

    private Interval(int months, int days, BigInteger nanos) {
        this.months = months;
        this.days = days;
        this.nanos = nanos;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public BigInteger getNanos() {
        return this.nanos;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Interval ofMonths(int months) {
        return Interval.builder().setMonths(months).build();
    }

    public static Interval ofDays(int days) {
        return Interval.builder().setDays(days).build();
    }

    public static Interval ofSeconds(long seconds) {
        return Interval.builder().setNanos(BigInteger.valueOf(seconds).multiply(NANOS_PER_SECOND)).build();
    }

    public static Interval ofMillis(long millis) {
        return Interval.builder().setNanos(BigInteger.valueOf(millis).multiply(NANOS_PER_MILLI)).build();
    }

    public static Interval ofMicros(long micros) {
        return Interval.builder().setNanos(BigInteger.valueOf(micros).multiply(BigInteger.valueOf(1000L))).build();
    }

    public static Interval ofNanos(BigInteger nanos) {
        return Interval.builder().setNanos(nanos).build();
    }

    public static Interval fromMonthsDaysNanos(int months, int days, BigInteger nanos) {
        return Interval.builder().setMonths(months).setDays(days).setNanos(nanos).build();
    }

    private static String getNullOrDefault(Matcher matcher, int groupIdx) {
        String value = matcher.group(groupIdx);
        return value == null ? "0" : value;
    }

    public static Interval parseFromString(String interval) {
        Matcher matcher = INTERVAL_PATTERN.matcher(interval);
        if (!matcher.matches()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid Interval String: " + interval);
        }
        long years = Long.parseLong(Interval.getNullOrDefault(matcher, 1).replace("Y", ""));
        long months = Long.parseLong(Interval.getNullOrDefault(matcher, 2).replace("M", ""));
        long days = Long.parseLong(Interval.getNullOrDefault(matcher, 3).replace("D", ""));
        long hours = Long.parseLong(Interval.getNullOrDefault(matcher, 5).replace("H", ""));
        long minutes = Long.parseLong(Interval.getNullOrDefault(matcher, 6).replace("M", ""));
        BigDecimal seconds = new BigDecimal(Interval.getNullOrDefault(matcher, 7).replace("S", "").replace(",", "."));
        long totalMonths = Math.addExact(Math.multiplyExact(years, 12L), months);
        BigInteger totalNanos = seconds.movePointRight(9).toBigInteger();
        totalNanos = totalNanos.add(BigInteger.valueOf(minutes * 60L).multiply(NANOS_PER_SECOND));
        totalNanos = totalNanos.add(BigInteger.valueOf(hours * 3600L).multiply(NANOS_PER_SECOND));
        return Interval.builder().setMonths(Math.toIntExact(totalMonths)).setDays(Math.toIntExact(days)).setNanos(totalNanos).build();
    }

    public String toISO8601() {
        BigInteger zero;
        BigInteger nanos;
        if (this.equals(ZERO)) {
            return "P0Y";
        }
        StringBuilder result = new StringBuilder();
        result.append("P");
        long monthsPart = this.getMonths();
        long yearsPart = monthsPart / 12L;
        monthsPart -= yearsPart * 12L;
        if (yearsPart != 0L) {
            result.append(String.format("%dY", yearsPart));
        }
        if (monthsPart != 0L) {
            result.append(String.format("%dM", monthsPart));
        }
        if (this.getDays() != 0) {
            result.append(String.format("%dD", this.getDays()));
        }
        if ((nanos = this.getNanos()).compareTo(zero = BigInteger.valueOf(0L)) != 0) {
            result.append("T");
            BigInteger hoursPart = nanos.divide(NANOS_PER_HOUR);
            nanos = nanos.subtract(hoursPart.multiply(NANOS_PER_HOUR));
            if (hoursPart.compareTo(zero) != 0) {
                result.append(String.format("%sH", hoursPart));
            }
            BigInteger minutesPart = nanos.divide(NANOS_PER_MINUTE);
            nanos = nanos.subtract(minutesPart.multiply(NANOS_PER_MINUTE));
            if (minutesPart.compareTo(zero) != 0) {
                result.append(String.format("%sM", minutesPart));
            }
            if (!nanos.equals(zero)) {
                String secondsSign = "";
                if (nanos.signum() == -1) {
                    secondsSign = "-";
                    nanos = nanos.negate();
                }
                BigInteger seconds_part = nanos.divide(NANOS_PER_SECOND);
                nanos = nanos.subtract(seconds_part.multiply(NANOS_PER_SECOND));
                result.append(String.format("%s%s", secondsSign, seconds_part));
                if (!nanos.equals(zero)) {
                    result.append(String.format(".%09d", nanos).replaceAll("(0{3})+$", ""));
                }
                result.append("S");
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toISO8601();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Interval)) {
            return false;
        }
        Interval anotherInterval = (Interval)rhs;
        return this.getMonths() == anotherInterval.getMonths() && this.getDays() == anotherInterval.getDays() && this.getNanos().equals(anotherInterval.getNanos());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.valueOf(this.getMonths()).hashCode();
        result = 31 * result + Integer.valueOf(this.getDays()).hashCode();
        result = 31 * result + this.getNanos().hashCode();
        return result;
    }

    public static class Builder {
        private int months = 0;
        private int days = 0;
        private BigInteger nanos = BigInteger.ZERO;

        Builder setMonths(int months) {
            this.months = months;
            return this;
        }

        Builder setDays(int days) {
            this.days = days;
            return this;
        }

        Builder setNanos(BigInteger nanos) {
            this.nanos = (BigInteger)Preconditions.checkNotNull((Object)nanos);
            return this;
        }

        public Interval build() {
            return new Interval(this.months, this.days, this.nanos);
        }
    }
}

