/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.GrpcStruct;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Type;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.util.List;
import javax.annotation.Nullable;

class NoRowsResultSet
extends AbstractResultSet<List<Object>> {
    private final ResultSetStats stats;
    private final ResultSetMetadata metadata;

    NoRowsResultSet(ResultSet resultSet) {
        this.stats = resultSet.getStats();
        this.metadata = resultSet.getMetadata();
    }

    @Override
    protected GrpcStruct currRow() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "This result set has no rows");
    }

    @Override
    public boolean next() throws SpannerException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public ResultSetStats getStats() {
        return this.stats;
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Type getType() {
        return Type.struct(new Type.StructField[0]);
    }
}

