/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiClock;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.RetryHelper;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorHandler;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.grpc.Context;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;

class SpannerRetryHelper {
    @VisibleForTesting
    static final RetrySettings txRetrySettings = SpannerStubSettings.newBuilder().rollbackSettings().getRetrySettings().toBuilder().setTotalTimeoutDuration(Duration.ofHours(24L)).setMaxAttempts(0).build();

    SpannerRetryHelper() {
    }

    static <T> T runTxWithRetriesOnAborted(Callable<T> callable) {
        return SpannerRetryHelper.runTxWithRetriesOnAborted(callable, ErrorHandler.DefaultErrorHandler.INSTANCE);
    }

    static <T> T runTxWithRetriesOnAborted(Callable<T> callable, ErrorHandler errorHandler) {
        return SpannerRetryHelper.runTxWithRetriesOnAborted(callable, errorHandler, txRetrySettings, NanoClock.getDefaultClock());
    }

    @VisibleForTesting
    static <T> T runTxWithRetriesOnAborted(Callable<T> callable, RetrySettings retrySettings, ApiClock clock) {
        return SpannerRetryHelper.runTxWithRetriesOnAborted(callable, ErrorHandler.DefaultErrorHandler.INSTANCE, retrySettings, clock);
    }

    @VisibleForTesting
    static <T> T runTxWithRetriesOnAborted(Callable<T> callable, ErrorHandler errorHandler, RetrySettings retrySettings, ApiClock clock) {
        try {
            return (T)RetryHelper.runWithRetries(callable, (RetrySettings)retrySettings, new TxRetryAlgorithm(), (ApiClock)clock);
        }
        catch (RetryHelper.RetryHelperException e) {
            if (e.getCause() != null) {
                Throwables.throwIfUnchecked((Throwable)errorHandler.translateException(e.getCause()));
            }
            throw e;
        }
    }

    private static class TxRetryAlgorithm<T>
    implements ResultRetryAlgorithm<T> {
        private TxRetryAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
            long retryDelay;
            if (prevThrowable != null && (retryDelay = SpannerException.extractRetryDelay(prevThrowable)) > -1L) {
                return prevSettings.toBuilder().setRandomizedRetryDelayDuration(Duration.ofMillis(retryDelay)).build();
            }
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, T prevResponse) throws CancellationException {
            if (Context.current().isCancelled()) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(Context.current(), null, null);
            }
            return prevThrowable instanceof AbortedException || prevThrowable instanceof com.google.api.gax.rpc.AbortedException;
        }
    }
}

