/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;

class SimpleParser {
    private final AbstractStatementParser statementParser;
    private final String sql;
    private final int length;
    private final boolean treatHintCommentsAsTokens;
    private int pos;

    SimpleParser(Dialect dialect, String sql) {
        this(dialect, sql, 0, false);
    }

    SimpleParser(Dialect dialect, String sql, int pos, boolean treatHintCommentsAsTokens) {
        Preconditions.checkArgument((!treatHintCommentsAsTokens || dialect == Dialect.POSTGRESQL ? 1 : 0) != 0, (Object)"treatHintCommentsAsTokens can only be enabled for PostgreSQL");
        this.sql = sql;
        this.length = sql.length();
        this.pos = pos;
        this.statementParser = AbstractStatementParser.getInstance(dialect);
        this.treatHintCommentsAsTokens = treatHintCommentsAsTokens;
    }

    Dialect getDialect() {
        return this.statementParser.getDialect();
    }

    String getSql() {
        return this.sql;
    }

    int getPos() {
        return this.pos;
    }

    void skipHint() {
        if (this.getDialect() == Dialect.GOOGLE_STANDARD_SQL && this.eatTokens('@', '{')) {
            while (this.pos < this.length && !this.eatToken('}')) {
                this.pos = this.statementParser.skip(this.sql, this.pos, null);
            }
        }
    }

    Result eatNextKeyword() {
        this.skipHint();
        boolean inParenthesis = false;
        while (this.pos < this.length && this.eatToken('(')) {
            inParenthesis = true;
        }
        return this.eatKeyword(inParenthesis);
    }

    boolean hasMoreTokens() {
        this.skipWhitespaces();
        return this.pos < this.sql.length();
    }

    Result eatKeyword() {
        return this.eatKeyword(false);
    }

    Result eatKeyword(boolean inParenthesis) {
        if (!this.hasMoreTokens()) {
            return Result.NOT_FOUND;
        }
        if (!Character.isLetter(this.sql.charAt(this.pos))) {
            return Result.NOT_FOUND;
        }
        int startPos = this.pos;
        while (this.pos < this.length && Character.isLetter(this.sql.charAt(this.pos))) {
            ++this.pos;
        }
        return Result.found(this.sql.substring(startPos, this.pos), inParenthesis);
    }

    Result eatIdentifier() {
        if (!this.hasMoreTokens()) {
            return Result.NOT_FOUND;
        }
        if (!SimpleParser.isValidIdentifierFirstChar(this.sql.charAt(this.pos))) {
            return Result.NOT_FOUND;
        }
        int startPos = this.pos;
        while (this.pos < this.sql.length() && SimpleParser.isValidIdentifierChar(this.sql.charAt(this.pos))) {
            ++this.pos;
        }
        return Result.found(this.sql.substring(startPos, this.pos));
    }

    Result eatSingleQuotedString() {
        if (!this.eatToken('\'')) {
            return Result.NOT_FOUND;
        }
        int startPos = this.pos;
        while (this.pos < this.sql.length() && this.sql.charAt(this.pos) != '\'') {
            if (this.sql.charAt(this.pos) == '\n') {
                return Result.NOT_FOUND;
            }
            ++this.pos;
        }
        if (this.pos == this.sql.length()) {
            return Result.NOT_FOUND;
        }
        return Result.found(this.sql.substring(startPos, this.pos++));
    }

    boolean peekTokens(char ... tokens) {
        return this.internalEatTokens(false, tokens);
    }

    boolean eatTokens(char ... tokens) {
        return this.internalEatTokens(true, tokens);
    }

    private boolean internalEatTokens(boolean updatePos, char ... tokens) {
        int currentPos = this.pos;
        for (char token : tokens) {
            if (this.eatToken(token)) continue;
            this.pos = currentPos;
            return false;
        }
        if (!updatePos) {
            this.pos = currentPos;
        }
        return true;
    }

    boolean peekToken(char token) {
        int currentPos = this.pos;
        boolean res = this.eatToken(token);
        this.pos = currentPos;
        return res;
    }

    boolean eatToken(char token) {
        this.skipWhitespaces();
        if (this.pos < this.sql.length() && this.sql.charAt(this.pos) == token) {
            ++this.pos;
            return true;
        }
        return false;
    }

    boolean eatKeyword(String ... keywords) {
        return this.eat(true, true, keywords);
    }

    boolean eat(boolean skipWhitespaceBefore, boolean requireWhitespaceAfter, String ... keywords) {
        boolean result = true;
        for (String keyword : keywords) {
            result &= this.internalEat(keyword, skipWhitespaceBefore, requireWhitespaceAfter, true);
        }
        return result;
    }

    private boolean internalEat(String keyword, boolean skipWhitespaceBefore, boolean requireWhitespaceAfter, boolean updatePos) {
        int originalPos = this.pos;
        if (skipWhitespaceBefore) {
            this.skipWhitespaces();
        }
        if (this.pos + keyword.length() > this.sql.length()) {
            if (!updatePos) {
                this.pos = originalPos;
            }
            return false;
        }
        if (this.sql.substring(this.pos, this.pos + keyword.length()).equalsIgnoreCase(keyword) && (!requireWhitespaceAfter || this.isValidEndOfKeyword(this.pos + keyword.length()))) {
            this.pos = updatePos ? (this.pos += keyword.length()) : originalPos;
            return true;
        }
        if (!updatePos) {
            this.pos = originalPos;
        }
        return false;
    }

    private boolean isValidEndOfKeyword(int index) {
        if (this.sql.length() == index) {
            return true;
        }
        return !SimpleParser.isValidIdentifierChar(this.sql.charAt(index));
    }

    static boolean isValidIdentifierFirstChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    static boolean isValidIdentifierChar(char c) {
        return SimpleParser.isValidIdentifierFirstChar(c) || Character.isDigit(c) || c == '$';
    }

    @VisibleForTesting
    void skipWhitespaces() {
        while (this.pos < this.sql.length()) {
            if (this.sql.charAt(this.pos) == '-' && this.sql.length() > this.pos + 1 && this.sql.charAt(this.pos + 1) == '-') {
                this.skipSingleLineComment(2);
                continue;
            }
            if (this.statementParser.supportsHashSingleLineComments() && this.sql.charAt(this.pos) == '#') {
                this.skipSingleLineComment(1);
                continue;
            }
            if (this.sql.charAt(this.pos) == '/' && this.sql.length() > this.pos + 1 && this.sql.charAt(this.pos + 1) == '*') {
                if (this.treatHintCommentsAsTokens && this.sql.length() > this.pos + 2 && this.sql.charAt(this.pos + 2) == '@') break;
                this.skipMultiLineComment();
                continue;
            }
            if (!Character.isWhitespace(this.sql.charAt(this.pos))) break;
            ++this.pos;
        }
    }

    @VisibleForTesting
    boolean skipSingleLineComment(int prefixLength) {
        int endIndex = this.sql.indexOf(10, this.pos + prefixLength);
        if (endIndex == -1) {
            this.pos = this.sql.length();
            return true;
        }
        this.pos = endIndex + 1;
        return true;
    }

    @VisibleForTesting
    boolean skipMultiLineComment() {
        int level = 1;
        this.pos += 2;
        while (this.pos < this.sql.length()) {
            if (this.statementParser.supportsNestedComments() && this.sql.charAt(this.pos) == '/' && this.sql.length() > this.pos + 1 && this.sql.charAt(this.pos + 1) == '*') {
                ++level;
            }
            if (this.sql.charAt(this.pos) == '*' && this.sql.length() > this.pos + 1 && this.sql.charAt(this.pos + 1) == '/' && --level == 0) {
                this.pos += 2;
                return true;
            }
            ++this.pos;
        }
        this.pos = this.sql.length();
        return false;
    }

    static class Result {
        static final Result NOT_FOUND = new Result(null, false);
        private final String value;
        private final boolean inParenthesis;

        static Result found(String value) {
            return new Result((String)Preconditions.checkNotNull((Object)value), false);
        }

        static Result found(String value, boolean inParenthesis) {
            return new Result((String)Preconditions.checkNotNull((Object)value), inParenthesis);
        }

        private Result(String value, boolean inParenthesis) {
            this.value = value;
            this.inParenthesis = inParenthesis;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Result)) {
                return false;
            }
            return Objects.equals(this.value, ((Result)o).value) && Objects.equals(this.inParenthesis, ((Result)o).inParenthesis);
        }

        public String toString() {
            if (this.isValid()) {
                return this.value;
            }
            return "NOT FOUND";
        }

        boolean isValid() {
            return this.value != null;
        }

        String getValue() {
            return this.value;
        }

        boolean isInParenthesis() {
            return this.inParenthesis;
        }
    }
}

